/***************************************************************************
                          TDEJavaSlot.cpp  -  description
                             -------------------
    copyright            : (C) 2000-2001 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "TDEJavaSlot.moc"
#include <qtjava/QtSupport.h>
#include <tdejava/TDESupport.h>

/*
 Converts a Java type signature, from a signal or slot, to the corresponding C++ KDE type.
 Used to connect a Java slot to a signal emitted by the underlying C++ KDE instance.
 Note that all Java slots and signals are of type jobjectArray, and so no conversion is needed for them.
*/
static const char * const javaToQtTypeSignatureMap[][2] = {
	{"(int)",													"(int)"},
	{"(Node)",													"(const DOM::Node&)"},
	{"(Node,long)",												"(const DOM::Node&,long)"},
	{"(KBookmark,TQPopupMenu)",									"(const KBookmark&,TQPopupMenu*)"},
	{"(KDataToolInfo,String)",									"(const KDataToolInfo&,const TQString&)"},
	{"(KFileItem)",												"(const KFileItem*)"},
	{"(KFileItem,TQPixmap)",										"(const KFileItem*,const TQPixmap&)"},
	{"(KFileItem,TQPoint)",										"(const KFileItem*,const TQPoint&)"},
	{"(KFileItemList)",											"(const KFileItemList&)"},
	{"(KFileItem,TQDropEvent,ArrayList)",						"(const KFileItem*,TQDropEvent*,const KURL::List&)"},
	{"(TDEShortcut)",												"(const TDEShortcut&)"},
	{"(KURL)",													"(const KURL&)"},
	{"(KURL,KURL)",												"(const KURL&,const KURL&)"},
	{"(KURL,TQPixmap)",											"(const KURL&,const TQPixmap&)"},
	{"(KURL,String)",											"(const KURL&,const TQString&)"},
	{"(KURL,URLArgs)",											"(const KURL&,const KParts::URLArgs&)"},
	{"(ArrayList)",												"(const KURL::List&)"},
	{"(TQPoint,ArrayList)",										"(const TQPoint&,const KFileItemList&)"},
	{"(TQPoint,KURL,String)",									"(const TQPoint&,const KURL&,const TQString&)"},
	{"(TQPoint,KURL,String,int)",								"(const TQPoint&,const KURL&,const TQString&,mode_t)"},
	{"(TDEAction)",												"(TDEAction*)"},
	{"(TDEAction,boolean)",										"(TDEAction*,bool)"},
	{"(int)",													"(TDECompletionBase::KeyBindingType)"},
	{"(KDockWidget)",											"(KDockWidget*)"},
	{"(KDockWidget,KDockWidget)",								"(KDockWidget*,KDockWidget*)"},
	{"(KDockWidget,int)",										"(KDockWidget*,KDockWidget::DockPosition)"},
	{"(int)",													"(KDualColorButton::DualColor)"},
	{"(KFileItem)",												"(KFileItem*)"},
	{"(KFileTreeViewItem)",										"(KFileTreeViewItem*)"},
	{"(KFileTreeViewItem,int)",									"(KFileTreeViewItem*,int)"},
	{"(KFileTreeView,TQDropEvent,TQListViewItem)",				"(KFileTreeView*,TQDropEvent*,TQListViewItem*)"},
	{"(KFileTreeView,TQDropEvent,TQListViewItem,TQListViewItem)",	"(KFileTreeView*,TQDropEvent*,TQListViewItem*,TQListViewItem*)"},
	{"(KFileView)",												"(KFileView*)"},
	{"(int)",													"(TDEGlobalSettings::Completion)"},
	{"(Job)",													"(TDEIO::Job*)"},
	{"(Job,KURL)",												"(TDEIO::Job*,const KURL&)"},
	{"Job,KURL,KURL)",											"(TDEIO::Job*,const KURL&,const KURL&)"},
	{"Job,KURL,KURL,boolean,boolean)",							"(TDEIO::Job*,const KURL&,const KURL&,bool,bool)"},
	{"Job,KURL,String,KURL)",									"(TDEIO::Job*,const KURL&,const TQString&,const KURL&)"},
	{"Job,byte[])",												"(TDEIO::Job*,const TQByteArray&)"},
	{"Job,String)",												"(TDEIO::Job*,const TQString&)"},
	{"Job,String,KURL)",										"(TDEIO::Job*,const TQString&,const KURL&)"},
	{"Job,long)",												"(TDEIO::Job*,TDEIO::filesize_t)"},
	{"Job,ByteArrayOutputStream)",								"(TDEIO::Job*,TQByteArray&)"},
	{"Job,long)",												"(TDEIO::Job*,unsigned long)"},
	{"(Slave)",													"(TDEIO::Slave*)"},
	{"(SkipDlg,int)",											"(TDEIO::SkipDlg*,int)"},
	{"(Slave,int,String)",										"(TDEIO::Slave*,int,const TQString&)"},
	{"(TDEListView,TQDropEvent,TQListViewItem)",					"(TDEListView*,TQDropEvent*,TQListViewItem*)"},
	{"(TDEListView,TQDropEvent,TQListViewItem,TQListViewItem)",		"(TDEListView*,TQDropEvent*,TQListViewItem*,TQListViewItem*)"},
	{"(TDEListView,TQListViewItem)",								"(TDEListView*,TQListViewItem*)"},
	{"(TDEListView,TQListViewItem,TQPoint)",						"(TDEListView*,TQListViewItem*,const TQPoint&)"},
	{"(KMdiChildFrm)",											"(KMdiChildFrm*)"},
	{"(KMdiChildFrm,KMdiChildFrm)",								"(KMdiChildFrm*,KMdiChildFrm*)"},
	{"(KMdiChildView)",											"(KMdiChildView*)"},
	{"(KMdiChildView,boolean)",									"(KMdiChildView*,bool)"},
	{"(int)",													"(KMdi::MdiMode)"},
	{"(Part)",													"(KParts::Part*)"},
	{"(TDEPopupMenu,Calendar)",									"(TDEPopupMenu*,const TQDate&)"},
	{"(TDEPopupMenu,int,TQPopupMenu)",								"(TDEPopupMenu*,int,TQPopupMenu*)"},
	{"(TDEProcess)",												"(TDEProcess*)"},
	{"(TDEProcess,String,int)",									"(TDEProcess*,char*,int)"},
	{"(KProcIO)",												"(KProcIO*)"},
	{"(KSpell)",												"(KSpell*)"},
	{"(int)",													"(TDEToolBar::BarPosition)"},
	{"(ArrayList,KURL)",										"(KURL::List&,KURL&)"},
	{"(KURLRequester)",											"(KURLRequester*)"},
	{"(KXMLGUIClient)",											"(KXMLGUIClient*)"},
	{"(KXMLGUIClient,TQPoint,KFileItemList)",					"(KXMLGUIClient*,const TQPoint&,const KFileItemList&)"},
	{"(KXMLGUIClient,TQPoint,KURL,String)",						"(KXMLGUIClient*,const TQPoint&,const KURL&,const TQString&)"},
	{"(KXMLGUIClient,TQPoint,KURL,String,int)",					"(KXMLGUIClient*,const TQPoint&,const KURL&,const TQString&,mode_t)"},
	{"(int,String,String,boolean)",								"(pid_t,const TQCString&,const TQString&,bool)"},
	{"(TQDropEvent,ArrayList,KURL)",								"(TQDropEvent*,const KURL::List&,const KURL&)"},
	{"(TQDropEvent,KFileItem)",									"(TQDropEvent*,KFileItem*)"},
	{"(TQWidget,TQDropEvent,ArrayList)",							"(TQWidget*,TQDropEvent*,KURL::List&)"},
	{"(TQWidget,TQDropEvent,ArrayList,KURL)",						"(TQWidget*,TQDropEvent*,KURL::List&,KURL&)"}
};

TDEJavaSlot::TDEJavaSlot(JNIEnv * env, jobject receiver, jstring slot)
	: JavaSlot(env, receiver, slot)
{
}

TDEJavaSlot::~TDEJavaSlot()
{
}


const char *
TDEJavaSlot::javaToQtSignalType(const char * signalName, const char * javaTypeSignature, TQMetaObject * smeta)
{
static char qtSignalString[200];

	for (	unsigned int index = 0;
			index < sizeof(javaToQtTypeSignatureMap)/sizeof(*javaToQtTypeSignatureMap);
			index++ )
	{
		if (strcmp(javaTypeSignature, javaToQtTypeSignatureMap[index][0]) == 0) {
			(void) sprintf(qtSignalString, "%s%s", signalName, javaToQtTypeSignatureMap[index][1]);

			if (smeta == 0 || smeta->findSignal(((const char *) qtSignalString + 1), TRUE) >= 0) {
				return qtSignalString;
			}
		}
	}

	return JavaSlot::javaToQtSignalType(signalName, javaTypeSignature, smeta);
}

const char *
TDEJavaSlot::javaToQtSlotType(const char * javaTypeSignature, const char * signalString)
{
	for (	unsigned int index = 0;
			index < sizeof(javaToQtTypeSignatureMap)/sizeof(*javaToQtTypeSignatureMap);
			index++ )
	{
		if (	strcmp(javaTypeSignature, javaToQtTypeSignatureMap[index][0]) == 0
				&& (	signalString == 0
						|| TQObject::checkConnectArgs(signalString, (const TQObject *) 0, javaToQtTypeSignatureMap[index][1]) ) )
		{
			return javaToQtTypeSignatureMap[index][1];
		}
	}

	return JavaSlot::javaToQtSlotType(javaTypeSignature, signalString);
}

void
TDEJavaSlot::invoke(const DOM::Node& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.DOMNode") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const DOM::Node& arg1,long arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.DOMNode"), (jlong) arg2 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KBookmark& arg1,TQPopupMenu* arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KBookmark"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQPopupMenu") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KDataToolInfo& arg1,const TQString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KDataToolInfo"),
									QtSupport::fromTQString(env, (TQString *) &arg2) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KFileItem* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KFileItem* arg1,const TQPixmap& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileItem"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.qt.TQPixmap") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KFileItem* arg1,const TQPoint& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileItem"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.qt.TQPoint") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KFileItem* arg1,TQDropEvent* arg2,const KURL::List& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileItem"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg3) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KFileItemList& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									KDESupport::arrayWithKFileItemList(env, (KFileItemList*) &arg1) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const TDEShortcut& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.TDEShortcut") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KURL& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KURL& arg1,const KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KURL& arg1,const TQPixmap& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.qt.TQPixmap") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KURL& arg1,const TQString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KURL"),
									QtSupport::fromTQString(env, (TQString *) &arg2) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KURL&arg1, const KParts::URLArgs& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.URLArgs") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const KURL::List& arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, KDESupport::arrayWithKURLList(env, (KURL::List *) &arg1));
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const TQPoint& arg1,const KFileItemList& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.qt.TQPoint"),
									KDESupport::arrayWithKFileItemList(env, (KFileItemList*) &arg2) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const TQPoint& arg1,const KURL& arg2,const TQString& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.qt.TQPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL"),
									QtSupport::fromTQString(env, (TQString*) &arg3) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(const TQPoint& arg1,const KURL& arg2,const TQString& arg3,mode_t arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) &arg1, "org.trinitydesktop.qt.TQPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL"),
									QtSupport::fromTQString(env, (TQString*) &arg3),
									(jint) arg4 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEAction* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEAction"));
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEAction* arg1,bool arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEAction"), (jboolean) arg2);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDECompletionBase::KeyBindingType arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KDockWidget* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KDockWidget"));
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KDockWidget*arg1,KDockWidget*arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KDockWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.koala.KDockWidget") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KDockWidget*arg1,KDockWidget::DockPosition arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KDockWidget"), (jint) arg2);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KDualColorButton::DualColor arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KFileItem* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KFileTreeView* arg1,TQDropEvent* arg2,TQListViewItem* arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileTreeView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.trinitydesktop.qt.TQListViewItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KFileTreeView* arg1,TQDropEvent* arg2,TQListViewItem* arg3,TQListViewItem* arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileTreeView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.trinitydesktop.qt.TQListViewItem"),
									QtSupport::objectForQtKey(env, (void *) arg4, "org.trinitydesktop.qt.TQListViewItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KFileTreeViewItem* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileTreeViewItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KFileTreeViewItem* arg1,int arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileTreeViewItem"),
									(jint) arg2 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KFileView* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KFileView") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEGlobalSettings::Completion arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const KURL& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const KURL& arg2,const KURL& arg3,bool arg4,bool arg5)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;ZZ)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.koala.KURL"),
									(jboolean) arg4,
									(jboolean) arg5 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const KURL& arg2,const TQString& arg3,const KURL& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL"),
									QtSupport::fromTQString(env, (TQString *) &arg3),
									QtSupport::objectForQtKey(env, (void *) &arg4, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const TQByteArray& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;[B)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}

	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::fromTQByteArray(env, (TQByteArray*) &arg2) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const TQString& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::fromTQString(env, (TQString *) &arg2) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,const TQString& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									QtSupport::fromTQString(env, (TQString *) &arg2),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,TDEIO::filesize_t arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									(jlong) arg2 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,TQByteArray& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jclass          byteStreamClass;
	jmethodID       resetMid;
	jobject         result;
	jobject         byteStream;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}

	byteStream = QtSupport::objectForQtKey(env, (void *) &arg2, "java.io.ByteArrayOutputStream");

	byteStreamClass = env->GetObjectClass(byteStream);
	resetMid = env->GetMethodID(byteStreamClass, "reset", "()V");
	if (resetMid == NULL) {
		return ;
	}

	env->CallVoidMethod(byteStream, resetMid);

	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									byteStream );
	(void) KDESupport::toTQByteArrayFromStream(env, &arg2, byteStream);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Job* arg1,unsigned long arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;J)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Job"),
									(jlong) arg2 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::SkipDlg* arg1,int arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.SkipDlg"),
									(jint) arg2 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Slave* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Slave") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEIO::Slave* arg1,int arg2,const TQString& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;ILjava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Slave"),
									(jint) arg2,
									QtSupport::fromTQString(env, (TQString *) &arg3) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEListView*arg1,TQDropEvent*arg2,TQListViewItem*arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.trinitydesktop.qt.TQListViewItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEListView*arg1,TQDropEvent*arg2,TQListViewItem*arg3,TQListViewItem*arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									QtSupport::objectForQtKey(env, (void *) arg3, "org.trinitydesktop.qt.TQListViewItem"),
									QtSupport::objectForQtKey(env, (void *) arg4, "org.trinitydesktop.qt.TQListViewItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEListView*arg1,TQListViewItem*arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQListViewItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEListView*arg1,TQListViewItem*arg2,const TQPoint&arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEListView"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQListViewItem"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.qt.TQPoint") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KMdiChildFrm* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KMdiChildFrm"));
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KMdiChildFrm* arg1,KMdiChildFrm* arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KMdiChildFrm"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.koala.KMdiChildFrm") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KMdiChildView* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KMdiChildView"));
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KMdiChildView* arg1,bool arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KMdiChildView"), (jboolean) arg2);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KMdi::MdiMode arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KParts::Part* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.Part") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEPopupMenu* arg1,const TQDate& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEPopupMenu"),
									QtSupport::fromTQDate(env, (TQDate*) &arg2) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEPopupMenu* arg1,int arg2,TQPopupMenu* arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;ILjava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation, mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEPopupMenu"),
									(jint) arg2,
									QtSupport::objectForQtKey(env, (void *) arg3, "org.trinitydesktop.koala.TQPopupMenu") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEProcess* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEProcess") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEProcess* arg1,char* arg2, int arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.TDEProcess"),
									QtSupport::fromCharString(env, arg2),
									(jint) arg3 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KProcIO* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KProcIO") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KSpell* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KSpell") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TDEToolBar::BarPosition arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(invocation, mid, (jint) arg1);
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KURL::List& arg1,KURL& arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg1),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KURLRequester* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KURLRequester") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KXMLGUIClient* arg1)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KXMLGUIClient") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KXMLGUIClient* arg1,const TQPoint& arg2,const KFileItemList& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.qt.TQPoint"),
									KDESupport::arrayWithKFileItemList(env, (KFileItemList*) &arg3) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KXMLGUIClient* arg1,const TQPoint& arg2,const KURL& arg3,const TQString& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.qt.TQPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.qt.KURL"),
									QtSupport::fromTQString(env, (TQString*)&arg4) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(KXMLGUIClient* arg1,const TQPoint& arg2,const KURL& arg3,const TQString& arg4,mode_t arg5)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;I)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.koala.KXMLGUIClient"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.qt.TQPoint"),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.qt.KURL"),
									QtSupport::fromTQString(env, (TQString*)&arg4),
									(jint) arg5 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(pid_t arg1,const TQCString& arg2,const TQString& arg3,bool arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(ILjava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									(jint) arg1,
									QtSupport::fromTQCString(env, (TQCString *) &arg2),
									QtSupport::fromTQString(env, (TQString *) &arg3),
									(jboolean) arg4 );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TQDropEvent* arg1,const KURL::List& arg2,const KURL& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.qt.TQDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg2),
									QtSupport::objectForQtKey(env, (void *) &arg3, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TQDropEvent* arg1,KFileItem* arg2)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.qt.TQDropEvent"),
									QtSupport::objectForQtKey(env, (void *) &arg2, "org.trinitydesktop.koala.KFileItem") );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TQWidget* arg1,TQDropEvent* arg2,KURL::List& arg3)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.qt.TQWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg3) );
	env->PopLocalFrame(0);
}

void
TDEJavaSlot::invoke(TQWidget* arg1,TQDropEvent* arg2,KURL::List& arg3,KURL& arg4)
{
	JNIEnv *	env;
	jclass		cls;
	jmethodID	mid;
	jobject		result;

	env = QtSupport::GetEnv();
	env->PushLocalFrame(10);

	cls = env->GetObjectClass(invocation);
	mid = env->GetMethodID(cls, "invoke", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
	if (mid == NULL) {
		return;
	}
	result = env->CallObjectMethod(	invocation,
									mid,
									QtSupport::objectForQtKey(env, (void *) arg1, "org.trinitydesktop.qt.TQWidget"),
									QtSupport::objectForQtKey(env, (void *) arg2, "org.trinitydesktop.qt.TQDropEvent"),
									KDESupport::arrayWithKURLList(env, (KURL::List *) &arg3),
									QtSupport::objectForQtKey(env, (void *) &arg4, "org.trinitydesktop.koala.KURL") );
	env->PopLocalFrame(0);
}

TDEJavaSlotFactory::TDEJavaSlotFactory()
	: JavaSlotFactory()
{
}

JavaSlot *
TDEJavaSlotFactory::createJavaSlot(JNIEnv * env, jobject receiver, jstring slot)
{
	return new TDEJavaSlot(env, receiver, slot);
}


