/***************************************************************************
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CVSFILEINFOPROVIDER_H
#define CVSFILEINFOPROVIDER_H

#include <tqmap.h>

#include <kdevversioncontrol.h>
#include "cvsservicedcopIface.h"
#include "cvsdir.h"
#include "bufferedstringreader.h"

class CvsServicePart;
class CvsService_stub;
class CvsJob_stub;

/**
Provider for CVS file information

@author Mario Scalas
*/
class CVSFileInfoProvider : public KDevVCSFileInfoProvider, virtual public CVSServiceDCOPIface
{
    Q_OBJECT
  
public:
    CVSFileInfoProvider( CvsServicePart *parent, CvsService_stub *cvsService );
    virtual ~CVSFileInfoProvider();

// -- Sync interface
    virtual const VCSFileInfoMap *status( const TQString &dirPath ) ;

// -- Async interface for requesting data
    virtual bool requestStatus( const TQString &dirPath, void *callerData, bool recursive = true, bool checkRepos = true  );

public slots:
    void updateStatusFor( const CVSDir& );
private slots:
    void propagateUpdate();

signals:
    void needStatusUpdate(const CVSDir&);

private:
    // DCOP Iface
    virtual void slotJobExited( bool normalExit, int exitStatus );
    virtual void slotReceivedOutput( TQString someOutput );
    virtual void slotReceivedErrors( TQString someErrors );

    TQString projectDirectory() const;

    static VCSFileInfoMap *parse( TQStringList stringStream );

    static VCSFileInfo::FileState String2EnumState( TQString stateAsString );

    static void printOutFileInfoMap( const VCSFileInfoMap &map );

    BufferedStringReader m_bufferedReader;
    TQStringList m_statusLines;

    mutable void *m_savedCallerData;
    mutable CvsJob_stub *m_requestStatusJob;
    CvsService_stub *m_cvsService;

    //! Caching
    mutable TQString m_previousDirPath;
    mutable VCSFileInfoMap *m_cachedDirEntries;
};

#endif
//kate: space-indent on; indent-width 4;
