/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
#ifndef TDEABC_RESOURCESLOX_H
#define TDEABC_RESOURCESLOX_H

#include "sloxbase.h"
#include "webdavhandler.h"

#include <libtdepim/tdeabcresourcecached.h>
#include <tdepimmacros.h>
#include <tdeabc/addressee.h>

#include <tqmap.h>
#include <tqdom.h>

namespace TDEIO {
class DavJob;
class Job;
}

namespace KPIM {
class ProgressItem;
}

class TDEConfig;

namespace TDEABC {

class SloxPrefs;

class KDE_EXPORT ResourceSlox : public ResourceCached, public SloxBase
{
    Q_OBJECT
  
  public:
    ResourceSlox( const TDEConfig * );
    ResourceSlox( const KURL &url,
                  const TQString &user, const TQString &password );
    ~ResourceSlox();

    void readConfig( const TDEConfig * );
    void writeConfig( TDEConfig * );

    SloxPrefs *prefs() const { return mPrefs; }

    bool doOpen();
    void doClose();

    Ticket *requestSaveTicket();
    void releaseSaveTicket( Ticket* );

    bool load();
    bool asyncLoad();
    bool save( Ticket * );
    bool asyncSave( Ticket * );

    void setReadOnly( bool );
    bool readOnly() const;

  protected:
    void init();

    int phoneNumberType( const TQString &fieldName ) const;
    void parseContactAttribute( const TQDomElement &e, Addressee &a );

    void createAddresseeFields( TQDomDocument &doc, TQDomElement &prop, const Addressee &a );
    void createAddressFields( TQDomDocument &doc, TQDomElement &parent,
                              const TQString &prefix, const TDEABC::Address &addr );

    void uploadContacts();

  protected slots:
    void slotResult( TDEIO::Job *job );
    void slotUploadResult( TDEIO::Job *job );
    void slotProgress( TDEIO::Job *job, unsigned long percent );

    void cancelDownload();
    void cancelUpload();

  private:
    SloxPrefs *mPrefs;

    TDEIO::DavJob *mDownloadJob;
    TDEIO::DavJob *mUploadJob;
    KPIM::ProgressItem *mDownloadProgress;
    KPIM::ProgressItem *mUploadProgress;

    WebdavHandler mWebdavHandler;

    TDEABC::Addressee mUploadAddressee;

    TQMap<int, TQStringList> mPhoneNumberSloxMap, mPhoneNumberOxMap;
};

}

#endif
