 /*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KABC_ADDRESSBOOKADAPTOR_H
#define KABC_ADDRESSBOOKADAPTOR_H

#include "groupwaredataadaptor.h"

#include <tdeabc/addressee.h>
#include <tdepimmacros.h>
#include <kurl.h>

namespace TDEABC {
class ResourceCached;

class AddressBookUploadItem : public KPIM::GroupwareUploadItem
{
  public:
    AddressBookUploadItem( KPIM::GroupwareDataAdaptor *adaptor, 
                           TDEABC::Addressee addr, UploadType type );
    virtual ~AddressBookUploadItem() {}
  protected:
    AddressBookUploadItem( UploadType type ) 
                                          : KPIM::GroupwareUploadItem( type ) {}
};

class KDE_EXPORT AddressBookAdaptor : public KPIM::GroupwareDataAdaptor
{
  public:
    AddressBookAdaptor();

    TQValueList<KPIM::FolderLister::ContentType> supportedTypes()
    {
      TQValueList<KPIM::FolderLister::ContentType> types;
      types << KPIM::FolderLister::Contact;
      return types;
    }
    
    /**
      Set resource.
    */
    void setResource( TDEABC::ResourceCached *v )
    {
      mResource = v;
    }
    /**
      Get resource. See setResource().
    */
    TDEABC::ResourceCached *resource() const
    {
      return mResource;
    }

    TQString mimeType() const;
    bool localItemExists( const TQString &localId );
    bool localItemHasChanged( const TQString &localId );
    void deleteItem( const TQString &localId );
    void addItem( TDEABC::Addressee addr );
    void clearChange( const TQString &uid );

    virtual KPIM::GroupwareUploadItem *newUploadItem( TDEABC::Addressee addr,
                     KPIM::GroupwareUploadItem::UploadType type );
    virtual void addressbookItemDownloaded( TDEABC::Addressee addr,
                const TQString &newLocalId, const KURL &remoteId,
                const TQString &fingerprint, const TQString &storagelocation );
    
  private:
    TDEABC::ResourceCached *mResource;
};

}

#endif
