#ifndef _EditorLoadBase_H 
#define _EditorLoadBase_H 

#include <tqdialog.h>
#include <tqframe.h>   
#include <tdetoolbar.h>
#include <kstatusbar.h>
#include <tdefiledialog.h>

#include "Tileset.h"
#include "BoardLayout.h"
#include "Background.h"

#include "Preview.h"

class Editor: public TQDialog
{
    Q_OBJECT
  

public:


    Editor
    (
        TQWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~Editor();



protected slots:
	void topToolbarOption(int w);
        void drawFrameMousePressEvent ( TQMouseEvent* );
        void drawFrameMouseMovedEvent ( TQMouseEvent *);	

	
protected:
	enum {remove=98, insert=99, move=100};
	void paintEvent( TQPaintEvent* pa );
	void setupToolbar();
	void loadBoard();
	bool saveBoard();
	void newBoard();
	void drawBackground(TQPixmap *to);
	void drawTiles(TQPixmap *to);
	bool testSave();
	void transformPointToPosition(const TQPoint &, POSITION &, bool align);
	void drawCursor(POSITION &p, bool visible);
	bool canInsert(POSITION &p);
	void statusChanged();
	TQString statusText();
private:
	int mode;
	int numTiles;
	TDEToolBar *topToolbar;
	FrameImage * drawFrame;
	Tileset tiles;
	BoardLayout theBoard;
	bool clean;
	POSITION currPos;
	TQLabel *theLabel;
private:

};

#endif 
