#################################################
#
#  (C) 2016 Alexander Golubev
#  fatzer2 (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

##### check for gcc visibility support #########
# FIXME
# This should check for [T]Qt3 visibility support

if( WITH_GCC_VISIBILITY )
  if( NOT UNIX )
    tde_message_fatal( "gcc visibility support was requested, but your system is not *NIX" )
  endif( NOT UNIX )
  set( __KDE_HAVE_GCC_VISIBILITY 1 )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
endif( WITH_GCC_VISIBILITY )

tde_setup_architecture_flags( )


# arts
if( WITH_ARTS )
  pkg_search_module( ARTS arts )
  if( ARTS_FOUND )
    set( HAVE_ARTS 1 )
  else( )
    tde_message_fatal( "aRts is requested, but was not found on your system" )
  endif( )
else( WITH_ARTS )
  if (BUILD_KASTEROIDS OR BUILD_KOLF)
    tde_message_fatal( "aRts support is disabled, but it is required to build kasteroids and kolf" )
  endif( )
endif( WITH_ARTS )


##### Other dependencies ########################

check_include_file( "stropts.h"    HAVE_STROPTS_H    )
check_include_file( "sys/filio.h"  HAVE_SYS_FILIO_H  )
check_include_file( "sys/select.h" HAVE_SYS_SELECT_H )
check_include_file( "sysent.h"     HAVE_SYSENT_H     )

check_symbol_exists( usleep "unistd.h"  HAVE_USLEEP )
check_symbol_exists( strlcpy "string.h"  HAVE_USLEEP )

# NOTE: Borrowed from tdelibs
# FIXME I'm not sure if test TIME_WITH_SYS_TIME are correct
check_include_file( "sys/time.h" HAVE_SYS_TIME_H )
check_include_file( "time.h" HAVE_TIME_H )
if( HAVE_SYS_TIME_H AND HAVE_TIME_H )
  set( TIME_WITH_SYS_TIME 1 )
endif( HAVE_SYS_TIME_H AND HAVE_TIME_H )

# required stuff
find_package( TQt )
find_package( TDE )

##### Import libtdegames ########################
# all games require libtdegames to be imported
if( BUILD_ATLANTIK     OR
    BUILD_KASTEROIDS   OR
    BUILD_KATOMIC      OR
    BUILD_KBACKGAMMON  OR
    BUILD_KBATTLESHIP  OR
    BUILD_KBLACKBOX    OR
    BUILD_KBOUNCE      OR
    BUILD_KENOLABA     OR
    BUILD_KFOULEGGS    OR
    BUILD_KGOLDRUNNER  OR
    BUILD_KJUMPINGCUBE OR
    BUILD_KLICKETY     OR
    BUILD_KLINES       OR
    BUILD_KMAHJONGG    OR
    BUILD_KMINES       OR
    BUILD_KNETWALK     OR
    BUILD_KOLF         OR
    BUILD_KONQUEST     OR
    BUILD_KPAT         OR
    BUILD_KPOKER       OR
    BUILD_KREVERSI     OR
    BUILD_KSAME        OR
    BUILD_KSHISEN      OR
    BUILD_KSIRTET      OR
    BUILD_KSMILETRIS   OR
    BUILD_KSNAKE       OR
    BUILD_KSOKOBAN     OR
    BUILD_KSPACEDUEL   OR
    BUILD_KTRON        OR
    BUILD_KTUBERLING   OR
    BUILD_LSKAT        OR
    BUILD_TWIN4 )
  tde_import ( libtdegames )
endif()
