/*
  Copyright (C) 2002 Rik Hemsley (rikkus) <rik@kde.org>
  Copyright (C) 2002 Benjamin Meyer <ben-devel@meyerhome.net>
  Copyright (C) 2004 Richard Lärkäng <nouseforaname@home.se>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "cddbconfigwidget.h"

#include "libkcddb/sites.h"
#include "libkcddb/lookup.h"

#include <tqlistbox.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqlineedit.h>
#include <tdefiledialog.h>
#include <tdeapplication.h>
#include <tdelocale.h>
#include <kinputdialog.h>
#include <tdemessagebox.h>
#include <keditlistbox.h>
#include <tqwidgetstack.h>
#include <kurlrequester.h>
#include <tqbuttongroup.h>
#include <tqcheckbox.h>

CDDBConfigWidget::CDDBConfigWidget(TQWidget * parent, const char * name)
  : CDDBConfigWidgetBase(parent, name)
{
  // Connections from widgets are made in designer.

  KURLRequester* urlReq = new KURLRequester(this);
  urlReq->setMode(KFile::Directory);

  KEditListBox* editListBox = new KEditListBox(i18n("Cache Locations"), urlReq->customEditor(), cacheLocationsParent, "kcfg_cacheLocations");
  cacheLocationsParent->raiseWidget(editListBox);

  kcfg_submitTransport->remove(needsAuthenticationBox);
}

void CDDBConfigWidget::showMirrorList()
{
    KCDDB::Sites s;

    TQValueList<KCDDB::Mirror> sites = s.siteList();
    TQMap<TQString, KCDDB::Mirror> keys;
    for (TQValueList<KCDDB::Mirror>::Iterator it = sites.begin(); it != sites.end(); ++it)
      if ((*it).transport == KCDDB::Lookup::CDDBP)
        keys[(*it).address + "(CDDBP, " + TQString::number((*it).port) + ") " + (*it).description] = *it;
      else
        keys[(*it).address + "(HTTP, " + TQString::number((*it).port) + ") " + (*it).description] = *it;

    bool ok;

    if (keys.isEmpty())
    {
      KMessageBox::information(this, i18n("Could not fetch mirror list."), i18n("Could Not Fetch"));
      return;
    }

    TQStringList result = KInputDialog::getItemList(i18n("Select mirror"),
      i18n("Select one of these mirrors"), keys.keys(),
      TQStringList(), false, &ok, this);

    if (ok && result.count() == 1)
    {
      KCDDB::Mirror m = keys[*(result.begin())];

      kcfg_lookupTransport->setCurrentItem(m.transport == KCDDB::Lookup::CDDBP ? 0 : 1);
      kcfg_hostname->setText(m.address);
      kcfg_port->setValue(m.port);
    }
}

void CDDBConfigWidget::protocolChanged()
{
    // Change the port if the port is the default-value for the old protocol

    if (kcfg_lookupTransport->currentText() == i18n("HTTP") && kcfg_port->value() == 8880)
      kcfg_port->setValue(80);
    else if (kcfg_lookupTransport->currentText() == i18n("CDDB") && kcfg_port->value() == 80)
      kcfg_port->setValue(8880);
}

void CDDBConfigWidget::needAuthenticationChanged(bool needsAuth)
{
    kcfg_smtpUsername->setEnabled(needsAuth);
    if (!needsAuth)
      kcfg_smtpUsername->clear();
}

// vim:tabstop=2:shiftwidth=2:expandtab:cinoptions=(s,U1,m1

#include "cddbconfigwidget.moc"
