/*
 * tagguesser.h - (c) 2003 Frerich Raabe <raabe@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef TAGGUESSER_H
#define TAGGUESSER_H

#include <tqregexp.h>

class FileNameScheme
{
    public:
        typedef TQValueList<FileNameScheme> List;

        FileNameScheme() { }
        FileNameScheme(const TQString &s);

        bool matches(const TQString &s) const;

        TQString title() const;
        TQString artist() const;
        TQString album() const;
        TQString track() const;
        TQString comment() const;

    private:
        TQString composeRegExp(const TQString &s) const;

        mutable TQRegExp m_regExp;
        int m_titleField;
        int m_artistField;
        int m_albumField;
        int m_trackField;
        int m_commentField;
};

class TagGuesser
{
    public:

        enum Type { FileName = 0, MusicBrainz = 1 };

        static TQStringList schemeStrings();
        static void setSchemeStrings(const TQStringList &schemes);

        TagGuesser();
        TagGuesser(const TQString &absFileName);

        void guess(const TQString &absFileName);

        TQString title() const { return m_title; }
        TQString artist() const { return m_artist; }
        TQString album() const { return m_album; }
        TQString track() const { return m_track; }
        TQString comment() const { return m_comment; }

    private:
        void loadSchemes();
        TQString capitalizeWords(const TQString &s);

        FileNameScheme::List m_schemes;
        TQString m_title;
        TQString m_artist;
        TQString m_album;
        TQString m_track;
        TQString m_comment;
};

#endif // TAGGUESSER_H
// vim:ts=4:sw=4:noet
