/***************************************************************************
    begin                : Tue Aug 31 21:59:58 EST 2004
    copyright            : (C) 2004 by Michael Pyne
    email                : michael.pyne@kdemail.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdialogbase.h>
#include <tdeglobal.h>
#include <kstdguiitem.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeconfig.h>

#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqvbox.h>
#include <tqhbox.h>

#include "deletedialog.h"

//////////////////////////////////////////////////////////////////////////////
// DeleteWidget implementation
//////////////////////////////////////////////////////////////////////////////

DeleteWidget::DeleteWidget(TQWidget *parent, const char *name)
    : DeleteDialogBase(parent, name)
{
    TDEConfigGroup messageGroup(TDEGlobal::config(), "FileRemover");

    bool deleteInstead = messageGroup.readBoolEntry("deleteInsteadOfTrash", false);
    slotShouldDelete(deleteInstead);
    ddShouldDelete->setChecked(deleteInstead);
}

void DeleteWidget::setFiles(const TQStringList &files)
{
    ddFileList->clear();
    ddFileList->insertStringList(files);
    ddNumFiles->setText(i18n("<b>1</b> file selected.", "<b>%n</b> files selected.", files.count()));
}

void DeleteWidget::slotShouldDelete(bool shouldDelete)
{
    if(shouldDelete) {
        ddDeleteText->setText(i18n("<qt>These items will be <b>permanently "
            "deleted</b> from your hard disk.</qt>"));
        ddWarningIcon->setPixmap(TDEGlobal::iconLoader()->loadIcon("messagebox_warning",
            TDEIcon::Desktop, TDEIcon::SizeLarge));
    }
    else {
        ddDeleteText->setText(i18n("<qt>These items will be moved to the Trash Bin.</qt>"));
        ddWarningIcon->setPixmap(TDEGlobal::iconLoader()->loadIcon("trashcan_full",
            TDEIcon::Desktop, TDEIcon::SizeLarge));
    }
}

//////////////////////////////////////////////////////////////////////////////
// DeleteDialog implementation
//////////////////////////////////////////////////////////////////////////////

DeleteDialog::DeleteDialog(TQWidget *parent, const char *name) :
    KDialogBase(Swallow, WStyle_DialogBorder, parent, name,
        true /* modal */, i18n("About to delete selected files"),
        Ok | Cancel, Cancel /* Default */, true /* separator */),
    m_trashGuiItem(i18n("&Send to Trash"), "trashcan_full")
{
    m_widget = new DeleteWidget(this, "delete_dialog_widget");
    setMainWidget(m_widget);

    m_widget->setMinimumSize(400, 300);
    setMinimumSize(410, 326);
    adjustSize();

    slotShouldDelete(shouldDelete());

    connect(m_widget->ddShouldDelete, TQT_SIGNAL(toggled(bool)), TQT_SLOT(slotShouldDelete(bool)));
}

bool DeleteDialog::confirmDeleteList(const TQStringList &condemnedFiles)
{
    m_widget->setFiles(condemnedFiles);

    return exec() == TQDialog::Accepted;
}

void DeleteDialog::setFiles(const TQStringList &files)
{
    m_widget->setFiles(files);
}

void DeleteDialog::accept()
{
    TDEConfigGroup messageGroup(TDEGlobal::config(), "FileRemover");

    // Save user's preference

    messageGroup.writeEntry("deleteInsteadOfTrash", shouldDelete());
    messageGroup.sync();

    KDialogBase::accept();
}

void DeleteDialog::slotShouldDelete(bool shouldDelete)
{
    setButtonGuiItem(Ok, shouldDelete ? KStdGuiItem::del() : m_trashGuiItem);
}

#include "deletedialog.moc"

// vim: set et ts=4 sw=4:
