/* -------------------------------------------------------------
   KDE Tuberling
   Object to draw on the game board
   mailto:e.bischoff@noos.fr
 ------------------------------------------------------------- */


#ifndef _TODRAW_H_
#define _TODRAW_H_

#include <tqrect.h>

#include <stdio.h>

class ToDraw
{
  public:
    ToDraw();
    ToDraw(const ToDraw &);
    ToDraw(int, const TQRect &);
    ToDraw &operator=(const ToDraw &);
    void draw(TQPainter &, const TQRect &, const TQRect *, const TQPixmap *, const TQBitmap *) const;
    void save(FILE *) const;
    bool load(FILE *, int, bool &);

    inline int getNumber() const { return number; }
    inline void setNumber(int newValue) { number = newValue; }
    inline const TQRect &getPosition() const { return position; }

  private:
    int number;
    TQRect position;
};

#endif
