/*
    This file is part of KBugBuster.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef BUGSERVERCONFIG_H
#define BUGSERVERCONFIG_H

#include <tqstring.h>
#include <tqstringlist.h>

#include <kurl.h>

class TDEConfig;

class BugServerConfig
{
  public:
    BugServerConfig();
    BugServerConfig( const TQString &name, const KURL &baseUrl );
    ~BugServerConfig();

    void setName( const TQString &name );
    TQString name() const;

    void setBaseUrl( const KURL &url );
    KURL baseUrl() const;

    void setUser( const TQString &user );
    TQString user() const;
    
    void setPassword( const TQString &password );
    TQString password() const;

    void readConfig( TDEConfig *, const TQString &name );
    void writeConfig( TDEConfig * );

    static TQStringList bugzillaVersions();

    void setBugzillaVersion( const TQString & );
    TQString bugzillaVersion() const;

    void setRecentPackages( const TQStringList &v ) { mRecentPackages = v; }
    TQStringList recentPackages() const { return mRecentPackages; }

    void setCurrentPackage( const TQString &v ) { mCurrentPackage = v; }
    TQString currentPackage() const { return mCurrentPackage; }

    void setCurrentComponent( const TQString &v ) { mCurrentComponent = v; }
    TQString currentComponent() const { return mCurrentComponent; }

    void setCurrentBug( const TQString &v ) { mCurrentBug = v; }
    TQString currentBug() const { return mCurrentBug; }

  private:
    TQString mName;
    KURL mBaseUrl;
    TQString mUser;
    TQString mPassword;

    TQString mBugzillaVersion;

    TQStringList mRecentPackages;
    TQString mCurrentPackage;
    TQString mCurrentComponent;
    TQString mCurrentBug;
};

#endif

/*
 * vim:sw=4:ts=4:et
 */
