// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef KJSEMBEDJSBINDING_H
#define KJSEMBEDJSBINDING_H
#include "global.h"
#include <tqstring.h>
#include <tqvariant.h>
#include <tqwidget.h>

#include <kjs/interpreter.h>
#include <kjs/object.h>
#include <kjs/types.h>

/**
 * Implement TQString-KJS::UString conversion methods. These methods are declared
 * by KJS, but libkjs doesn't actually contain their implementations.
 *
 * @version $Id$
 */
namespace KJS {

    inline UString::UString( const TQString &d )
    {
	uint len = d.length();
	UChar *dat = new UChar[len];
	memcpy( dat, d.unicode(), len * sizeof(UChar) );
	rep = UString::Rep::create(dat, len);
    }

    inline TQString UString::qstring() const
    {
	return TQString((TQChar*) data(), size());
    }

    inline TQConstString UString::qconststring() const
    {
	return TQConstString((TQChar*) data(), size());
    }

    inline TQString Identifier::qstring() const
    {
	return TQString((TQChar*) data(), size());
    }

}

namespace KJSEmbed {
    class  JSObjectProxy;
    class JSOpaqueProxy;

	enum JavaScriptArrayType { None, List, Map };

    KJSEMBED_EXPORT JavaScriptArrayType checkArray( KJS::ExecState *exec, const KJS::Value &val );

    /** Converts a TQVariant to the closest possible KJS::Value. */
    KJSEMBED_EXPORT KJS::Value convertToValue( KJS::ExecState *exec, const TQVariant &val);

    /** Converts a KJS::Value to the closest possible TQVariant. */
    KJSEMBED_EXPORT TQVariant convertToVariant( KJS::ExecState *exec, const KJS::Value &v );

    /** Returns HTML that documents the specified object. */
    KJSEMBED_EXPORT TQString dumpObject( KJS::ExecState *exec, KJS::Object &obj );

    /** Returns HTML that documents the TQObject facilities of the specified object. */
    KJSEMBED_EXPORT TQString dumpTQObject( KJS::ExecState *exec, KJS::Object &obj );

    /** Returns a TQStringList that contains all possible properties,
    * methods and slots for use with a completion object
    */
    KJSEMBED_EXPORT TQStringList dumpCompletion( KJS::ExecState *exec, KJS::Object &obj);

    KJSEMBED_EXPORT TQPen extractTQPen(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQFont extractTQFont(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQBrush extractTQBrush(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQPalette extractTQPalette(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQPixmap extractTQPixmap( KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQImage extractTQImage( KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQString extractTQString( KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT int extractInt( KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQColor extractTQColor(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQSize extractTQSize(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT bool extractBool(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT double extractDouble(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT uint extractUInt(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQStringList extractTQStringList(KJS::ExecState *exec, const KJS::List &args, int idx);

    KJSEMBED_EXPORT TQDateTime extractTQDateTime(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQDate extractTQDate(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQTime extractTQTime(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQRect extractTQRect(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQPoint extractTQPoint(KJS::ExecState *exec, const KJS::List &args, int idx);

    KJSEMBED_EXPORT TQFont extractTQFont(KJS::ExecState *exec, const KJS::List &args, int idx);
    KJSEMBED_EXPORT TQStrList extractTQStrList(KJS::ExecState *exec, const KJS::List &args, int idx);

    KJSEMBED_EXPORT TQObject *extractTQObject( KJS::ExecState *exec, const KJS::List &args, int idx );
    KJSEMBED_EXPORT TQWidget *extractTQWidget( KJS::ExecState *exec, const KJS::List &args, int idx );

    KJSEMBED_EXPORT JSOpaqueProxy *extractOpaqueProxy( KJS::ExecState *exec, const KJS::List &args, int idx );

    // Helpers for Variant conversions....
    KJSEMBED_EXPORT TQStrList convertArrayToStrList( KJS::ExecState *exec, const KJS::Value &value);
    KJSEMBED_EXPORT TQStringList convertArrayToStringList( KJS::ExecState *exec, const KJS::Value &value);
    KJSEMBED_EXPORT TQDateTime convertDateToDateTime(KJS::ExecState *exec, const KJS::Value &value);
    KJSEMBED_EXPORT TQValueList<TQVariant> convertArrayToList( KJS::ExecState *exec, const KJS::Value &value );
    KJSEMBED_EXPORT TQMap<TQString, TQVariant> convertArrayToMap( KJS::ExecState *exec, const KJS::Value &value );

    /**
     * This will throw an exception with the error string.
     * @returns An error object.
     */
    KJS::Object throwError( KJS::ExecState *exec, const TQString &error, KJS::ErrorType type = KJS::GeneralError );
}

#endif // KJSEMBEDJSBINDING_H

// Local Variables:
// c-basic-offset: 4
// End:
