/*
    This file is part of libkcal.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KCAL_RESOURCETDEABC_H
#define KCAL_RESOURCETDEABC_H

#include <tqptrlist.h>
#include <tqstring.h>
#include <tqdatetime.h>

#include <tdeconfig.h>

#include "libkcal/incidence.h"
#include "libkcal/calendarlocal.h"
#include <tdeabc/addressbook.h>

#include "libkcal/resourcecalendar.h"

#include "libtdepim/tdepimmacros.h"

namespace TDEIO {
class FileCopyJob;
class Job;
}

namespace KCal {

/**
  Resource providing birthdays and anniversaries as events.
*/
class KDE_EXPORT ResourceTDEABC : public ResourceCalendar
{
    Q_OBJECT
  

    friend class ResourceTDEABCConfig;

  public:
    ResourceTDEABC( const TDEConfig * );
    ResourceTDEABC( );
    virtual ~ResourceTDEABC();

    void readConfig( const TDEConfig *config );
    void writeConfig( TDEConfig* config );

    void setAlarm( bool );
    bool alarm();

    void setAlarmDays( int );
    int alarmDays();

    void setCategories( const TQStringList &categories );
    TQStringList categories() const;

    void setUseCategories( bool useCategories );
    bool useCategories() const;

    bool isSaving();

    TDEABC::Lock *lock();

    /** Add Event to calendar. */
    KDE_DEPRECATED bool addEvent(Event *event);
    bool addEvent( Event *event, const TQString &subresource );
    /** deletes an event from this calendar. */
    bool deleteEvent(Event *);

    /**
      Retrieves an event on the basis of the unique string ID.
    */
    Event *event(const TQString &UniqueStr);
    /**
      Return unfiltered list of all events in calendar.
    */
    Event::List rawEvents( EventSortField sortField = EventSortUnsorted, SortDirection sortDirection = SortDirectionAscending );
    /**
      Builds and then returns a list of all events that match for the
      date specified. useful for dayView, etc. etc.
    */
    Event::List rawEventsForDate( const TQDate &date, EventSortField sortField = EventSortUnsorted, SortDirection sortDirection = SortDirectionAscending );
    /**
      Get unfiltered events for date \a qdt.
    */
    Event::List rawEventsForDate( const TQDateTime &qdt );
    /**
      Get unfiltered events in a range of dates. If inclusive is set to true,
      only events are returned, which are completely included in the range.
    */
    Event::List rawEvents( const TQDate &start, const TQDate &end,
                           bool inclusive = false );

    /**
      Add a todo to the todolist.
    */
    KDE_DEPRECATED bool addTodo( Todo *todo );
    bool addTodo( Todo *todo, const TQString &subresource );
    /**
      Remove a todo from the todolist.
    */
    bool deleteTodo( Todo * );
    /**
      Searches todolist for an event with this unique string identifier,
      returns a pointer or null.
    */
    Todo *todo( const TQString &uid );
    /**
      Return list of all todos.
    */
    Todo::List rawTodos( TodoSortField sortField = TodoSortUnsorted, SortDirection sortDirection = SortDirectionAscending );
    /**
      Returns list of todos due on the specified date.
    */
    Todo::List rawTodosForDate( const TQDate &date );
    /** Add a Journal entry to calendar */
    KDE_DEPRECATED bool addJournal( Journal *journal );
    bool addJournal( Journal *journal, const TQString &subresource );

    /** Remove journal from the calendar. */
    bool deleteJournal( Journal * );
    /** Return Journal with given UID */
    virtual Journal *journal(const TQString &uid);
    /**
      Return list of all journals.
    */
    Journal::List rawJournals( JournalSortField sortField = JournalSortUnsorted, SortDirection sortDirection = SortDirectionAscending );
    /**
      Returns list of journals for the given date.
    */
    Journal::List rawJournalsForDate( const TQDate &date );

    /** Return all alarms, which ocur in the given time interval. */
    Alarm::List alarms( const TQDateTime &from, const TQDateTime &to );

    /** Return all alarms, which ocur before given date. */
    Alarm::List alarmsTo( const TQDateTime &to );

    void dump() const;

    void setTimeZoneId( const TQString &timeZoneId );

  protected:
    bool doOpen();
    bool doLoad();
    bool doSave();

  private slots:
    void reload();

  private:
    void init();

    CalendarLocal mCalendar;

    int mAlarmDays;
    bool mAlarm;
    TQStringList mCategories;
    bool mUseCategories;
    TDEABC::AddressBook *mAddressbook;

    TDEABC::Lock *mLock;

    class Private;
    Private *d;
};

}

#endif
