/***************************************************************************
 *   Copyright (C) 1999 by Jonas Nordin                                    *
 *   jonas.nordin@syncom.se                                                *
 *   Copyright (C) 2000-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2002-2003 by Roberto Raggi                              *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _JAVASUPPORTPART_H_
#define _JAVASUPPORTPART_H_

#include <kdevcore.h>
#include <kdevlanguagesupport.h>

#include <kdialogbase.h>
#include <tqguardedptr.h>
#include <tqstring.h>
#include <tqwaitcondition.h>
#include <tqdatetime.h>

class Context;
class ProblemReporter;
class BackgroundParser;
class Catalog;
class TQLabel;
class TQProgressBar;
class TQStringList;
class TQListViewItem;
class TDEListView;
class Driver;

namespace KParts { class Part; }
namespace KTextEditor
{
    class Document;
    class View;
    class EditInterface;
    class SelectionInterface;
    class ViewCursorInterface;
}

class JavaSupportPart : public KDevLanguageSupport
{
    Q_OBJECT
  

public:
    JavaSupportPart( TQObject *parent, const char *name, const TQStringList &args );
    virtual ~JavaSupportPart();

    bool isValid() const { return m_valid; }

    ProblemReporter* problemReporter() { return m_problemReporter; }
    BackgroundParser* backgroundParser() { return m_backgroundParser; }

    const TQPtrList<Catalog>& catalogList() { return m_catalogList; }

    bool isValidSource( const TQString& fileName ) const;
    TQStringList fileExtensions( ) const;

    virtual void customEvent( TQCustomEvent* ev );

    virtual TQStringList subclassWidget(const TQString& formName);
    virtual TQStringList updateWidget(const TQString& formName, const TQString& fileName);

    KTextEditor::Document* findDocument( const KURL& url );

    static TDEConfig *config();

    virtual TQString formatTag( const Tag& tag );
    virtual TQString formatModelItem( const CodeModelItem *item, bool shortDescription=false );
    virtual void addClass();

signals:
    void fileParsed( const TQString& fileName );

protected:
    virtual KDevLanguageSupport::Features features();
    virtual KMimeType::List mimeTypes();
    virtual TQString formatClassName(const TQString &name);
    virtual TQString unformatClassName(const TQString &name);
    virtual void addMethod( ClassDom klass );
    virtual void addAttribute( ClassDom klass );

private slots:
    void activePartChanged(KParts::Part *part);
    void partRemoved( KParts::Part* part );
    void projectOpened();
    void projectClosed();
    void savedFile(const KURL &fileName);
    void configWidget(KDialogBase *dlg);
    void projectConfigWidget(KDialogBase *dlg);
    void contextMenu(TQPopupMenu *popup, const Context *context);
    void addedFilesToProject(const TQStringList &fileList);
    void removedFilesFromProject(const TQStringList &fileList);
    void changedFilesInProject( const TQStringList & fileList );
    void slotProjectCompiled();
    void setupCatalog();

    void slotNewClass();

    void slotNeedTextHint( int, int, TQString& );

    /**
     * loads, parses and creates both classstores needed
     */
    void initialParse( );

    /**
     * only parses the current project
     */
    bool parseProject( );

private:

    /**
     * checks if a file has to be parsed
     */
    void maybeParse( const TQString& fileName );
    void removeWithReferences( const TQString& fileName );

    TQStringList modifiedFileList();
    TQString findSourceFile();
    int pcsVersion();
    void setPcsVersion( int version );

    void saveProjectSourceInfo();

    TQString m_contextFileName;

    TQGuardedPtr< ProblemReporter > m_problemReporter;
    BackgroundParser* m_backgroundParser;

    KTextEditor::Document* m_activeDocument;
    KTextEditor::View* m_activeView;
    KTextEditor::SelectionInterface* m_activeSelection;
    KTextEditor::EditInterface* m_activeEditor;
    KTextEditor::ViewCursorInterface* m_activeViewCursor;
    TQString m_activeFileName;

    TQWaitCondition m_eventConsumed;
    bool m_projectClosed;

    TQMap<TQString, TQDateTime> m_timestamp;
    bool m_valid;

    TQPtrList<Catalog> m_catalogList;
    Driver* m_driver;
    TQString m_projectDirectory;

    ClassDom m_activeClass;
    FunctionDom m_activeFunction;
    VariableDom m_activeVariable;

    friend class KDevJavaSupportIface;
    friend class JavaDriver;
};

#endif
