/*
    yahooverifyaccount.cpp - UI Page for Verifying a locked account

    Copyright (c) 2005 by André Duffeck          <andre.duffeck@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

// QT Includes
#include <tqlayout.h>
#include <tqfile.h>
#include <tqlabel.h>

// KDE Includes
#include <kdebug.h>
#include <klineedit.h>
#include <tdetempfile.h>
#include <tdelocale.h>
#include <tdeio/global.h>
#include <tdeio/job.h>
#include <tdeio/jobclasses.h>
#include <kstandarddirs.h>

// Kopete Includes
#include <yahooverifyaccountbase.h>
#include <kopeteaccount.h>

// Local Includes
#include "yahooverifyaccountbase.h"
#include "yahooverifyaccount.h"
#include "yahooaccount.h"

YahooVerifyAccount::YahooVerifyAccount(Kopete::Account *account, TQWidget *parent, const char *name)
: KDialogBase(parent, name, true, i18n("Account Verification - Yahoo"), Cancel|Apply,
              Apply, true )
{
	mTheAccount = account;	
	mTheDialog = new YahooVerifyAccountBase( this );
	mTheDialog->mPicture->hide();
	setMainWidget( mTheDialog );
	setEscapeButton( Cancel );
}

// Destructor
YahooVerifyAccount::~YahooVerifyAccount()
{
	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;
}

void YahooVerifyAccount::setUrl( KURL url )
{
	mFile = new KTempFile( locateLocal( "tmp", url.fileName() ) );
	mFile->setAutoDelete( true );
	TDEIO::TransferJob *transfer = TDEIO::get( url, false, false );
	connect( transfer, TQT_SIGNAL( result( TDEIO::Job* ) ), this, TQT_SLOT( slotComplete( TDEIO::Job* ) ) );
	connect( transfer, TQT_SIGNAL( data( TDEIO::Job*, const TQByteArray& ) ), this, TQT_SLOT( slotData( TDEIO::Job*, const TQByteArray& ) ) );
}

void YahooVerifyAccount::slotData( TDEIO::Job */*job*/, const TQByteArray& data )
{

	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;

	mFile->file()->writeBlock( data.data() , data.size() );
}

void YahooVerifyAccount::slotComplete( TDEIO::Job */*job*/ )
{

	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;
	mFile->file()->close();
	mTheDialog->mPicture->setPixmap( mFile->file()->name() );
	mTheDialog->mPicture->show();
}

bool YahooVerifyAccount::validateData()
{
	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;

	return ( !mTheDialog->mWord->text().isEmpty() );
}

void YahooVerifyAccount::slotClose()
{
	TQDialog::done(0);
}

void YahooVerifyAccount::slotApply()
{
	kdDebug(YAHOO_GEN_DEBUG) << k_funcinfo << endl;

	YahooAccount* myAccount = static_cast<YahooAccount*>(mTheAccount);
	myAccount->verifyAccount( mTheDialog->mWord->text() );
	TQDialog::done(0);
}

#include "yahooverifyaccount.moc"

// vim: set noet ts=4 sts=4 sw=4:

