// TQStyle.cs - A Qt to C# binding.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//
// Generated File.  Do Not Modify.

namespace Qt {

    using Qt;
    using System;
    using System.Runtime.InteropServices;

    public class TQStyle : TQObject, IDisposable {

        public enum PrimitiveElement: long {
            PE_ButtonCommand = 0,
            PE_ButtonDefault = 1,
            PE_ButtonBevel = 2,
            PE_ButtonTool = 3,
            PE_ButtonDropDown = 4,
            PE_FocusRect = 5,
            PE_ArrowUp = 6,
            PE_ArrowDown = 7,
            PE_ArrowRight = 8,
            PE_ArrowLeft = 9,
            PE_SpinWidgetUp = 10,
            PE_SpinWidgetDown = 11,
            PE_SpinWidgetPlus = 12,
            PE_SpinWidgetMinus = 13,
            PE_Indicator = 14,
            PE_IndicatorMask = 15,
            PE_ExclusiveIndicator = 16,
            PE_ExclusiveIndicatorMask = 17,
            PE_DockWindowHandle = 18,
            PE_DockWindowSeparator = 19,
            PE_DockWindowResizeHandle = 20,
            PE_Splitter = 21,
            PE_Panel = 22,
            PE_PanelPopup = 23,
            PE_PanelMenuBar = 24,
            PE_PanelDockWindow = 25,
            PE_TabBarBase = 26,
            PE_HeaderSection = 27,
            PE_HeaderArrow = 28,
            PE_StatusBarSection = 29,
            PE_GroupBoxFrame = 30,
            PE_Separator = 31,
            PE_SizeGrip = 32,
            PE_CheckMark = 33,
            PE_ScrollBarAddLine = 34,
            PE_ScrollBarSubLine = 35,
            PE_ScrollBarAddPage = 36,
            PE_ScrollBarSubPage = 37,
            PE_ScrollBarSlider = 38,
            PE_ScrollBarFirst = 39,
            PE_ScrollBarLast = 40,
            PE_ProgressBarChunk = 41,
            PE_PanelLineEdit = 42,
            PE_PanelTabWidget = 43,
            PE_WindowFrame = 44,
            PE_CustomBase = 251658240
        }

        public enum StyleFlags {
            Style_Default = 0,
            Style_Enabled = 1,
            Style_Raised = 2,
            Style_Sunken = 4,
            Style_Off = 8,
            Style_NoChange = 16,
            Style_On = 32,
            Style_Down = 64,
            Style_Horizontal = 128,
            Style_HasFocus = 256,
            Style_Top = 512,
            Style_Bottom = 1024,
            Style_FocusAtBorder = 2048,
            Style_AutoRaise = 4096,
            Style_MouseOver = 8192,
            Style_Up = 16384,
            Style_Selected = 32768,
            Style_Active = 65536,
            Style_ButtonDefault = 131072
        }

        public enum ControlElement: long {
            CE_PushButton = 0,
            CE_PushButtonLabel = 1,
            CE_CheckBox = 2,
            CE_CheckBoxLabel = 3,
            CE_RadioButton = 4,
            CE_RadioButtonLabel = 5,
            CE_TabBarTab = 6,
            CE_TabBarLabel = 7,
            CE_ProgressBarGroove = 8,
            CE_ProgressBarContents = 9,
            CE_ProgressBarLabel = 10,
            CE_PopupMenuItem = 11,
            CE_MenuBarItem = 12,
            CE_ToolButtonLabel = 13,
            CE_CustomBase = 4026531840
        }

        public enum SubRect: long {
            SR_PushButtonContents = 0,
            SR_PushButtonFocusRect = 1,
            SR_CheckBoxIndicator = 2,
            SR_CheckBoxContents = 3,
            SR_CheckBoxFocusRect = 4,
            SR_RadioButtonIndicator = 5,
            SR_RadioButtonContents = 6,
            SR_RadioButtonFocusRect = 7,
            SR_ComboBoxFocusRect = 8,
            SR_SliderFocusRect = 9,
            SR_DockWindowHandleRect = 10,
            SR_ProgressBarGroove = 11,
            SR_ProgressBarContents = 12,
            SR_ProgressBarLabel = 13,
            SR_ToolButtonContents = 14,
            SR_CustomBase = 4026531840
        }

        public enum ComplexControl: long {
            CC_SpinWidget = 0,
            CC_ComboBox = 1,
            CC_ScrollBar = 2,
            CC_Slider = 3,
            CC_ToolButton = 4,
            CC_TitleBar = 5,
            CC_ListView = 6,
            CC_CustomBase = 4026531840
        }

        public enum SubControl: long {
            SC_None = 0,
            SC_ScrollBarAddLine = 1,
            SC_ScrollBarSubLine = 2,
            SC_ScrollBarAddPage = 4,
            SC_ScrollBarSubPage = 8,
            SC_ScrollBarFirst = 16,
            SC_ScrollBarLast = 32,
            SC_ScrollBarSlider = 64,
            SC_ScrollBarGroove = 128,
            SC_SpinWidgetUp = 1,
            SC_SpinWidgetDown = 2,
            SC_SpinWidgetFrame = 4,
            SC_SpinWidgetEditField = 8,
            SC_SpinWidgetButtonField = 16,
            SC_ComboBoxFrame = 1,
            SC_ComboBoxEditField = 2,
            SC_ComboBoxArrow = 4,
            SC_SliderGroove = 1,
            SC_SliderHandle = 2,
            SC_SliderTickmarks = 4,
            SC_ToolButton = 1,
            SC_ToolButtonMenu = 2,
            SC_TitleBarLabel = 1,
            SC_TitleBarSysMenu = 2,
            SC_TitleBarMinButton = 4,
            SC_TitleBarMaxButton = 8,
            SC_TitleBarCloseButton = 16,
            SC_TitleBarNormalButton = 32,
            SC_TitleBarShadeButton = 64,
            SC_TitleBarUnshadeButton = 128,
            SC_ListView = 1,
            SC_ListViewBranch = 2,
            SC_ListViewExpand = 4,
            SC_All = 4294967295
        }

        public enum PixelMetric: long {
            PM_ButtonMargin = 0,
            PM_ButtonDefaultIndicator = 1,
            PM_MenuButtonIndicator = 2,
            PM_ButtonShiftHorizontal = 3,
            PM_ButtonShiftVertical = 4,
            PM_DefaultFrameWidth = 5,
            PM_SpinBoxFrameWidth = 6,
            PM_MaximumDragDistance = 7,
            PM_ScrollBarExtent = 8,
            PM_ScrollBarSliderMin = 9,
            PM_SliderThickness = 10,
            PM_SliderControlThickness = 11,
            PM_SliderLength = 12,
            PM_SliderTickmarkOffset = 13,
            PM_SliderSpaceAvailable = 14,
            PM_DockWindowSeparatorExtent = 15,
            PM_DockWindowHandleExtent = 16,
            PM_DockWindowFrameWidth = 17,
            PM_MenuBarFrameWidth = 18,
            PM_TabBarTabOverlap = 19,
            PM_TabBarTabHSpace = 20,
            PM_TabBarTabVSpace = 21,
            PM_TabBarBaseHeight = 22,
            PM_TabBarBaseOverlap = 23,
            PM_ProgressBarChunkWidth = 24,
            PM_SplitterWidth = 25,
            PM_TitleBarHeight = 26,
            PM_IndicatorWidth = 27,
            PM_IndicatorHeight = 28,
            PM_ExclusiveIndicatorWidth = 29,
            PM_ExclusiveIndicatorHeight = 30,
            PM_CustomBase = 4026531840
        }

        public enum ContentsType: long {
            CT_PushButton = 0,
            CT_CheckBox = 1,
            CT_RadioButton = 2,
            CT_ToolButton = 3,
            CT_ComboBox = 4,
            CT_Splitter = 5,
            CT_DockWindow = 6,
            CT_ProgressBar = 7,
            CT_PopupMenuItem = 8,
            CT_CustomBase = 4026531840
        }

        public enum StyleHint: long {
            SH_EtchDisabledText = 0,
            SH_GUIStyle = 1,
            SH_ScrollBar_BackgroundMode = 2,
            SH_ScrollBar_MiddleClickAbsolutePosition = 3,
            SH_ScrollBar_ScrollWhenPointerLeavesControl = 4,
            SH_TabBar_SelectMouseType = 5,
            SH_TabBar_Alignment = 6,
            SH_Header_ArrowAlignment = 7,
            SH_Slider_SnapToValue = 8,
            SH_Slider_SloppyKeyEvents = 9,
            SH_ProgressDialog_CenterCancelButton = 10,
            SH_ProgressDialog_TextLabelAlignment = 11,
            SH_PrintDialog_RightAlignButtons = 12,
            SH_MainWindow_SpaceBelowMenuBar = 13,
            SH_FontDialog_SelectAssociatedText = 14,
            SH_PopupMenu_AllowActiveAndDisabled = 15,
            SH_PopupMenu_SpaceActivatesItem = 16,
            SH_PopupMenu_SubMenuPopupDelay = 17,
            SH_ScrollView_FrameOnlyAroundContents = 18,
            SH_MenuBar_AltKeyNavigation = 19,
            SH_ComboBox_ListMouseTracking = 20,
            SH_PopupMenu_MouseTracking = 21,
            SH_MenuBar_MouseTracking = 22,
            SH_ItemView_ChangeHighlightOnFocus = 23,
            SH_Widget_ShareActivation = 24,
            SH_Workspace_FillSpaceOnMaximize = 25,
            SH_ComboBox_Popup = 26,
            SH_TitleBar_NoBorder = 27,
            SH_ScrollBar_StopMouseOverSlider = 28,
            SH_BlinkCursorWhenTextSelected = 29,
            SH_RichText_FullWidthSelection = 30,
            SH_CustomBase = 4026531840
        }

        public enum StylePixmap: long {
            SP_TitleBarMinButton = 0,
            SP_TitleBarMaxButton = 1,
            SP_TitleBarCloseButton = 2,
            SP_TitleBarNormalButton = 3,
            SP_TitleBarShadeButton = 4,
            SP_TitleBarUnshadeButton = 5,
            SP_DockWindowCloseButton = 6,
            SP_MessageBoxInformation = 7,
            SP_MessageBoxWarning = 8,
            SP_MessageBoxCritical = 9,
            SP_CustomBase = 4026531840
        }

        internal TQStyle () : this (TQNull.Instance) {}

        internal TQStyle (IntPtr ptr) : this (TQNull.Instance)
        {
            rawObject = ptr;
            RegisterObject(this);
        }

        internal TQStyle (TQNull dummy) : base (TQNull.Instance) {}

        ~TQStyle ()
        {
            Dispose(false);
        }

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
		private static extern void qt_del_QStyle (IntPtr obj);
		internal override void Delete ()
		{
			if (deleted) return;

			qt_del_QStyle (rawObject);
			deleted = true;
		}

		[DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_polish (IntPtr raw, IntPtr arg1);
        public void polish (TQWidget arg1)
        {
            qt_QStyle_polish (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_unPolish (IntPtr raw, IntPtr arg1);
        public void unPolish (TQWidget arg1)
        {
            qt_QStyle_unPolish (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_polish1 (IntPtr raw, IntPtr arg1);
        public void polish (TQApplication arg1)
        {
            qt_QStyle_polish1 (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_unPolish1 (IntPtr raw, IntPtr arg1);
        public void unPolish (TQApplication arg1)
        {
            qt_QStyle_unPolish1 (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_polish2 (IntPtr raw, IntPtr arg1);
        public void polish (TQPalette arg1)
        {
            qt_QStyle_polish2 (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_polishPopupMenu (IntPtr raw, IntPtr arg1);
        public void polishPopupMenu (TQPopupMenu arg1)
        {
            qt_QStyle_polishPopupMenu (rawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_itemRect (IntPtr raw, IntPtr p, IntPtr r, int flags, bool enabled, IntPtr pixmap, IntPtr text, int len);
        public TQRect itemRect (TQPainter p, TQRect r, int flags, bool enabled, TQPixmap pixmap, string text, int len)
        {
            return (TQRect)LookupObject (qt_QStyle_itemRect (rawObject, p.RawObject, r.RawObject, flags, enabled, pixmap.RawObject, new TQString (text).RawObject, len), typeof(TQRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_drawItem (IntPtr raw, IntPtr p, IntPtr r, int flags, IntPtr g, bool enabled, IntPtr pixmap, IntPtr text, int len, IntPtr penColor);
        public void drawItem (TQPainter p, TQRect r, int flags, TQColorGroup g, bool enabled, TQPixmap pixmap, string text, int len, TQColor penColor)
        {
            qt_QStyle_drawItem (rawObject, p.RawObject, r.RawObject, flags, g.RawObject, enabled, pixmap.RawObject, new TQString (text).RawObject, len, penColor.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_drawPrimitive (IntPtr raw, TQStyle.PrimitiveElement pe, IntPtr p, IntPtr r, IntPtr cg, TQStyle.StyleFlags flags, IntPtr arg1);
        public void drawPrimitive (TQStyle.PrimitiveElement pe, TQPainter p, TQRect r, TQColorGroup cg, TQStyle.StyleFlags flags, TQStyleOption arg1)
        {
            qt_QStyle_drawPrimitive (rawObject, pe, p.RawObject, r.RawObject, cg.RawObject, flags, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_drawControl (IntPtr raw, TQStyle.ControlElement element, IntPtr p, IntPtr widget, IntPtr r, IntPtr cg, TQStyle.StyleFlags how, IntPtr arg1);
        public void drawControl (TQStyle.ControlElement element, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg, TQStyle.StyleFlags how, TQStyleOption arg1)
        {
            qt_QStyle_drawControl (rawObject, element, p.RawObject, widget.RawObject, r.RawObject, cg.RawObject, how, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_drawControlMask (IntPtr raw, TQStyle.ControlElement element, IntPtr p, IntPtr widget, IntPtr r, IntPtr arg1);
        public void drawControlMask (TQStyle.ControlElement element, TQPainter p, TQWidget widget, TQRect r, TQStyleOption arg1)
        {
            qt_QStyle_drawControlMask (rawObject, element, p.RawObject, widget.RawObject, r.RawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_subRect (IntPtr raw, TQStyle.SubRect r, IntPtr widget);
        public TQRect subRect (TQStyle.SubRect r, TQWidget widget)
        {
            return (TQRect)LookupObject (qt_QStyle_subRect (rawObject, r, widget.RawObject), typeof(TQRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_drawComplexControl (IntPtr raw, TQStyle.ComplexControl control, IntPtr p, IntPtr widget, IntPtr r, IntPtr cg, TQStyle.StyleFlags how, TQStyle.SubControl sub, TQStyle.SubControl subActive, IntPtr arg1);
        public void drawComplexControl (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg, TQStyle.StyleFlags how, TQStyle.SubControl sub, TQStyle.SubControl subActive, TQStyleOption arg1)
        {
            qt_QStyle_drawComplexControl (rawObject, control, p.RawObject, widget.RawObject, r.RawObject, cg.RawObject, how, sub, subActive, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_drawComplexControlMask (IntPtr raw, TQStyle.ComplexControl control, IntPtr p, IntPtr widget, IntPtr r, IntPtr arg1);
        public void drawComplexControlMask (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r, TQStyleOption arg1)
        {
            qt_QStyle_drawComplexControlMask (rawObject, control, p.RawObject, widget.RawObject, r.RawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_querySubControlMetrics (IntPtr raw, TQStyle.ComplexControl control, IntPtr widget, TQStyle.SubControl sc, IntPtr arg1);
        public TQRect querySubControlMetrics (TQStyle.ComplexControl control, TQWidget widget, TQStyle.SubControl sc, TQStyleOption arg1)
        {
            return (TQRect)LookupObject (qt_QStyle_querySubControlMetrics (rawObject, control, widget.RawObject, sc, arg1.RawObject), typeof(TQRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern TQStyle.SubControl qt_QStyle_querySubControl (IntPtr raw, TQStyle.ComplexControl control, IntPtr widget, IntPtr pos, IntPtr arg1);
        public TQStyle.SubControl querySubControl (TQStyle.ComplexControl control, TQWidget widget, TQPoint pos, TQStyleOption arg1)
        {
            return qt_QStyle_querySubControl (rawObject, control, widget.RawObject, pos.RawObject, arg1.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QStyle_pixelMetric (IntPtr raw, TQStyle.PixelMetric metric, IntPtr widget);
        public int pixelMetric (TQStyle.PixelMetric metric, TQWidget widget)
        {
            return qt_QStyle_pixelMetric (rawObject, metric, widget.RawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_sizeFromContents (IntPtr raw, TQStyle.ContentsType contents, IntPtr widget, IntPtr contentsSize, IntPtr arg1);
        public TQSize sizeFromContents (TQStyle.ContentsType contents, TQWidget widget, TQSize contentsSize, TQStyleOption arg1)
        {
            return (TQSize)LookupObject (qt_QStyle_sizeFromContents (rawObject, contents, widget.RawObject, contentsSize.RawObject, arg1.RawObject), typeof(TQSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QStyle_styleHint (IntPtr raw, StyleHint stylehint, IntPtr widget, IntPtr arg1, IntPtr returnData);
        public int styleHint (StyleHint stylehint, TQWidget widget, TQStyleOption arg1, IntPtr returnData)
        {
            return qt_QStyle_styleHint (rawObject, stylehint, widget.RawObject, arg1.RawObject, returnData);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_stylePixmap (IntPtr raw, TQStyle.StylePixmap stylepixmap, IntPtr widget, IntPtr arg1);
        public TQPixmap stylePixmap (TQStyle.StylePixmap stylepixmap, TQWidget widget, TQStyleOption arg1)
        {
            return (TQPixmap)LookupObject (qt_QStyle_stylePixmap (rawObject, stylepixmap, widget.RawObject, arg1.RawObject), typeof(TQPixmap));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern int qt_QStyle_defaultFrameWidth (IntPtr raw);
        public int defaultFrameWidth ()
        {
            return qt_QStyle_defaultFrameWidth (rawObject);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern void qt_QStyle_tabbarMetrics (IntPtr raw, IntPtr t, int hf, int vf, int ov);
        public void tabbarMetrics (TQWidget t, int hf, int vf, int ov)
        {
            qt_QStyle_tabbarMetrics (rawObject, t.RawObject, hf, vf, ov);
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_scrollBarExtent (IntPtr raw);
        public TQSize scrollBarExtent ()
        {
            return (TQSize)LookupObject (qt_QStyle_scrollBarExtent (rawObject), typeof(TQSize));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_visualRect (IntPtr logical, IntPtr w);
        public static TQRect visualRect (TQRect logical, TQWidget w)
        {
            return (TQRect)LookupObject (qt_QStyle_visualRect (logical.RawObject, w.RawObject), typeof(TQRect));
        }

        [DllImport("libqtc", CharSet=CharSet.Ansi)]
        private static extern IntPtr qt_QStyle_visualRect1 (IntPtr logical, IntPtr bounding);
        public static TQRect visualRect (TQRect logical, TQRect bounding)
        {
            return (TQRect)LookupObject (qt_QStyle_visualRect1 (logical.RawObject, bounding.RawObject), typeof(TQRect));
        }

        public TQRect itemRect (TQPainter p, TQRect r, int flags, bool enabled, TQPixmap pixmap, string text)
        {
            return itemRect(p, r, flags, enabled, pixmap, text, (int) -1);
        }

        public void drawItem (TQPainter p, TQRect r, int flags, TQColorGroup g, bool enabled, TQPixmap pixmap, string text)
        {
            drawItem(p, r, flags, g, enabled, pixmap, text, (int) -1);
        }

        public void drawItem (TQPainter p, TQRect r, int flags, TQColorGroup g, bool enabled, TQPixmap pixmap, string text, int len)
        {
            drawItem(p, r, flags, g, enabled, pixmap, text, len, new TQColor ());
        }

        public void drawPrimitive (TQStyle.PrimitiveElement pe, TQPainter p, TQRect r, TQColorGroup cg)
        {
            drawPrimitive(pe, p, r, cg, TQStyle.StyleFlags.Style_Default);
        }

        public void drawPrimitive (TQStyle.PrimitiveElement pe, TQPainter p, TQRect r, TQColorGroup cg, TQStyle.StyleFlags flags)
        {
            drawPrimitive(pe, p, r, cg, flags, new TQStyleOption ());
        }

        public void drawControl (TQStyle.ControlElement element, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg)
        {
            drawControl(element, p, widget, r, cg, TQStyle.StyleFlags.Style_Default);
        }

        public void drawControl (TQStyle.ControlElement element, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg, TQStyle.StyleFlags how)
        {
            drawControl(element, p, widget, r, cg, how, new TQStyleOption ());
        }

        public void drawControlMask (TQStyle.ControlElement element, TQPainter p, TQWidget widget, TQRect r)
        {
            drawControlMask(element, p, widget, r, new TQStyleOption ());
        }

        public void drawComplexControl (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg)
        {
            drawComplexControl(control, p, widget, r, cg, TQStyle.StyleFlags.Style_Default);
        }

        public void drawComplexControl (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg, TQStyle.StyleFlags how)
        {
            drawComplexControl(control, p, widget, r, cg, how, TQStyle.SubControl.SC_All);
        }

        public void drawComplexControl (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg, TQStyle.StyleFlags how, TQStyle.SubControl sub)
        {
            drawComplexControl(control, p, widget, r, cg, how, sub, TQStyle.SubControl.SC_None);
        }

        public void drawComplexControl (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r, TQColorGroup cg, TQStyle.StyleFlags how, TQStyle.SubControl sub, TQStyle.SubControl subActive)
        {
            drawComplexControl(control, p, widget, r, cg, how, sub, subActive, new TQStyleOption ());
        }

        public void drawComplexControlMask (TQStyle.ComplexControl control, TQPainter p, TQWidget widget, TQRect r)
        {
            drawComplexControlMask(control, p, widget, r, new TQStyleOption ());
        }

        public TQRect querySubControlMetrics (TQStyle.ComplexControl control, TQWidget widget, TQStyle.SubControl sc)
        {
            return querySubControlMetrics(control, widget, sc, new TQStyleOption ());
        }

        public TQStyle.SubControl querySubControl (TQStyle.ComplexControl control, TQWidget widget, TQPoint pos)
        {
            return querySubControl(control, widget, pos, new TQStyleOption ());
        }

        public int pixelMetric (TQStyle.PixelMetric metric)
        {
            return pixelMetric(metric, new TQWidget ());
        }

        public TQSize sizeFromContents (TQStyle.ContentsType contents, TQWidget widget, TQSize contentsSize)
        {
            return sizeFromContents(contents, widget, contentsSize, new TQStyleOption ());
        }

        public int styleHint (StyleHint stylehint)
        {
            return styleHint(stylehint, new TQWidget ());
        }

        public int styleHint (StyleHint stylehint, TQWidget widget)
        {
            return styleHint(stylehint, widget, new TQStyleOption ());
        }

        public int styleHint (StyleHint stylehint, TQWidget widget, TQStyleOption arg1)
        {
            return styleHint(stylehint, widget, arg1, (IntPtr) 0);
        }

        public TQPixmap stylePixmap (TQStyle.StylePixmap stylepixmap)
        {
            return stylePixmap(stylepixmap, new TQWidget ());
        }

        public TQPixmap stylePixmap (TQStyle.StylePixmap stylepixmap, TQWidget widget)
        {
            return stylePixmap(stylepixmap, widget, new TQStyleOption ());
        }

        // Begin interface methods.

    }
}
