/* Yo Emacs, this -*- C++ -*-

  Copyright (C) 1999,2000 Jens Hoefkens
  jens@hoefkens.com

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "kbgtextview.moc"
#include "kbgtextview.h"

#include <tdelocale.h>
#include <tdeconfig.h>
#include <kcmenumngr.h>
#include <tdefontdialog.h>
#include <tqfont.h>
#include <tdeapplication.h>

#include <iostream>

// == advanced text control ====================================================

/*
 * Constructor
 */
KBgTextView::KBgTextView(TQWidget *parent, const char *name)
	: KTextBrowser(parent, name)
{
	clear();
	setLinkUnderline(true);
}

/*
 * Destructor
 */
KBgTextView::~KBgTextView()
{
	// empty
}

/*
 * Write the string l to the TextView and put the cursor at the end of
 * the current text
 */
void KBgTextView::write(const TQString &l)
{
	append("<font face=\"" + font().family() + "\">" + l + "</font><br>\n");
	scrollToBottom();
}

/*
 * Clears the view by overwriting the text with an empty string.
 */
void KBgTextView::clear()
{
	setText("");
}

/*
 * Open a font-selection dialog.
 */
void KBgTextView::selectFont()
{
	TQFont f = font();
	TDEFontDialog::getFont(f, false, this, true);
	setFont(f);
}

/*
 * Restore the previously stored settings
 */
void KBgTextView::readConfig()
{
	TDEConfig* config = kapp->config();
	config->setGroup(name());

	// nothing to restore
}

/*
 * Save the current settings to disk
 */
void KBgTextView::saveConfig()
{
	TDEConfig* config = kapp->config();
	config->setGroup(name());

	// nothing to save
}

// EOF
