/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _SHELLFILTERDLG_H_
#define _SHELLFILTERDLG_H_

#include <tqdialog.h>

class TQComboBox;
class TQPushButton;
class KDevPlugin;
class TDEProcess;


class ShellFilterDialog : public TQDialog
{
    Q_OBJECT
  

public:
    ShellFilterDialog();
    ~ShellFilterDialog();

    virtual int exec();

    void setText(const TQString &str)
    { m_instr = str.local8Bit(); }
    TQString text() const
    { return m_outstr; }

private slots:
    void slotStartClicked();
    void slotReceivedStdout(TDEProcess *, char *text, int len);
    void slotWroteStdin(TDEProcess *);
    void slotProcessExited(TDEProcess *);

private:
    TQPushButton *start_button, *cancel_button;
    TQComboBox *combo;
    TDEProcess *m_proc;
    TQCString m_instr;
    TQString m_outstr;
};

#endif
