/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/



#ifndef __KDEVPART_FILECREATE_H__
#define __KDEVPART_FILECREATE_H__


#include <tqguardedptr.h>
#include <tqptrlist.h>

#include <tqwidget.h>
#include <kdevplugin.h>
#include <kdevcreatefile.h>

#include "filecreate_typechooser.h"

class TDEPopupMenu;

namespace FileCreate {
  class Widget;
  class FileType;
}

class KDialogBase;
class FCConfigWidget;
class ConfigWidgetProxy;

using namespace FileCreate;

class FileCreatePart : public KDevCreateFile
{
  Q_OBJECT
  

  friend class FCConfigWidget;
public:
  FileCreatePart(TQObject *parent, const char *name, const TQStringList &);
  virtual ~FileCreatePart();

  /**
   * Returns the list of available file types.
   */
  TQPtrList<FileType> getFileTypes() const { return m_filetypes; }

  /**
   * Call this method to create a new file, within or without the project. Supply as
   * much information as you know. Leave what you don't know as TQString().
   * The user will be prompted as necessary for the missing information, and the
   * file created, and added to the project as necessary.
   */
  virtual KDevCreateFile::CreatedFile createNewFile(TQString ext = TQString(),
                     TQString dir = TQString(),
                     TQString name = TQString(),
                     TQString subtype = TQString());

  /**
   * Finds the file type object for a given extension and optionally subtype.
   * You can omit the subtype and specify the extension as ext-subtype if you wish.
   */
  FileType * getType(const TQString & ext, const TQString subtype = TQString());
  /**
   * Finds the file type object for a given extension and optionally subtype.
   * You can omit the subtype and specify the extension as ext-subtype if you wish.
   * Returns only enabled type (i.e. used in the project).
   */
  FileType * getEnabledType(const TQString & ext, const TQString subtype = TQString());

public slots:

  void slotProjectOpened();
  void slotProjectClosed();
  void slotInitialize();
  void slotGlobalInitialize();

  /**
   * Called when a file type is selected from the docked widget.
   */
  void slotFiletypeSelected(const FileType *);

  /**
   * Called when a new file is required - for example, from the "New.." menu action.
   */
  void slotNewFile();

  /**
   * Called from TDEToolBarPopupMenu to request a new file action
   * @param pFileType is acutally a pointer to FileType
   */
  void slotNewFilePopup(int pFileType);

protected slots:
  void slotNoteFiletype(const FileType * filetype);
  void slotAboutToShowNewPopupMenu();
  void insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int );

private:
  /**
   * If a file has been successfully created, open it
   */
  void openCreatedFile(const KDevCreateFile::CreatedFile & createdFile);

  /**
   * Reads in file type definitions from a config DOM and adds them
   * to the file type list. If enable is true, sets them all to
   * enabled=true by default.
   */
  int readTypes(const TQDomDocument & dom, TQPtrList<FileType> &m_filetypes, bool enable);

  /**
   * Add a file type
   */
  void addFileType(const TQString & filename);

  /**
   * Finds the global XML file that has the same version as KDevelop
   */
  TQString findGlobalXMLFile() const;

  /**
   * List of file types from which the user can choose
   */
  TQPtrList<FileType> m_filetypes;

  /**
   * The file type selected by the new file dialog, if appropriate.
   */
  const FileType * m_filedialogFiletype;

  ConfigWidgetProxy * _configProxy;

  TDEPopupMenu* m_newPopupMenu;
  TQPtrList<TDEPopupMenu>* m_subPopups;
};


#endif
