/***************************************************************************
                          richtexteditor.h - Widget providing simple rich texxt editing 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_RICHTEXTEDITOR_H_
#define _HAVE_RICHTEXTEDITOR_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqwidget.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>

/* Forward Decls */
class TQTextEdit;
class TQFrame;
class TQToolButton;
class TQHButtonGroup;

class TQShowEvent;
class KOMMANDER_EXPORT RichTextEditor : public TQWidget, public KommanderWidget
{
	Q_OBJECT
  

	TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
	TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
	TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  RichTextEditor(TQWidget *, const char *);
  virtual ~RichTextEditor();
  
  bool isKommanderWidget() const;
  void setAssociatedText(const TQStringList&);
  TQStringList associatedText() const;
  TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  void setTextChanged();
  void setWidgetText(const TQString &);
  void textAlign(int);
  void textBold(bool);
  void textUnder(bool);
  void textItalic(bool);
  void fontChanged(const TQFont &);
  void alignmentChanged(int);
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
  void contextMenuRequested(int xpos, int ypos);
protected:
  void showEvent( TQShowEvent *e );
  void contextMenuEvent( TQContextMenuEvent * e );
private:
  TQFrame *m_toolbar;
  TQTextEdit *m_textedit;

  TQToolButton *m_buttonTextBold, *m_buttonTextUnder, *m_buttonTextItalic, 
    *m_buttonTextLeft,  *m_buttonTextCenter, *m_buttonTextRight;

  TQHButtonGroup *m_formatGroup, *m_alignGroup;

};

#endif
