/*
    yabentry.h - Encapsulate Yahoo Adressbook information

    Copyright (c) 2005 André Duffeck <duffeck@kde.org>
    Kopete (c) 2002-2006 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/
#ifndef YABEntry_H
#define YABEntry_H

#include <kdebug.h>
#include <tqdatetime.h>
#include <tqdom.h>

struct YABEntry
{
	enum Source { SourceYAB, SourceContact };

	// Personal
	TQString		firstName;
	TQString		secondName;
	TQString		lastName;
	TQString		nickName;
	TQString		title;

	// Primary Information	
	TQString		phoneMobile;
	TQString		email;
	TQString		yahooId;
	int		YABId;
	Source		source;

	// Additional Information
	TQString		pager;
	TQString		fax;
	TQString		additionalNumber;
	TQString		altEmail1;
	TQString		altEmail2;
	TQString		imAIM;
	TQString		imICQ;
	TQString		imGoogleTalk;
	TQString		imSkype;
	TQString		imIRC;
	TQString		imQQ;

	// Private Information
	TQString		privateAdress;
	TQString		privateCity;
	TQString		privateState;
	TQString		privateZIP;
	TQString		privateCountry;
	TQString		privatePhone;
	TQString		privateURL;
		
	// Work Information
	TQString		corporation;
	TQString		workAdress;
	TQString		workCity;
	TQString		workState;
	TQString		workZIP;
	TQString		workCountry;
	TQString		workPhone;
	TQString		workURL;

	// Miscellaneous
	TQDate		birthday;
	TQDate		anniversary;
	TQString		notes;
	TQString		additional1;
	TQString		additional2;
	TQString		additional3;
	TQString		additional4;

	
	void fromTQDomElement( const TQDomElement &e );
	void fromTQDomDocument( const TQDomDocument &e );
	void fillTQDomElement( TQDomElement &e ) const;

	void dump() const;
};

#endif
