/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqobject.h>

#ifdef USE_QT4

const QObjectList *QObject::objectTrees() {
	QWidgetList widgetlist;
	QObjectList *objectlist = new QObjectList;
	widgetlist = QApplication::allWidgets();
	//widgetlist = QApplication::topLevelWidgets();

	objectlist->clear();
	foreach (QWidget *curwidget, widgetlist) {
		objectlist->append((QObject*)curwidget);
	}

	return objectlist;
}

const QObjectList *QObject::ptrchildren() const {
	QObjectList ql;
	QObjectList *qlr;
	ql = this->children();
	qlr = &ql;
	return qlr;
}

bool QObject::qt_invoke(int slot, QUObject* uo) {
	QMetaMethod method = uo->metaObject()->method(slot);
	return method.invoke(this, Qt::DirectConnection);
}

#endif
