/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQMOVIE_H
#define TQT_TQMOVIE_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the QMovie class
// For Qt3, no changes are needed

#include <qmovie.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the QMovie class
// For Qt4, some changes are needed

#include <tqt4/Qt/qmovie.h>

class TQMovie {
public:
	TQMovie(QObject *parent = 0);
	explicit TQMovie(QIODevice *device, const QByteArray &format = QByteArray(), QObject *parent = 0);
	explicit TQMovie(const QString &fileName, const QByteArray &format = QByteArray(), QObject *parent = 0);
	~TQMovie();

	operator QMovie *() const;

	TQMovie& operator=(const TQMovie&);

private:
	QMovie *d;
};

#endif // USE_QT4

#endif /* TQT_TQMOVIE_H */
