/* This file is part of KCachegrind.
   Copyright (C) 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

/*
 * Instruction View
 */

#ifndef INSTRVIEW_H
#define INSTRVIEW_H

#include <tqlistview.h>
#include "traceitemview.h"

class InstrItem;

class InstrView : public TQListView, public TraceItemView
{
  friend class InstrItem;

  Q_OBJECT
  

public:
  InstrView(TraceItemView* parentView,
            TQWidget* parent = 0, const char* name = 0);

  virtual TQWidget* widget() { return this; }
  TQString whatsThis() const;

  void readViewConfig(TDEConfig*, TQString prefix, TQString postfix, bool);
  void saveViewConfig(TDEConfig*, TQString prefix, TQString postfix, bool);

protected:
  int arrowLevels() { return _arrowLevels; }
  void paintEmptyArea( TQPainter *, const TQRect & );

private slots:
  void context(TQListViewItem*, const TQPoint &, int);
  void selectedSlot(TQListViewItem *);
  void activatedSlot(TQListViewItem *);

private:
  TraceItem* canShow(TraceItem*);
  void doUpdate(int);
  void refresh();
  void setColumnWidths();
  void fillInstr();
  void updateJumpArray(Addr,InstrItem*,bool,bool);
  bool fillInstrRange(TraceFunction*,
                      TraceInstrMap::Iterator,TraceInstrMap::Iterator);
  void updateInstrItems();

  bool _inSelectionUpdate;

  // arrows
  int _arrowLevels;
  // temporary needed on creation...
  TQMemArray<TraceInstrJump*> _jump;
  TraceInstrJumpList _lowList, _highList;

  // remember width of hex code column if hidden
  int _lastHexCodeWidth;

  // widget options
  bool _showHexCode;
};

#endif
