/***************************************************************************
                          xsldbgdebugger.h  -  description
                             -------------------
    begin                : Tue Jan 1 2002
    copyright            : (C) 2002 by keith Isdale
    email                : k_isdale@tpg.com.au
 ***************************************************************************/

/***********************************************************************************
 *                                                                         										*
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                   							*
 *                                                                         										*
 ************************************************************************************/

#ifndef XSLDBGDEBUGGER_H
#define XSLDBGDEBUGGER_H

#include <tqevent.h>
#include "libxsldbg/xsldbgmsg.h"   /* needed for XsldbgMessageEnum */
#include "libqtnotfier/xsldbgdebuggerbase.h"

#include "xsldbginspector.h"


/**
  *@author Keith Isdale
  */

class TQStringList;

class XsldbgWalkSpeedImpl;

class XsldbgDebugger : public XsldbgDebuggerBase {
  Q_OBJECT
  

public:
	XsldbgDebugger();
	~XsldbgDebugger();

	/** */
	void setInspector(XsldbgInspector *inspector);

	/** Get the name of source file from xsldbg*/
	TQString sourceFileName();

	/** Get the name of data file from xsldbg*/
	TQString dataFileName();

	/** Get the name of output file from xsldbg*/
	TQString outputFileName();

	/** Tell quanta to move its cursor to file and line number supplied */
	void gotoLine(TQString fileName, int lineNo, bool breakpoint = false);

	/** Set a xsldbg option */
	void setOption(const char *name, bool value);

	bool event(TQEvent *e);
	void timerEvent(TQTimerEvent *e);

	void setOutputFileActive(bool b) {outputFileActive = b;};

	/* helper function to handle differences between URI's in TQt/KDE and libxml2 */
	static TQString fixLocalPaths(TQString & file);
	
private:
	/** */
	bool outputFileActive;

public slots:
	/** start xsldbg */
	bool start();

	/** stop xsldbg */
	bool stop();

	/** send text to xsldbg, if wait is true then wait for the reply */
	void fakeInput(TQString text, bool wait);

	/** Display configure dialog */
	void slotConfigure();

	/** Config window closed */
	void slotConfigClosed();

  /** Step to next instruction */
  void slotStepCmd();

  /** Continue to next break point */
  void slotContinueCmd();

  /** Restart xsldbg with selected xsl/xml file */
  void slotRunCmd();

  /** Walk throught shtylesheet at a fixed speed
  	 @param speed : Must be a value of 0  to 9, where 1 mean fast, 9 means slow, and 0 means stop
  */
  void slotWalkSpeed(int speed);

  /** Present a dialog for use to choose walk speed */
  void slotWalkCmd();

  /** Stop walking imediately */
  void slotWalkStopCmd();

  /**
  	Start xslbg's trace mode, where output will be sent to to message window.
  		Can only be be stopped by using "exit" tool button and killing xsldbg */
  void slotTraceCmd();

	/** Add breakpoint at given file and line number */
	void slotBreakCmd(TQString fileName, int lineNumber);

	/** Add breakpoint at given template name*/
	void slotBreakCmd(TQString templateName, TQString modeName);

	/** Toggle the enabling of break point at given file and line number */
	void slotEnableCmd(TQString fileName, int lineNumber);

	/** Enable break point for given breakpoint id */
	void slotEnableCmd(int id);

	/** Delete break point at given file and line number */
	void slotDeleteCmd(TQString fileName, int lineNumber);

	/** Delete break point for given breakpoint id */
	void slotDeleteCmd(int id);

	/** Switch to view of XSL source */
	void slotSourceCmd();

	/* switch to the output document  */
	void slotShowDocument();

	/** Switch to view of XML data */
	void slotDataCmd();

  /** Stop xsldg, must use start after this command  */
  void slotExitCmd();

  /** Print the result of evaluating xPathExpression to the message window */
  void slotCatCmd(TQString xPathExpression);

  /** Move to line specified by xPathExpression */
  void slotCdCmd(TQString xPathExpression);

  /** Set a libxslt variable  to  xPathExpression */
  void slotSetVariableCmd(TQString variableName, TQString xPathExpression);
signals: // Signals
    // generated after first message is received from xsldbg
    void debuggerReady();

private:
	bool initialized;

	 /* xsldbg config and inspection dialog */
	XsldbgInspector *inspector;

	/**Walk speed dialog  */
	XsldbgWalkSpeedImpl *walkDialog;
	bool readMsg;
	bool procMsg;

	/* copy text to output only if no furher output us requested */
	XsldbgMessageEnum lastType;
	int updateTimerID;
	bool addMsg;

	TQStringList commandQue;

};

#endif
