/***************************************************************************
 *   Copyright (C) 2003 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __REPLACE_WIDGET_H__
#define __REPLACE_WIDGET_H__

#include <tdetexteditor/editinterface.h>

#include <tqwidget.h>
#include <tqstring.h>

class TQPushButton;
class TQListViewItem;
class TQDialog;

class ReplacePart;
class ReplaceDlgImpl;
class ReplaceItem;
class ReplaceView;

class ReplaceWidget : public TQWidget
{
    Q_OBJECT
  

public:
    ReplaceWidget(ReplacePart *part);

public slots:
    void showDialog();
    void stopButtonClicked( KDevPlugin * );

protected:
    virtual void focusInEvent(TQFocusEvent *e);

private slots:
    void find();
    void replace();
    void clear();
    void editDocument( const TQString & ,int );
    void setCursorPos( KParts::Part *part, uint line, uint col );
    void cursorPos( KParts::Part *part, uint * line, uint * col );

private:
    bool showReplacements();
    bool makeReplacements();
    bool shouldTerminate();

    TQString relativeProjectPath( TQString );
    TQString fullProjectPath( TQString );

    TQStringList workFiles();
    TQStringList allProjectFiles();
    TQStringList subProjectFiles( TQString const & );
    TQStringList openProjectFiles();

    KTextEditor::EditInterface * getEditInterfaceForFile( TQString const & file );

    ReplacePart * m_part;
    ReplaceDlgImpl * m_dialog;

    ReplaceView * _listview;
    TQPushButton * _cancel;
    TQPushButton * _replace;

    uint calledCol;
    uint calledLine;
    TQString calledUrl;

    bool _terminateOperation;
};


#endif
