/***************************************************************************
 *   Copyright (C) 2003 by Thomas Hasart                                   *
 *   thasart@gmx.de                                                        *
 *   Copyright (C) 2001-2002 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *   Copyright (C) 2002 by Jakob Simon-Gaarde                              *
 *   jakob@jsg.dk                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TROLLPROJECTPART_H_
#define _TROLLPROJECTPART_H_

#include <tqdict.h>
#include <tqguardedptr.h>
#include <tqmap.h>
#include <tqdatetime.h>

#include "kdevbuildtool.h"

class KDialogBase;
class TrollProjectWidget;
class KDirWatch;
class TQMakeDefaultOpts;

class TrollProjectPart : public KDevBuildTool
{
    Q_OBJECT
  

public:
    TrollProjectPart( TQObject *parent, const char *name, const TQStringList &args );
    ~TrollProjectPart();

    bool isTMakeProject() const { return m_tmakeProject; }
    bool isTQt4Project() const;
    bool isDirty();
    KDirWatch* dirWatch();
    virtual Options options() const;
    TQStringList distFiles() const;
    inline TQString qmakePath() const { return DomUtil::readEntry(*projectDom(), "/kdevcppsupport/qt/qmake", "");; }

protected:
    virtual void openProject(const TQString &dirName, const TQString &projectName);
    virtual void closeProject();

    virtual TQString projectDirectory() const;
    virtual TQString projectName() const;
    virtual TQString mainProgram() const;
    virtual TQString activeDirectory() const;
    virtual TQStringList allFiles() const;
    virtual void addFile(const TQString &fileName);
    virtual void addFiles ( const TQStringList &fileList );
    virtual void removeFile(const TQString &fileName);
    virtual void removeFiles ( const TQStringList &fileList );
    virtual TQString buildDirectory() const;
    virtual TQString runDirectory() const;
    virtual TQString debugArguments() const;
    virtual TQString runArguments() const;
    virtual DomUtil::PairList runEnvironmentVars() const;

private slots:
    void projectConfigWidget(KDialogBase *dlg);
    void slotBuild();
//    void slotClean();
//    void slotExecute();
    void slotCommandFinished( const TQString& command );
    void slotBuildAndExecuteProject();
    void slotBuildAndExecuteTarget();

private:
//    void startMakeCommand(const TQString &dir, const TQString &target);
    void startTQMakeCommand(const TQString &dir, bool recursive = false );
//     void execute(const TQString &directory, const TQString &command);
    void queueCmd(const TQString &dir, const TQString &cmd);
    TQString makeEnvironment();

    TQString findTQtDir();
    TQString findExecutable( const TQString& path ) const;
    void buildBinDirs( TQStringList& ) const;
    bool isValidTQtDir( const TQString& path ) const;
    bool isExecutable( const TQString& path ) const;

    TQGuardedPtr<TrollProjectWidget> m_widget;
    TQString m_projectName;
    bool m_tmakeProject;

    TQMap<TQString, TQDateTime> m_timestamp;
    bool m_executeProjectAfterBuild;
    bool m_executeTargetAfterBuild;
    TQString m_buildCommand;

    KDirWatch* m_dirWatch;

    friend class TrollProjectWidget;
    friend class ProjectRunOptionsDlg;
    friend class TQMakeDefaultOpts;
};

#endif

