/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef ADDRESSEDITWIDGET_H
#define ADDRESSEDITWIDGET_H

#include <tqwidget.h>

#include <kdialogbase.h>
#include <tdeabc/address.h>
#include <tdeabc/addressee.h>

#include "addresseeconfig.h"
#include "typecombo.h"

class TQButtonGroup;
class TQCheckBox;
class TQListView;
class TQTextEdit;
class TQToolButton;

class KActiveLabel;
class KComboBox;
class KLineEdit;
class TDEListView;

typedef TypeCombo<TDEABC::Address> AddressTypeCombo;

/**
  Editor widget for addresses.
 */
class AddressEditWidget : public TQWidget
{
  Q_OBJECT
  

  public:
    AddressEditWidget( TQWidget *parent, const char *name = 0 );
    ~AddressEditWidget();

    TDEABC::Address::List addresses();
    void setAddresses( const TDEABC::Addressee &addr,
                       const TDEABC::Address::List &list );
    void updateAddressee( const TDEABC::Addressee &addr );

    void updateTypeCombo( const TDEABC::Address::List&, KComboBox* );
    TDEABC::Address currentAddress( KComboBox*, int );

    void setReadOnly( bool readOnly );

  signals:
    void modified();

  protected slots:
    void updateAddressEdit();

    void edit();

  private:
    AddressTypeCombo *mTypeCombo;

    TQPushButton *mEditButton;
    KActiveLabel *mAddressField;

    TDEABC::Address::List mAddressList;
    TDEABC::Addressee mAddressee;
    int mIndex;
};

/**
  Dialog for editing address details.
 */
class AddressEditDialog : public KDialogBase
{
  Q_OBJECT
  

  public:
    AddressEditDialog( const TDEABC::Address::List &list, int selected,
                       TQWidget *parent, const char *name = 0 );
    ~AddressEditDialog();

    TDEABC::Address::List addresses();
    bool changed() const;

  protected slots:
    void addAddress();
    void removeAddress();
    void changeType();
    void editLabel();

    void updateAddressEdits();
    void modified();

  private:
    void saveAddress( TDEABC::Address &addr );
    void fillCountryCombo();
    TQStringList sortLocaleAware( const TQStringList& );

    AddressTypeCombo *mTypeCombo;
    TQTextEdit *mStreetTextEdit;
    KComboBox *mCountryCombo;
    KLineEdit *mRegionEdit;
    KLineEdit *mLocalityEdit;
    KLineEdit *mPostalCodeEdit;
    KLineEdit *mPOBoxEdit;
    TQCheckBox *mPreferredCheckBox;

    TQPushButton *mRemoveButton;
    TQPushButton *mChangeTypeButton;

    TDEABC::Address::List mAddressList;
    TDEABC::Address *mPreviousAddress;
    bool mChanged;

    TQString mLabel;
};

/**
  Dialog for selecting an address type.
 */
class AddressTypeDialog : public KDialogBase
{
  public:
    AddressTypeDialog( int type, TQWidget *parent );
    ~AddressTypeDialog();

    int type() const;

  private:
    TQButtonGroup *mGroup;

    TDEABC::Address::TypeList mTypeList;
};

#endif
