
/*
   Copyright (c) 2003,2004,2005 Clarence Dang <dang@kde.org>
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

   THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
   IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
   IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
   NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


#ifndef KP_EFFECT_INVERT_H
#define KP_EFFECT_INVERT_H


#include <kpcoloreffect.h>


class TQCheckBox;
class TQImage;

class kpMainWindow;


class kpEffectInvertCommand : public kpColorEffectCommand
{
public:
    enum Channel
    {
        None = 0,
        Red = 1, Green = 2, Blue = 4,
        RGB = Red | Green | Blue
    };

    kpEffectInvertCommand (int channels,
                           bool actOnSelection,
                           kpMainWindow *mainWindow);
    kpEffectInvertCommand (bool actOnSelection,
                           kpMainWindow *mainWindow);
    virtual ~kpEffectInvertCommand ();


    //
    // Inverts the colours of each pixel in the given image.
    // These functions differ from TQImage::invertPixels() in the following ways:
    //
    // 1. for 8-bit images, it inverts the colours of the Colour Table
    //    (this means that you would get visually similar results to inversion
    //     at higher bit depths - rather than a "random-looking" inversion
    //     depending on the contents of the Colour Table)
    // 2. never inverts the Alpha Buffer
    //

    static void apply (TQPixmap *destPixmapPtr, int channels = RGB);
    static TQPixmap apply (const TQPixmap &pm, int channels = RGB);
    static void apply (TQImage *destImagePtr, int channels = RGB);
    static TQImage apply (const TQImage &img, int channels = RGB);


    //
    // kpColorEffectCommand interface
    //

public:
    virtual bool isInvertible () const { return true; }

protected:
    virtual TQPixmap applyColorEffect (const TQPixmap &pixmap);

    int m_channels;
};


class kpEffectInvertWidget : public kpColorEffectWidget
{
Q_OBJECT
  

public:
    kpEffectInvertWidget (bool actOnSelection,
                          kpMainWindow *mainWindow,
                          TQWidget *parent, const char *name = 0);
    virtual ~kpEffectInvertWidget ();


    int channels () const;


    //
    // kpColorEffectWidget interface
    //

    virtual TQString caption () const;

    virtual bool isNoOp () const;
    virtual TQPixmap applyColorEffect (const TQPixmap &pixmap);

    virtual kpColorEffectCommand *createCommand () const;

protected slots:
    void slotRGBCheckBoxToggled ();
    void slotAllCheckBoxToggled ();

protected:
    TQCheckBox *m_redCheckBox, *m_greenCheckBox, *m_blueCheckBox,
              *m_allCheckBox;

    // blockSignals() didn't seem to work
    bool m_inSignalHandler;
};



#endif  // KP_EFFECT_INVERT_H
