/*
 *   File name:	kdirstatapp.h
 *   Summary:	The KDirStat application - menu bar, tool bar, ...
 *   License:	GPL - See file COPYING for details.
 *
 *   Author:	Stefan Hundhammer <sh@suse.de>
 *		Parts auto-generated by KDevelop
 *
 *   Updated:	2004-12-06
 */


#ifndef KDirStatApp_h
#define KDirStatApp_h


#ifdef HAVE_CONFIG_H
#   include <config.h>
#endif

#include <kapp.h>
#include <tdemainwindow.h>
#include "kdirtree.h"


// Forward declarations
class TQPopupMenu;
class TQSplitter;

class TDEAction;
class KActivityTracker;
class KFeedbackDialog;
class KFeedbackDialog;
class KFeedbackQuestion;
class KPacMan;
class KPacMan;
class TDERecentFilesAction;
class TDEToggleAction;

namespace KDirStat
{
    class KCleanupCollection;
    class KDirTreeView;
    class KDirTreeViewItem;
    class KFileInfo;
    class KSettingsDialog;
    class KTreemapView;
    class KTreemapTile;
}

using namespace KDirStat;


/**
  * The base class for KDirStat application windows. It sets up the main window
  * and reads the config file as well as providing a menubar, toolbar and
  * statusbar. An instance of KDirStatView creates your center view, which is
  * connected to the window's Doc object.  KDirStatApp reimplements the methods
  * that TDEMainWindow provides for main window handling and supports full
  * session management as well as using TDEActions.
  *
  * @see TDEMainWindow
  * @see TDEApplication
  * @see TDEConfig
  *
  * @author Source Framework Automatically Generated by KDevelop,
  *	    (c) The KDevelop Team.
  *
  * @version KDevelop version 1.2 code generation
  **/
class KDirStatApp : public TDEMainWindow
{
    Q_OBJECT
  

public:

    /**
     * Construtor of KDirStatApp, calls all init functions to create the
     * application.
     **/
    KDirStatApp( TQWidget* parent=0, const char* name=0 );

    /**
     * Destructor.
     **/
    virtual ~KDirStatApp();

    /**
     * Open an URL specified by command line argument.
     **/
    void openURL( const KURL & url );

    /**
     * Return the main window's @ref KDirTreeView.
     **/
    KDirTreeView * treeView() const { return _treeView; }

    /**
     * Returns the main window's @ref KTreemapView or 0 if there is none.
     *
     * Caution: Do not try to cache this value. The treemap view is destroyed
     * and re-created frequently!
     **/
    KTreemapView * treemapView() const { return _treemapView; }


public slots:

    /**
     * Open a directory tree.
     **/
    void fileAskOpenDir();

    /**
     * Open a (possibly remote) directory tree.
     **/
    void fileAskOpenUrl();

    /**
     * Refresh the entire directory tree, i.e. re-read everything from disk.
     **/
    void refreshAll();

    /**
     * Refresh the selected subtree, i.e. re-read it from disk.
     **/
    void refreshSelected();

    /**
     * Refresh the entire directory tree, i.e. re-read everything from disk.
     **/
    void stopReading();

    /**
     * Open a directory tree from the "recent" menu.
     **/
    void fileOpenRecent( const KURL& url );

    /**
     * asks for saving if the file is modified, then closes the current file
     * and window
     **/
    void fileCloseDir();

    /**
     * put the marked text/object into the clipboard
     **/
    void editCopy();

    /**
     * Notification that the view's selection has changed.
     * Enable/disable user actions as appropriate.
     **/
    void selectionChanged( KFileInfo *selection );

    /**
     * Ask user what application to open a file or directory with
     **/
    void cleanupOpenWith();

    /**
     * Toggle tool bar
     **/
    void toggleToolBar();

    /**
     * Toggle status bar
     **/
    void toggleStatusBar();

    /**
     * Toggle treemap view
     **/
    void toggleTreemapView();

    /**
     * Zoom in the treemap at the currently selected tile.
     **/
    void treemapZoomIn();

    /**
     * Zoom out the treemap after zooming in.
     **/
    void treemapZoomOut();

    /**
     * Select the parent of the currently selected treemap tile.
     **/
    void treemapSelectParent();

    /**
     * Rebuild the treemap.
     **/
    void treemapRebuild();

    /**
     * Invoke online help about treemaps.
     **/
    void treemapHelp();

    /**
     * Open settings dialog
     **/
    void preferences();

    /**
     * Changes the statusbar contents for the standard label permanently, used
     * to indicate current actions.
     *
     * @param text the text that is displayed in the statusbar
     **/
    void statusMsg( const TQString &text );

    /**
     * Opens a context menu for tree view items.
     **/
    void contextMenu( KDirTreeViewItem * item, const TQPoint &pos );

    /**
     * Opens a context menu for treemap tiles.
     **/
    void contextMenu( KTreemapTile * tile, const TQPoint &pos );

    /**
     * Create a treemap view. This makes only sense after a directory tree is
     * completely read.
     **/
    void createTreemapView();

    /**
     * Delete an existing treemap view if there is one.
     **/
    void deleteTreemapView();

    /**
     * Sends a user feedback mail.
     **/
    void sendFeedbackMail();

    /**
     * Read configuration for the main window.
     **/
    void readMainWinConfig();

    /**
     * Save the main window's configuration.
     **/
    void saveMainWinConfig();

    /**
     * Revert all cleanups to default values.
     **/
    void revertCleanupsToDefaults();

    /**
     * For the settings dialog only: Return the internal cleanup collection.
     **/
    KCleanupCollection * cleanupCollection() { return _cleanupCollection; }

    /**
     * Initialize @ref KPacMan animation in the tool bar.
     **/
    void initPacMan( bool enablePacMan = true );

    /**
     * Returns true if the pacman animation in the tool bar is enabled, false
     * otherwise.
     **/
    bool pacManEnabled() const { return _pacMan != 0; }

    /**
     * Ask user if he wouldn't like to rate this program.
     **/
    void askForFeedback();

    /**
     * Notification that a feedback mail has been sent, thus don't remind
     * the user any more.
     **/
    void feedbackMailSent();

    /**
     * Update enabled/disabled state of the user actions.
     **/
    void updateActions();


signals:

    /**
     * Emitted when the configuration is to be read - other than at program
     * startup / object creation where each object is responsible for reading
     * its configuraton at an appropriate time.
     **/
    void readConfig();

    /**
     * Emitted when the configuration is to be saved.
     **/
    void saveConfig();


protected:

    /**
     * Initialize the TDEActions of the application.
     **/
    void initActions();

    /**
     * Initialize @ref KCleanup actions.
     **/
    void initCleanups();

    /**
     * Set up status bar for the main window by initializing a status label.
     **/
    void initStatusBar();

    /**
     * Set up the activity tracker.
     **/
    void initActivityTracker();

    /**
     * Called when a main window is to be closed.
     *
     * Returns "true" when closing this window is OK, "false" to abort closing.
     **/
    virtual bool queryClose();

    /**
     * Called when the application is to be shut down alltogether, i.e. when
     * all windows are to be closed.
     *
     * Returns "true" when exiting is OK, "false" otherwise.
     **/
    virtual bool queryExit();

    /**
     * Save the window properties for each open window during session end to
     * the session config file, including saving the currently opened file by a
     * temporary filename provided by TDEApplication.
     *
     * @see KTMainWindow#saveProperties
     **/
    virtual void saveProperties( TDEConfig * config );

    /**
     * Reads session config file and restore application state including the
     * last opened files and documents by reading the temporary files saved by
     * saveProperties().
     *
     * @see KTMainWindow#readProperties
     **/
    virtual void readProperties( TDEConfig * config );


    /**
     * Add a list of features of this program to a feedback question
     **/
    void addFeatureList( KFeedbackQuestion * question );

    /**
     * Check if the user should be reminded to submit feedback.
     **/
    bool doFeedbackReminder();


    //
    // Data members
    //

    // Widgets

    TQSplitter *			_splitter;
    KDirTreeView *		    _treeView;
    KTreemapView *		    _treemapView;
    KPacMan *			_pacMan;
    TQWidget *			_pacManDelimiter;
    TQPopupMenu *		_treeViewContextMenu;
    TQPopupMenu *		_treemapContextMenu;
    KDirStat::KSettingsDialog *	_settingsDialog;
    KFeedbackDialog *		_feedbackDialog;
    KActivityTracker *		_activityTracker;


    // Actions

    TDEAction * 			_fileAskOpenDir;
    TDEAction * 			_fileAskOpenUrl;
    TDERecentFilesAction *	_fileOpenRecent;
    TDEAction * 			_fileCloseDir;
    TDEAction * 			_fileRefreshAll;
    TDEAction *			_fileRefreshSelected;
    TDEAction *			_fileContinueReadingAtMountPoint;
    TDEAction *			_fileStopReading;
    TDEAction * 			_fileQuit;
    TDEAction * 			_editCopy;
    TDEAction * 			_cleanupOpenWith;
    TDEAction *	 		_treemapZoomIn;
    TDEAction *			_treemapZoomOut;
    TDEAction *			_treemapSelectParent;
    TDEAction * 			_treemapRebuild;

    TDEAction *			_reportMailToOwner;
    TDEAction *			_helpSendFeedbackMail;
    TDEToggleAction * 		_showToolBar;
    TDEToggleAction * 		_showStatusBar;
    TDEToggleAction * 		_showTreemapView;

    KCleanupCollection *	_cleanupCollection;


    // Misc

    int				_treemapViewHeight;
};


#endif // KDirStatApp_h
