/****************************************************************************
**
** Copyright (C) 2012 Timothy Pearson.  All rights reserved.
**
** This file is part of the TDE Qt4 style interface
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#define TQT_NO_COMPAT_NAMES
#include <tqstyle.h>
#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqpainter.h>
#include <tqapplication.h>
#include <tqprogressbar.h>
#include <tqtabbar.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqpopupmenu.h>
#include <tqmenudata.h>
#include <tqcombobox.h>
#include <tqslider.h>
#include <tqscrollbar.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <tqmenubar.h>
#include <tqtoolbox.h>
#include <tqtoolbutton.h>
#include <qtitlebar_p.h>
#include <tqpixmapcache.h>
#undef Qt

// HACK to gain access to QSpinBox QLineEdit object
#define protected public

#include <QtGui/QtGui>
#include <QtGui/QX11Info>

// HACK
#undef protected

#include "simplestyle.h"
#include "tdeqt4painter.h"
#include "tdeqt4converter.h"

#define INTEGRATE_WITH_TDE 1

#ifdef INTEGRATE_WITH_TDE
#undef Q_OBJECT
#define Q_OBJECT TQ_OBJECT
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kicontheme.h>
#include <kiconloader.h>
#include <tdefiledialog.h>
#endif

// #define DEBUG_SPEW 1

//#define BASE_QT4_STYLE_CLASS QCommonStyle
#define BASE_QT4_STYLE_CLASS QWindowsStyle

// Run your application like this:
// DEBUG_TDEQT4_THEME_ENGINE=true <appname>
// to debug the theme engine
bool enable_debug_warnings = false;

#ifdef INTEGRATE_WITH_TDE
// BEGIN
// Qt4 file dialog hook information block
typedef QStringList (*_qt_filedialog_open_filenames_hook)(QWidget * parent, const QString &caption, const QString &dir,
                                                          const QString &filter, QString *selectedFilter, QFileDialog::Options options);
typedef QString (*_qt_filedialog_open_filename_hook)     (QWidget * parent, const QString &caption, const QString &dir,
                                                          const QString &filter, QString *selectedFilter, QFileDialog::Options options);
typedef QString (*_qt_filedialog_save_filename_hook)     (QWidget * parent, const QString &caption, const QString &dir,
                                                          const QString &filter, QString *selectedFilter, QFileDialog::Options options);
typedef QString (*_qt_filedialog_existing_directory_hook)(QWidget *parent, const QString &caption, const QString &dir,
                                                          QFileDialog::Options options);

extern Q_GUI_EXPORT _qt_filedialog_open_filename_hook qt_filedialog_open_filename_hook;
extern Q_GUI_EXPORT _qt_filedialog_open_filenames_hook qt_filedialog_open_filenames_hook;
extern Q_GUI_EXPORT _qt_filedialog_save_filename_hook qt_filedialog_save_filename_hook;
extern Q_GUI_EXPORT _qt_filedialog_existing_directory_hook qt_filedialog_existing_directory_hook;
// END
#endif // INTEGRATE_WITH_TDE

#ifdef INTEGRATE_WITH_TDE
static QString TDEFileDialogOpenName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFileDialog::Options)
{
	Q_UNUSED(selectedFilter);

	if (parent) {
		return convertTQt3ToQt4String(KFileDialog::getOpenFileNameWId(convertQt4ToTQt3String(dir), convertQt4ToTQt3String(filter), parent->winId(), convertQt4ToTQt3String(caption)));
	}
	else {
		return convertTQt3ToQt4String(KFileDialog::getOpenFileName(convertQt4ToTQt3String(dir), convertQt4ToTQt3String(filter), 0, convertQt4ToTQt3String(caption)));
	}
}

static QStringList TDEFileDialogOpenNames(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFileDialog::Options)
{
	Q_UNUSED(selectedFilter);
	Q_UNUSED(parent);

//	TQWidget* tqt3parent = TQT_TQWIDGET(TQWidget::find( parent->winId() ));
	TQWidget* tqt3parent = 0;
	return convertTQt3ToQt4StringList(KFileDialog::getOpenFileNames(convertQt4ToTQt3String(dir), convertQt4ToTQt3String(filter), tqt3parent, convertQt4ToTQt3String(caption)));
}

static QString TDEFileDialogSaveName(QWidget *parent, const QString &caption, const QString &dir, const QString &filter, QString *selectedFilter, QFileDialog::Options)
{
	Q_UNUSED(selectedFilter);

	if (parent) {
		return convertTQt3ToQt4String(KFileDialog::getSaveFileNameWId(convertQt4ToTQt3String(dir), convertQt4ToTQt3String(filter), parent->winId(), convertQt4ToTQt3String(caption)));
	}
	else {
		return convertTQt3ToQt4String(KFileDialog::getSaveFileName(convertQt4ToTQt3String(dir), convertQt4ToTQt3String(filter), 0, convertQt4ToTQt3String(caption)));
	}
}

static QString TDEFileDialogSelectDirectory(QWidget *parent, const QString &caption, const QString &dir, QFileDialog::Options)
{
	Q_UNUSED(parent);

	TQWidget* tqt3parent = 0;
	return convertTQt3ToQt4String(KFileDialog::getExistingDirectory(convertQt4ToTQt3String(dir), tqt3parent, convertQt4ToTQt3String(caption)));
}
#endif // INTEGRATE_WITH_TDE

#define NO_QT3_EQUIVALENT can_override = false;
#define DO_NOT_DRAW can_override = true; do_not_draw = true;

Qt4TDEStyle::Qt4TDEStyle() : m_aboutData(NULL), m_tqApplication(NULL), m_tdeApplication(NULL), hoverTab(-1)
{
	enable_debug_warnings = (getenv("DEBUG_TDEQT4_THEME_ENGINE") != NULL);

#ifdef INTEGRATE_WITH_TDE
	if (!tqApp) {
		// Initialize TDEApplication required data structures
		int argc = 1;
		char** argv;
		// Supply it with fake data to keep TDEApplication happy
		argv = (char**) malloc(sizeof(char*));
		argv[0] = (char*) malloc(sizeof(char) * 19);
		strncpy(argv[0], "Qt4TDEStyle", 19);

		m_qt4ApplicationName = convertQt4ToTQt3String(qApp->applicationName());

		m_aboutData = new TDEAboutData("Qt4TDEStyle", I18N_NOOP(m_qt4ApplicationName.ascii()), "v0.1",
			"TDE Qt4 theme engine", TDEAboutData::License_GPL,
			"(c) 2012, Timothy Pearson",
			"message goes here", 0 /* TODO: Website */, "kb9vqf@pearsoncomputing.net");
		TDECmdLineArgs::init(argc, argv, m_aboutData);

		// Qt4 can be SO STUPID sometimes...why can't I get the X11 display directly from qApp?!?!??
		QWidget myhackedwidget;
		m_tdeApplication = new TDEApplication(myhackedwidget.x11Info().display());
	}

	// Set the Qt4 icon set to the TDE icon set
	QIcon::setThemeName(convertTQt3ToQt4String(TDEIconTheme::current()));

	// Set the Qt4 default font
	QApplication::setFont(convertTQt3ToQt4Font(TQApplication::font()));

	// Set up Qt4 size hints to match the TDE sizes
	// FIXME
	// m_tqt3DialogButtons_ShowIcons, m_tqt3IconSize_MenuItem, and m_tqt3IconSize_Large are still hardcoded
	// Verify all mappings
	m_tqt3IconSize_NoGroup        = IconSize(TDEIcon::NoGroup);
	m_tqt3IconSize_Desktop        = IconSize(TDEIcon::Desktop);
	m_tqt3IconSize_FirstGroup     = IconSize(TDEIcon::FirstGroup);
	m_tqt3IconSize_Toolbar        = IconSize(TDEIcon::Toolbar);
	m_tqt3IconSize_MainToolbar    = IconSize(TDEIcon::MainToolbar);
	m_tqt3IconSize_Small          = IconSize(TDEIcon::Small);
	m_tqt3IconSize_Large          = 32;
	m_tqt3IconSize_Panel          = IconSize(TDEIcon::Panel);
	m_tqt3IconSize_LastGroup      = IconSize(TDEIcon::LastGroup);
	m_tqt3IconSize_User           = IconSize(TDEIcon::User);
	m_tqt3IconSize_MenuItem       = 16;
	m_tqt3IconSize_Tabbar         = m_tqt3IconSize_MenuItem;
	m_tqt3IconSize_Listview       = m_tqt3IconSize_MenuItem;
	m_tqt3IconSize_Button         = m_tqt3IconSize_MenuItem;
	m_tqt3DialogButtons_ShowIcons = 0;

#else // INTEGRATE_WITH_TDE
	if (!tqApp) {
		// Qt4 can be SO STUPID sometimes...why can't I get the X11 display directly from qApp?!?!??
		QWidget myhackedwidget;
		m_tqApplication = new TQApplication(myhackedwidget.x11Info().display());
	}

	// Set up Qt4 size hints to match the hardcoded TQt3 sizes
	// FIXME
	// Verify all mappings
	m_tqt3IconSize_NoGroup        = 32;
	m_tqt3IconSize_Desktop        = 32;
	m_tqt3IconSize_FirstGroup     = m_tqt3IconSize_NoGroup;
	m_tqt3IconSize_Toolbar        = 22;
	m_tqt3IconSize_MainToolbar    = 22;
	m_tqt3IconSize_Small          = 22;			// Hardcoded in TQt3 qiconset.cpp:56
	m_tqt3IconSize_Large          = 32;			// Hardcoded in TQt3 qiconset.cpp:56
	m_tqt3IconSize_Panel          = 22;
	m_tqt3IconSize_LastGroup      = m_tqt3IconSize_NoGroup;
	m_tqt3IconSize_User           = m_tqt3IconSize_NoGroup;
	m_tqt3IconSize_MenuItem       = 16;
	m_tqt3IconSize_Tabbar         = m_tqt3IconSize_MenuItem;
	m_tqt3IconSize_Listview       = m_tqt3IconSize_MenuItem;
	m_tqt3IconSize_Button         = m_tqt3IconSize_MenuItem;
	m_tqt3DialogButtons_ShowIcons = 0;
#endif // INTEGRATE_WITH_TDE

	// Set the Qt4 palette to the TQt3 palette
	qApp->setPalette(convertTQt3ToQt4Palette(tqApp->palette()));

	// Initialize the pixmap cache
	m_internalTQt3PixmapCache = new TQPixmapCache();
	m_internalTQt3PixmapCache->setCacheLimit(4096);

	// Initialize the widget cache
	m_internalTQt3WidgetCache = new TQWidgetCache();
	m_internalTQt3WidgetCache->setMaxCost(4096);
	m_internalTQt3WidgetCache->setAutoDelete(true);

	// Create interface widgets
	m_tqt3parent_widget = new TQWidget();

	m_tqt3generic_widget = new TQWidget(m_tqt3parent_widget);
	m_tqt3window_widget = new TQWidget(m_tqt3parent_widget);

#ifdef INTEGRATE_WITH_TDE
	qt_filedialog_open_filename_hook = &TDEFileDialogOpenName;
	qt_filedialog_open_filenames_hook = &TDEFileDialogOpenNames;
	qt_filedialog_save_filename_hook = &TDEFileDialogSaveName;
	qt_filedialog_existing_directory_hook = &TDEFileDialogSelectDirectory;
#endif // INTEGRATE_WITH_TDE

#if QT_VERSION > 0x040800
	// How a bug of this magnitude could go undetected in a major Qt4 release is beyond me...I guess cell phones don't generally use thin lines in their widgets!?
	// This is Yet Another Example of why TDE cannot rely on Qt4 for anything of any real importance
	printf("[WARNING] Qt4 >= Qt 4.8.0 detected; you are likely affected by these Qt4 bugs:\n[WARNING] https://bugreports.qt-project.org/browse/QTBUG-25896\n[WARNING] https://bugreports.qt-project.org/browse/QTBUG-26013\n[WARNING] There is no known workaround for this problem; your Qt4 application will display with numerous graphical glitches.\n");
#endif
}

Qt4TDEStyle::~Qt4TDEStyle()
{
//	delete tqApp;

	// Delete interface widgets
	// Widgets are deleted when their parent is deleted...these lines will cause a crash on exit
// 	delete m_tqt3generic_widget;
// 	delete m_tqt3window_widget;

	// FIXME
	// Verify I'm not leaking memory like a sieve when this is commented out!!!
// 	delete m_tqt3parent_widget;

	m_internalTQt3WidgetCache->setAutoDelete(false);
	delete m_internalTQt3WidgetCache;
	delete m_internalTQt3PixmapCache;

	if (m_tdeApplication) {
		delete m_tdeApplication;
	}
	if (m_tqApplication) {
		delete m_tqApplication;
	}

	// FIXME
	// Do I need to delete this?
// 	delete m_aboutData;
}

void Qt4TDEStyle::polish(QPalette &palette)
{
	// FIXME
	// Figure out some way to polish the Qt4 widgets with the Qt3 polish method
	// This probably involves modifying Qt3 to specify a painter...
}

void Qt4TDEStyle::polish(QWidget *widget)
{
	// HACK
	// Many TQt3 styles need to be notified when their widgets are moused over
	// The only way we can really do that here is to force a repaint on mouse entry/mouse exit
	// I figure if Qt4 programmers and users can put up with Qt4's overall poor raster graphics
	// performance, they can also put up with this hack...
        widget->setMouseTracking(true);
        widget->installEventFilter(this);
}

void Qt4TDEStyle::unpolish(QWidget *widget)
{
	// HACK
	// See Qt4TDEStyle::polish
        widget->setMouseTracking(false);
        widget->removeEventFilter(this);
}

#define HOVER_SENSITIVE_WIDGET_SELECT		if ( widget->inherits("QPushButton")				\
							|| widget->inherits("QComboBox")			\
							|| widget->inherits("QSpinWidget")			\
							|| widget->inherits("QCheckBox")			\
							|| widget->inherits("QRadioButton")			\
							|| widget->inherits("QToolButton")			\
							|| widget->inherits("QSlider")				\
							|| widget->inherits("QScrollBar")			\
							|| widget->inherits("QTabBar")				\
							|| widget->inherits("QDockWindowHandle")		\
							|| widget->inherits("QSplitterHandle") )

#define FOCUS_SENSITIVE_WIDGET_SELECT		if ( widget->inherits("QLineEdit") )
#define FOCUS_SENSITIVE_PARENT_WIDGET_SELECT	if ( widget->parentWidget() && widget->parentWidget()->inherits("QSpinWidget") )

bool Qt4TDEStyle::eventFilter(QObject *obj, QEvent *ev)
{
	// HACK
	// See Qt4TDEStyle::polish
	if (!obj->isWidgetType() ) {
		return false;
	}

	QWidget* widget = dynamic_cast<QWidget*>(obj);

	if ((ev->type() == QEvent::FocusIn) || (ev->type() == QEvent::FocusOut)) {
		FOCUS_SENSITIVE_WIDGET_SELECT {
			widget->repaint();
		}
		FOCUS_SENSITIVE_PARENT_WIDGET_SELECT {
			widget->parentWidget()->repaint();
		}
	}
	
	if ((ev->type() == QEvent::Enter) || (ev->type() == QEvent::Leave) || (ev->type() == QEvent::Wheel)) {
		HOVER_SENSITIVE_WIDGET_SELECT {
			widget->repaint();
		}
	}
	else {
		if (ev->type() == QEvent::MouseMove) {
			QTabBar *tabbar = dynamic_cast<QTabBar*>(obj);
			QMouseEvent *me = dynamic_cast<QMouseEvent*>(ev);
			if (tabbar && me) {
				// FIXME
				// Avoid unnecessary repaints (which otherwise would occur on every MouseMove event causing high cpu load).
				// Qt4 should really be handling tab mouseover repaint calls instead of relying on this hack...
				bool repaint = true;
				int tab = tabbar->tabAt(me->pos());
				if (hoverTab == tab) {
					repaint = false;
				}
				hoverTab = tab;

				if (repaint) {
					tabbar->repaint();
				}
			}
		}
	}

	// Transparently pass the event on to any other handlers
	return false;
}

QIcon Qt4TDEStyle::standardIconImplementation(StandardPixmap standardIcon, const QStyleOption* opt, const QWidget* w) const
{
	QIcon reticon;
	TQString iconLookupName;
	TQWidget* interfaceWidget = 0;

	char retswitch = 0;
	TQStyle::StylePixmap tqt3stylepixmap = TQStyle::SP_CustomBase;
	switch (standardIcon) {
// 		case QStyle::SP_TitleBarMenuButton;
// 			tqt3stylepixmap = TQStyle::SP_TitleBarMenuButton;
// 			retswitch = 1;
// 			break;
		case QStyle::SP_TitleBarMinButton:
			tqt3stylepixmap = TQStyle::SP_TitleBarMinButton;
			retswitch = 1;
			break;
		case QStyle::SP_TitleBarMaxButton:
			tqt3stylepixmap = TQStyle::SP_TitleBarMaxButton;
			retswitch = 1;
			break;
		case QStyle::SP_TitleBarCloseButton:
			tqt3stylepixmap = TQStyle::SP_TitleBarCloseButton;
			retswitch = 1;
			break;
		case QStyle::SP_TitleBarNormalButton:
			tqt3stylepixmap = TQStyle::SP_TitleBarNormalButton;
			retswitch = 1;
			break;
		case QStyle::SP_TitleBarShadeButton:
			tqt3stylepixmap = TQStyle::SP_TitleBarShadeButton;
			retswitch = 1;
			break;
		case QStyle::SP_TitleBarUnshadeButton:
			tqt3stylepixmap = TQStyle::SP_TitleBarUnshadeButton;
			retswitch = 1;
			break;
// 		case QStyle::SP_TitleBarContextHelpButton:
// 		case QStyle::SP_DockWidgetCloseButton:
		case QStyle::SP_MessageBoxInformation:
			tqt3stylepixmap = TQStyle::SP_MessageBoxInformation;
			retswitch = 1;
			break;
		case QStyle::SP_MessageBoxWarning:
			tqt3stylepixmap = TQStyle::SP_MessageBoxWarning;
			retswitch = 1;
			break;
		case QStyle::SP_MessageBoxCritical:
			tqt3stylepixmap = TQStyle::SP_MessageBoxCritical;
			retswitch = 1;
			break;
		case QStyle::SP_MessageBoxQuestion:
			tqt3stylepixmap = TQStyle::SP_MessageBoxQuestion;
			retswitch = 1;
			break;
#ifdef INTEGRATE_WITH_TDE
		// FIXME
		// Verify these mappings and fill in the missing ones
		case QStyle::SP_DesktopIcon:
			iconLookupName = "desktop";
			retswitch = 3;
			break;
		case QStyle::SP_TrashIcon:
			iconLookupName = "trash";
			retswitch = 3;
			break;
		case QStyle::SP_ComputerIcon:
			iconLookupName = "computer";
			retswitch = 3;
			break;
		case QStyle::SP_DriveFDIcon:
			iconLookupName = "media-floppy-3_5";
			retswitch = 3;
			break;
		case QStyle::SP_DriveHDIcon:
			iconLookupName = "drive-harddisk";
			retswitch = 3;
			break;
		case QStyle::SP_DriveCDIcon:
			iconLookupName = "media-optical-cdrom";
			retswitch = 3;
			break;
		case QStyle::SP_DriveDVDIcon:
			iconLookupName = "media-optical-dvd";
			retswitch = 3;
			break;
// 		case QStyle::SP_DriveNetIcon:
		case QStyle::SP_DirOpenIcon:
			iconLookupName = "folder_open";
			retswitch = 3;
			break;
		case QStyle::SP_DirClosedIcon:
			iconLookupName = "folder";
			retswitch = 3;
			break;
// 		case QStyle::SP_DirLinkIcon:
// 		case QStyle::SP_FileIcon:
// 		case QStyle::SP_FileLinkIcon:
// 		case QStyle::SP_ToolBarHorizontalExtensionButton:
// 		case QStyle::SP_ToolBarVerticalExtensionButton:
		case QStyle::SP_FileDialogStart:
			iconLookupName = "go-first";
			retswitch = 3;
			break;
		case QStyle::SP_FileDialogEnd:
			iconLookupName = "go-last";
			retswitch = 3;
			break;
		case QStyle::SP_FileDialogToParent:
			iconLookupName = "go-up";
			retswitch = 3;
			break;
		case QStyle::SP_FileDialogNewFolder:
			iconLookupName = "folder-new";
			retswitch = 3;
			break;
		case QStyle::SP_FileDialogDetailedView:
			iconLookupName = "view_detailed";
			retswitch = 3;
			break;
		case QStyle::SP_FileDialogInfoView:
			iconLookupName = "view_icon";
			retswitch = 3;
			break;
// 		case QStyle::SP_FileDialogContentsView:
		case QStyle::SP_FileDialogListView:
			iconLookupName = "view_text";
			retswitch = 3;
			break;
		case QStyle::SP_FileDialogBack:
			iconLookupName = "back";
			retswitch = 3;
			break;
		case QStyle::SP_DirIcon:
			iconLookupName = "folder";
			retswitch = 3;
			break;
		case QStyle::SP_DialogOkButton:
			iconLookupName = "button_ok";
			retswitch = 3;
			break;
		case QStyle::SP_DialogCancelButton:
			iconLookupName = "button_cancel";
			retswitch = 3;
			break;
		case QStyle::SP_DialogHelpButton:
			iconLookupName = "help";
			retswitch = 3;
			break;
		case QStyle::SP_DialogOpenButton:
			iconLookupName = "document-open";
			retswitch = 3;
			break;
		case QStyle::SP_DialogSaveButton:
			iconLookupName = "document-save";
			retswitch = 3;
			break;
		case QStyle::SP_DialogCloseButton:
			iconLookupName = "window-close";
			retswitch = 3;
			break;
		case QStyle::SP_DialogApplyButton:
			iconLookupName = "apply";
			retswitch = 3;
			break;
// 		case QStyle::SP_DialogResetButton:
		case QStyle::SP_DialogDiscardButton:
			iconLookupName = "remove";
			retswitch = 3;
			break;
// 		case QStyle::SP_DialogYesButton:
// 		case QStyle::SP_DialogNoButton:
		case QStyle::SP_ArrowUp:
			iconLookupName = "go-up";
			retswitch = 3;
			break;
		case QStyle::SP_ArrowDown:
			iconLookupName = "go-down";
			retswitch = 3;
			break;
// 		case QStyle::SP_ArrowLeft:
// 		case QStyle::SP_ArrowRight:
		case QStyle::SP_ArrowBack:
			iconLookupName = "back";
			retswitch = 3;
			break;
		case QStyle::SP_ArrowForward:
			iconLookupName = "forward";
			retswitch = 3;
			break;
		case QStyle::SP_DirHomeIcon:
			iconLookupName = "folder_home";
			retswitch = 3;
			break;
// 		case QStyle::SP_CommandLink:
// 		case QStyle::SP_VistaShield:
		case QStyle::SP_BrowserReload:
			iconLookupName = "reload";
			retswitch = 3;
			break;
		case QStyle::SP_BrowserStop:
			iconLookupName = "process-stop";
			retswitch = 3;
			break;
		case QStyle::SP_MediaPlay:
			iconLookupName = "media-playback-start";
			retswitch = 3;
			break;
		case QStyle::SP_MediaStop:
			iconLookupName = "media-playback-stop";
			retswitch = 3;
			break;
		case QStyle::SP_MediaPause:
			iconLookupName = "media-playback-pause";
			retswitch = 3;
			break;
		case QStyle::SP_MediaSkipForward:
			iconLookupName = "media-skip-forward";
			retswitch = 3;
			break;
		case QStyle::SP_MediaSkipBackward:
			iconLookupName = "media-skip-backward";
			retswitch = 3;
			break;
		case QStyle::SP_MediaSeekForward:
			iconLookupName = "media-seek-forward";
			retswitch = 3;
			break;
		case QStyle::SP_MediaSeekBackward:
			iconLookupName = "media-seek-backward";
			retswitch = 3;
			break;
// 		case QStyle::SP_MediaVolume:
// 		case QStyle::SP_MediaVolumeMuted:
#endif // INTEGRATE_WITH_TDE
		default:
			if (enable_debug_warnings) {
				printf("No pixmap for Qt4 standard pixmap request %d\n", standardIcon); fflush(stdout);
			}
	}

	if (retswitch == 1) {
		TQPixmap tqt3pixmap = tqApp->style().stylePixmap(tqt3stylepixmap, interfaceWidget);
		// FIXME
		// This spews tons of "X Error: BadDrawable (invalid Pixmap or Window parameter) 9" errors and fails to work
// 		if (tqt3pixmap.isNull() == false) {
// 			reticon = convertTQt3PixmapToQt4Icon(tqt3pixmap);
// 		}
// 		else {
			// Tell Qt4 to get the information
			reticon = BASE_QT4_STYLE_CLASS::standardIconImplementation(standardIcon, opt, w);
// 		}
	}
	else {
		if (retswitch == 2) {
			// reticon was already set
		}
		else if (retswitch == 3) {
			// convert string to icon
			reticon = QIcon(convertTQt3ToQt4String(TDEGlobal::iconLoader()->iconPath(iconLookupName, TDEIcon::Desktop, true)));
		}
		else {
			// Tell Qt4 to get the information
			reticon = BASE_QT4_STYLE_CLASS::standardIconImplementation(standardIcon, opt, w);
		}
	}

	return reticon;
}

int Qt4TDEStyle::styleHint(StyleHint hint, const QStyleOption *opt, const QWidget *w, QStyleHintReturn* returnData) const
{
	Q_UNUSED(returnData);

	int retval = 0;
	TQWidget* interfaceWidget = 0;

	char retswitch = 0;
	TQStyle::StyleHint tqt3stylehint = TQStyle::SH_CustomBase;
	switch (hint) {
		// FIXME
		// Hardcode defaults from TQt3 where case statements have been commented out below...
		case QStyle::SH_EtchDisabledText:
			tqt3stylehint = TQStyle::SH_EtchDisabledText;
			retswitch=1;
			break;
// 		case QStyle::SH_DitherDisabledText:
// 			tqt3stylehint = TQStyle::SH_DitherDisabledText;
// 			retswitch=1;
// 			break;
		case QStyle::SH_ScrollBar_MiddleClickAbsolutePosition:
			tqt3stylehint = TQStyle::SH_ScrollBar_MiddleClickAbsolutePosition;
			retswitch=1;
			break;
		case QStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl:
			tqt3stylehint = TQStyle::SH_ScrollBar_ScrollWhenPointerLeavesControl;
			retswitch=1;
			break;
		case QStyle::SH_TabBar_SelectMouseType:
			tqt3stylehint = TQStyle::SH_TabBar_SelectMouseType;
			retswitch=1;
			break;
		case QStyle::SH_TabBar_Alignment:
			tqt3stylehint = TQStyle::SH_TabBar_Alignment;
			retswitch=1;
			break;
		case QStyle::SH_Header_ArrowAlignment:
			tqt3stylehint = TQStyle::SH_Header_ArrowAlignment;
			retswitch=1;
			break;
		case QStyle::SH_Slider_SnapToValue:
			tqt3stylehint = TQStyle::SH_Slider_SnapToValue;
			retswitch=1;
			break;
		case QStyle::SH_Slider_SloppyKeyEvents:
			tqt3stylehint = TQStyle::SH_Slider_SloppyKeyEvents;
			retswitch=1;
			break;
		case QStyle::SH_ProgressDialog_CenterCancelButton:
			tqt3stylehint = TQStyle::SH_ProgressDialog_CenterCancelButton;
			retswitch=1;
			break;
		case QStyle::SH_ProgressDialog_TextLabelAlignment:
			tqt3stylehint = TQStyle::SH_ProgressDialog_TextLabelAlignment;
			retswitch=1;
			break;
		case QStyle::SH_PrintDialog_RightAlignButtons:
			tqt3stylehint = TQStyle::SH_PrintDialog_RightAlignButtons;
			retswitch=1;
			break;
		case QStyle::SH_MainWindow_SpaceBelowMenuBar:
			tqt3stylehint = TQStyle::SH_MainWindow_SpaceBelowMenuBar;
			retswitch=1;
			break;
		case QStyle::SH_FontDialog_SelectAssociatedText:
			tqt3stylehint = TQStyle::SH_FontDialog_SelectAssociatedText;
			retswitch=1;
			break;
		case QStyle::SH_Menu_AllowActiveAndDisabled:
			tqt3stylehint = TQStyle::SH_PopupMenu_AllowActiveAndDisabled;
			retswitch=1;
			break;
		case QStyle::SH_Menu_SpaceActivatesItem:
			tqt3stylehint = TQStyle::SH_PopupMenu_SpaceActivatesItem;
			retswitch=1;
			break;
		case QStyle::SH_Menu_SubMenuPopupDelay:
			tqt3stylehint = TQStyle::SH_PopupMenu_SubMenuPopupDelay;
			retswitch=1;
			break;
		case QStyle::SH_ScrollView_FrameOnlyAroundContents:
			tqt3stylehint = TQStyle::SH_ScrollView_FrameOnlyAroundContents;
			retswitch=1;
			break;
		case QStyle::SH_MenuBar_AltKeyNavigation:
			tqt3stylehint = TQStyle::SH_MenuBar_AltKeyNavigation;
			retswitch=1;
			break;
		case QStyle::SH_ComboBox_ListMouseTracking:
			tqt3stylehint = TQStyle::SH_ComboBox_ListMouseTracking;
			retswitch=1;
			break;
		case QStyle::SH_Menu_MouseTracking:
			tqt3stylehint = TQStyle::SH_PopupMenu_MouseTracking;
			retswitch=1;
			break;
		case QStyle::SH_MenuBar_MouseTracking:
			tqt3stylehint = TQStyle::SH_MenuBar_MouseTracking;
			retswitch=1;
			break;
		case QStyle::SH_ItemView_ChangeHighlightOnFocus:
			tqt3stylehint = TQStyle::SH_ItemView_ChangeHighlightOnFocus;
			retswitch=1;
			break;
		case QStyle::SH_Widget_ShareActivation:
			tqt3stylehint = TQStyle::SH_Widget_ShareActivation;
			retswitch=1;
			break;
		case QStyle::SH_Workspace_FillSpaceOnMaximize:
			tqt3stylehint = TQStyle::SH_Workspace_FillSpaceOnMaximize;
			retswitch=1;
			break;
		case QStyle::SH_ComboBox_Popup:
			tqt3stylehint = TQStyle::SH_ComboBox_Popup;
			retswitch=1;
			break;
		case QStyle::SH_TitleBar_NoBorder:
			// HACK
			// Qt4 again shows its limitations!
			// Why are titlebar borders more limited in Qt4???  You can only choose between no borders or borders of exactly 4 pixels when using Qt4...
			if (tqApp->style().pixelMetric(TQStyle::PM_MDIFrameWidth, interfaceWidget) < 4) {
				retval=1;
			}
			else {
				retval=0;
			}
			retswitch=2;
			break;
// 		case QStyle::SH_Slider_StopMouseOverSlider:
// 			tqt3stylehint = TQStyle::SH_Slider_StopMouseOverSlider;
// 			retswitch=1;
// 			break;
		case QStyle::SH_BlinkCursorWhenTextSelected:
			tqt3stylehint = TQStyle::SH_BlinkCursorWhenTextSelected;
			retswitch=1;
			break;
		case QStyle::SH_RichText_FullWidthSelection:
			tqt3stylehint = TQStyle::SH_RichText_FullWidthSelection;
			retswitch=1;
			break;
		case QStyle::SH_Menu_Scrollable:
			tqt3stylehint = TQStyle::SH_PopupMenu_Scrollable;
			retswitch=1;
			break;
		// FIXME
		// Apparently SH_GroupBox_TextLabelVerticalAlignment returns something different (enum value?) under TQt3,
		// so translation will be needed.
// 		case QStyle::SH_GroupBox_TextLabelVerticalAlignment:
// 			tqt3stylehint = TQStyle::SH_GroupBox_TextLabelVerticalAlignment;
// 			retswitch=1;
// 			break;
		case QStyle::SH_GroupBox_TextLabelColor:
			tqt3stylehint = TQStyle::SH_GroupBox_TextLabelColor;
			retswitch=1;
			break;
		case QStyle::SH_Menu_SloppySubMenus:
			tqt3stylehint = TQStyle::SH_PopupMenu_SloppySubMenus;
			retswitch=1;
			break;
		case QStyle::SH_Table_GridLineColor:
			tqt3stylehint = TQStyle::SH_Table_GridLineColor;
			retswitch=1;
			break;
		case QStyle::SH_LineEdit_PasswordCharacter:
			tqt3stylehint = TQStyle::SH_LineEdit_PasswordCharacter;
			retswitch=1;
			break;
		case QStyle::SH_DialogButtons_DefaultButton:
			tqt3stylehint = TQStyle::SH_DialogButtons_DefaultButton;
			retswitch=1;
			break;
		case QStyle::SH_ToolBox_SelectedPageTitleBold:
			tqt3stylehint = TQStyle::SH_ToolBox_SelectedPageTitleBold;
			retswitch=1;
			break;
		case QStyle::SH_TabBar_PreferNoArrows:
			tqt3stylehint = TQStyle::SH_TabBar_PreferNoArrows;
			retswitch=1;
			break;
		case QStyle::SH_ScrollBar_LeftClickAbsolutePosition:
			tqt3stylehint = TQStyle::SH_ScrollBar_LeftClickAbsolutePosition;
			retswitch=1;
			break;
// 		case QStyle::SH_Q3ListViewExpand_SelectMouseType:
// 			tqt3stylehint = TQStyle::SH_Q3ListViewExpand_SelectMouseType;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_UnderlineShortcut:
// 			tqt3stylehint = TQStyle::SH_UnderlineShortcut;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_SpinBox_AnimateButton:
// 			tqt3stylehint = TQStyle::SH_SpinBox_AnimateButton;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_SpinBox_KeyPressAutoRepeatRate:
// 			tqt3stylehint = TQStyle::SH_SpinBox_KeyPressAutoRepeatRate;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_SpinBox_ClickAutoRepeatRate:
// 			tqt3stylehint = TQStyle::SH_SpinBox_ClickAutoRepeatRate;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Menu_FillScreenWithScroll:
// 			tqt3stylehint = TQStyle::SH_PopupMenu_FillScreenWithScroll;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ToolTipLabel_Opacity:
// 			tqt3stylehint = TQStyle::SH_ToolTipLabel_Opacity;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_DrawMenuBarSeparator:
// 			tqt3stylehint = TQStyle::SH_DrawMenuBarSeparator;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_TitleBar_ModifyNotification:
// 			tqt3stylehint = TQStyle::SH_TitleBar_ModifyNotification;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Button_FocusPolicy:
// 			tqt3stylehint = TQStyle::SH_Button_FocusPolicy;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_MenuBar_DismissOnSecondClick:
// 			tqt3stylehint = TQStyle::SH_MenuBar_DismissOnSecondClick;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_MessageBox_UseBorderForButtonSpacing:
// 			tqt3stylehint = TQStyle::SH_MessageBox_UseBorderForButtonSpacing;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_TitleBar_AutoRaise:
// 			tqt3stylehint = TQStyle::SH_TitleBar_AutoRaise;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ToolButton_PopupDelay:
// 			tqt3stylehint = TQStyle::SH_ToolButton_PopupDelay;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_FocusFrame_Mask:
// 			tqt3stylehint = TQStyle::SH_FocusFrame_Mask;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_RubberBand_Mask:
// 			tqt3stylehint = TQStyle::SH_RubberBand_Mask;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_WindowFrame_Mask:
// 			tqt3stylehint = TQStyle::SH_WindowFrame_Mask;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_SpinControls_DisableOnBounds:
// 			tqt3stylehint = TQStyle::SH_SpinControls_DisableOnBounds;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Dial_BackgroundRole:
// 			tqt3stylehint = TQStyle::SH_Dial_BackgroundRole;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ComboBox_LayoutDirection:
// 			tqt3stylehint = TQStyle::SH_ComboBox_LayoutDirection;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_EllipsisLocation:
// 			tqt3stylehint = TQStyle::SH_ItemView_EllipsisLocation;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_ShowDecorationSelected:
// 			tqt3stylehint = TQStyle::SH_ItemView_ShowDecorationSelected;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_ActivateItemOnSingleClick:
// 			tqt3stylehint = TQStyle::SH_ItemView_ActivateItemOnSingleClick;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ScrollBar_ContextMenu:
// 			tqt3stylehint = TQStyle::SH_ScrollBar_ContextMenu;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ScrollBar_RollBetweenButtons:
// 			tqt3stylehint = TQStyle::SH_ScrollBar_RollBetweenButtons;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Slider_AbsoluteSetButtons:
// 			tqt3stylehint = TQStyle::SH_Slider_AbsoluteSetButtons;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Slider_PageSetButtons:
// 			tqt3stylehint = TQStyle::SH_Slider_PageSetButtons;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Menu_KeyboardSearch:
// 			tqt3stylehint = TQStyle::SH_PopupMenu_KeyboardSearch;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_TabBar_ElideMode:
// 			tqt3stylehint = TQStyle::SH_TabBar_ElideMode;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_DialogButtonLayout:
// 			tqt3stylehint = TQStyle::SH_DialogButtonLayout;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ComboBox_PopupFrameStyle:
// 			tqt3stylehint = TQStyle::SH_ComboBox_PopupFrameStyle;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_MessageBox_TextInteractionFlags:
// 			tqt3stylehint = TQStyle::SH_MessageBox_TextInteractionFlags;
// 			retswitch=1;
// 			break;
		case QStyle::SH_DialogButtonBox_ButtonsHaveIcons:
			retval = m_tqt3DialogButtons_ShowIcons;
			retswitch=2;
			break;
// 		case QStyle::SH_SpellCheckUnderlineStyle:
// 			tqt3stylehint = TQStyle::SH_SpellCheckUnderlineStyle;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_MessageBox_CenterButtons:
// 			tqt3stylehint = TQStyle::SH_MessageBox_CenterButtons;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Menu_SelectionWrap:
// 			tqt3stylehint = TQStyle::SH_Menu_SelectionWrap;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_MovementWithoutUpdatingSelection:
// 			tqt3stylehint = TQStyle::SH_ItemView_MovementWithoutUpdatingSelection;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ToolTip_Mask:
// 			tqt3stylehint = TQStyle::SH_ToolTip_Mask;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_FocusFrame_AboveWidget:
// 			tqt3stylehint = TQStyle::SH_FocusFrame_AboveWidget;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_TextControl_FocusIndicatorTextCharFormat:
// 			tqt3stylehint = TQStyle::SH_TextControl_FocusIndicatorTextCharFormat;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_WizardStyle:
// 			tqt3stylehint = TQStyle::SH_WizardStyle;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_ArrowKeysNavigateIntoChildren:
// 			tqt3stylehint = TQStyle::SH_ItemView_ArrowKeysNavigateIntoChildren;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Menu_Mask:
// 			tqt3stylehint = TQStyle::SH_Menu_Mask;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Menu_FlashTriggeredItem:
// 			tqt3stylehint = TQStyle::SH_Menu_FlashTriggeredItem;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_Menu_FadeOutOnHide:
// 			tqt3stylehint = TQStyle::SH_Menu_FadeOutOnHide;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_SpinBox_ClickAutoRepeatThreshold:
// 			tqt3stylehint = TQStyle::SH_SpinBox_ClickAutoRepeatThreshold;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea:
// 			tqt3stylehint = TQStyle::SH_ItemView_PaintAlternatingRowColorsForEmptyArea;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_FormLayoutWrapPolicy:
// 			tqt3stylehint = TQStyle::SH_FormLayoutWrapPolicy;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_TabWidget_DefaultTabPosition:
// 			tqt3stylehint = TQStyle::SH_TabWidget_DefaultTabPosition;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ToolBar_Movable:
// 			tqt3stylehint = TQStyle::SH_ToolBar_Movable;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_FormLayoutFieldGrowthPolicy:
// 			tqt3stylehint = TQStyle::SH_FormLayoutFieldGrowthPolicy;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_FormLayoutFormAlignment:
// 			tqt3stylehint = TQStyle::SH_FormLayoutFormAlignment;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_FormLayoutLabelAlignment:
// 			tqt3stylehint = TQStyle::SH_FormLayoutLabelAlignment;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ItemView_DrawDelegateFrame:
// 			tqt3stylehint = TQStyle::SH_ItemView_DrawDelegateFrame;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_TabBar_CloseButtonPosition:
// 			tqt3stylehint = TQStyle::SH_TabBar_CloseButtonPosition;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_DockWidget_ButtonsHaveFrame:
// 			tqt3stylehint = TQStyle::SH_DockWidget_ButtonsHaveFrame;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_ToolButtonStyle:
// 			tqt3stylehint = TQStyle::SH_ToolButtonStyle;
// 			retswitch=1;
// 			break;
// 		case QStyle::SH_RequestSoftwareInputPanel:
// 			tqt3stylehint = TQStyle::SH_RequestSoftwareInputPanel;
// 			retswitch=1;
// 			break;
		default:
			if (enable_debug_warnings) {
				printf("No hints for Qt4 hint request %d\n", hint); fflush(stdout);
			}
			retval = 0;
	}

	if (retswitch == 1) {
		retval = tqApp->style().styleHint(tqt3stylehint, interfaceWidget);
	}
	else {
		if (retswitch == 2) {
			// retval was already set
		}
		else {
			// Tell Qt4 to get the information
			retval = BASE_QT4_STYLE_CLASS::styleHint(hint, opt, w);
		}
	}

	return retval;
}

QSize Qt4TDEStyle::sizeFromContents(ContentsType type, const QStyleOption *opt, const QSize &contentsSize, const QWidget *w) const
{
	int i;

	QSize retval;
	TQWidget* interfaceWidget = 0;
	TQStyleOption tqt3opt(TQStyleOption::Default);

	TQMenuItem* drawingItem = 0;
	QList<QAction*> qt4menuactions;
	int tqt3tabwidth = 0;
	int tqt3iconwidth = 0;
	const QStyleOptionMenuItem* qt4menuitemoptions;

	char retswitch = 0;
	TQStyle::ContentsType tqt3contentstype = TQStyle::CT_CustomBase;

	switch (type) {
		case QStyle::CT_MenuItem:
			tqt3contentstype = TQStyle::CT_PopupMenuItem;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQPopupMenu, w);
			if (interfaceWidget == 0) {
				retswitch = 0;
			}
			else {
				// Convert the QStyleOption to the proper TQStyleOption
				// In other words, figure out which TQt3 menu item is currently being drawn
				// Qt4 makes this impossible in sizeFromContents()
				// The best we can do is to find a menu item that is somewhat close and use that
				drawingItem = 0;
				qt4menuactions = dynamic_cast<const QMenu*>(w)->actions();
				qt4menuitemoptions = static_cast<const QStyleOptionMenuItem*>(opt);

				for (i=0; i<qt4menuactions.size();++i) {
					if (((qt4menuactions.at(i)->isSeparator() == 1) == (qt4menuitemoptions->menuItemType == QStyleOptionMenuItem::Separator))
						&& (qt4menuactions.at(i)->icon().cacheKey() == qt4menuitemoptions->icon.cacheKey())
						&& (qt4menuactions.at(i)->text() == qt4menuitemoptions->text)
						&& (qt4menuactions.at(i)->isChecked() == qt4menuitemoptions->checked)
						) {
							TQPopupMenu* popupMenuWidget = dynamic_cast<TQPopupMenu*>(interfaceWidget);
							drawingItem = popupMenuWidget->findItem(popupMenuWidget->idAt(i));
							break;
					}
				}

				if (drawingItem) {
					tqt3tabwidth = static_cast<const QStyleOptionMenuItem*>(opt)->tabWidth;
					tqt3iconwidth = static_cast<const QStyleOptionMenuItem*>(opt)->maxIconWidth;
					tqt3opt = TQStyleOption(drawingItem, tqt3iconwidth, tqt3tabwidth);

					retswitch = 1;
				}
			}
			break;
		default:
			if (enable_debug_warnings) {
				printf("No size for Qt4 contents %d\n", type); fflush(stdout);
			}
	}

	if (retswitch == 1) {
		retval = convertTQt3ToQt4Size(tqApp->style().sizeFromContents(tqt3contentstype, interfaceWidget, convertQt4ToTQt3Size(contentsSize), tqt3opt));
	}
	else {
		if (retswitch == 2) {
			// retval was already set
		}
		else {
			// Tell Qt4 to get the information
			retval = BASE_QT4_STYLE_CLASS::sizeFromContents(type, opt, contentsSize, w);
		}
	}

	return retval;
}

int Qt4TDEStyle::pixelMetric(PixelMetric metric, const QStyleOption *opt, const QWidget *w) const
{
	int retval = 0;
	TQWidget* interfaceWidget = 0;

	char retswitch = 0;
	TQStyle::PixelMetric tqt3pixelmetric = TQStyle::PM_CustomBase;
	switch (metric) {
		case QStyle::PM_ButtonMargin:
			tqt3pixelmetric = TQStyle::PM_ButtonMargin;
			retswitch = 1;
			break;
// 		case QStyle::PM_DockWidgetTitleBarButtonMargin:
// 			tqt3pixelmetric = TQStyle::;
// 			retswitch = 1;
// 			break;
		case QStyle::PM_ButtonDefaultIndicator:
			tqt3pixelmetric = TQStyle::PM_ButtonDefaultIndicator;
			retswitch = 1;
			break;
		case QStyle::PM_MenuButtonIndicator:
			tqt3pixelmetric = TQStyle::PM_MenuButtonIndicator;
			retswitch = 1;
			break;
		case QStyle::PM_ButtonShiftHorizontal:
			tqt3pixelmetric = TQStyle::PM_ButtonShiftHorizontal;
			retswitch = 1;
			break;
		case QStyle::PM_ButtonShiftVertical:
			tqt3pixelmetric = TQStyle::PM_ButtonShiftVertical;
			retswitch = 1;
			break;
		case QStyle::PM_DefaultFrameWidth:
			tqt3pixelmetric = TQStyle::PM_DefaultFrameWidth;
			retswitch = 1;
			break;
		case QStyle::PM_SpinBoxFrameWidth:
			tqt3pixelmetric = TQStyle::PM_SpinBoxFrameWidth;
			retswitch = 1;
			break;
// 		case QStyle::PM_ComboBoxFrameWidth:
// 			tqt3pixelmetric = TQStyle::PM_ComboBoxFrameWidth;
// 			retswitch = 1;
// 			break;
		case QStyle::PM_MdiSubWindowFrameWidth:
			tqt3pixelmetric = TQStyle::PM_MDIFrameWidth;
			retswitch = 1;
			break;
		case QStyle::PM_MDIMinimizedWidth:
			tqt3pixelmetric = TQStyle::PM_MDIMinimizedWidth;
			retswitch = 1;
			break;
// 		case QStyle::PM_MdiSubWindowMinimizedWidth:
// 			tqt3pixelmetric = TQStyle::PM_MdiSubWindowMinimizedWidth;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_LayoutLeftMargin:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
// 		case QStyle::PM_LayoutTopMargin:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
// 		case QStyle::PM_LayoutRightMargin:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
// 		case QStyle::PM_LayoutBottomMargin:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
// 		case QStyle::PM_LayoutHorizontalSpacing:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
// 		case QStyle::PM_LayoutVerticalSpacing:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
		case QStyle::PM_MaximumDragDistance:
			tqt3pixelmetric = TQStyle::PM_MaximumDragDistance;
			retswitch = 1;
			break;
		case QStyle::PM_ScrollBarExtent:
			tqt3pixelmetric = TQStyle::PM_ScrollBarExtent;
			retswitch = 1;
			break;
		case QStyle::PM_ScrollBarSliderMin:
			tqt3pixelmetric = TQStyle::PM_ScrollBarSliderMin;
			retswitch = 1;
			break;
		case QStyle::PM_SliderThickness:
			tqt3pixelmetric = TQStyle::PM_SliderThickness;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSlider, w);
			retswitch = 1;
			break;
		case QStyle::PM_SliderControlThickness:
			tqt3pixelmetric = TQStyle::PM_SliderControlThickness;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSlider, w);
			retswitch = 1;
			break;
		case QStyle::PM_SliderLength:
			tqt3pixelmetric = TQStyle::PM_SliderLength;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSlider, w);
			retswitch = 1;
			break;
		case QStyle::PM_SliderTickmarkOffset:
			tqt3pixelmetric = TQStyle::PM_SliderTickmarkOffset;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSlider, w);
			retswitch = 1;
			break;
		case QStyle::PM_SliderSpaceAvailable:
			tqt3pixelmetric = TQStyle::PM_SliderSpaceAvailable;
			retswitch = 1;
			break;
		case QStyle::PM_DockWidgetSeparatorExtent:
			tqt3pixelmetric = TQStyle::PM_DockWindowSeparatorExtent;
			retswitch = 1;
			break;
		case QStyle::PM_DockWidgetHandleExtent:
			tqt3pixelmetric = TQStyle::PM_DockWindowHandleExtent;
			retswitch = 1;
			break;
		case QStyle::PM_DockWidgetFrameWidth:
			tqt3pixelmetric = TQStyle::PM_DockWindowFrameWidth;
			retswitch = 1;
			break;
// 		case QStyle::PM_DockWidgetTitleMargin:
// 			tqt3pixelmetric = TQStyle::PM_DockWindowTitleMargin;
// 			retswitch = 1;
// 			break;
		case QStyle::PM_MenuBarPanelWidth:
			tqt3pixelmetric = TQStyle::PM_MenuBarFrameWidth;
			retswitch = 1;
			break;
		case QStyle::PM_MenuBarItemSpacing:
			tqt3pixelmetric = TQStyle::PM_MenuBarItemSpacing;
			retswitch = 1;
			break;
// 		case QStyle::PM_MenuBarHMargin:
// 			tqt3pixelmetric = TQStyle::PM_MenuBarHMargin;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_MenuBarVMargin:
// 			tqt3pixelmetric = TQStyle::PM_MenuBarVMargin;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolBarFrameWidth:
// 			tqt3pixelmetric = TQStyle::PM_ToolBarFrameWidth;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolBarHandleExtent:
// 			tqt3pixelmetric = TQStyle::PM_ToolBarHandleExtent;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolBarItemMargin:
// 			tqt3pixelmetric = TQStyle::PM_ToolBarItemMargin;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolBarItemSpacing:
// 			tqt3pixelmetric = TQStyle::PM_ToolBarItemSpacing;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolBarSeparatorExtent:
// 			tqt3pixelmetric = TQStyle::PM_ToolBarSeparatorExtent;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolBarExtensionExtent:
// 			tqt3pixelmetric = TQStyle::PM_ToolBarExtensionExtent;
// 			retswitch = 1;
// 			break;
		case QStyle::PM_TabBarTabOverlap:
			tqt3pixelmetric = TQStyle::PM_TabBarTabOverlap;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarTabHSpace:
			tqt3pixelmetric = TQStyle::PM_TabBarTabHSpace;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarTabVSpace:
			tqt3pixelmetric = TQStyle::PM_TabBarTabVSpace;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarBaseHeight:
			tqt3pixelmetric = TQStyle::PM_TabBarBaseHeight;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarBaseOverlap:
			tqt3pixelmetric = TQStyle::PM_TabBarBaseOverlap;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarScrollButtonWidth:
			tqt3pixelmetric = TQStyle::PM_TabBarScrollButtonWidth;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarTabShiftHorizontal:
			tqt3pixelmetric = TQStyle::PM_TabBarTabShiftHorizontal;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_TabBarTabShiftVertical:
			tqt3pixelmetric = TQStyle::PM_TabBarTabShiftVertical;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w);
			retswitch = 1;
			break;
		case QStyle::PM_ProgressBarChunkWidth:
			tqt3pixelmetric = TQStyle::PM_ProgressBarChunkWidth;
			retswitch = 1;
			break;
		case QStyle::PM_SplitterWidth:
			tqt3pixelmetric = TQStyle::PM_SplitterWidth;
			retswitch = 1;
			break;
		case QStyle::PM_TitleBarHeight:
			tqt3pixelmetric = TQStyle::PM_TitleBarHeight;
			if (opt) {
				m_tqt3generic_widget->setGeometry(0, 0, opt->rect.width(), opt->rect.height());
				interfaceWidget = m_tqt3generic_widget;
				retswitch = 1;
			}
			break;
		case QStyle::PM_IndicatorWidth:
			tqt3pixelmetric = TQStyle::PM_IndicatorWidth;
			retswitch = 1;
			break;
		case QStyle::PM_IndicatorHeight:
			tqt3pixelmetric = TQStyle::PM_IndicatorHeight;
			retswitch = 1;
			break;
		case QStyle::PM_ExclusiveIndicatorWidth:
			tqt3pixelmetric = TQStyle::PM_ExclusiveIndicatorWidth;
			retswitch = 1;
			break;
		case QStyle::PM_ExclusiveIndicatorHeight:
			tqt3pixelmetric = TQStyle::PM_ExclusiveIndicatorHeight;
			retswitch = 1;
			break;
// 		case QStyle::PM_MenuPanelWidth:
// 			retval = 0;
// 			retswitch = 2;
// 			break;
		case QStyle::PM_MenuHMargin:
			tqt3pixelmetric = TQStyle::PM_PopupMenuFrameHorizontalExtra;
			retswitch = 1;
			break;
		case QStyle::PM_MenuVMargin:
			tqt3pixelmetric = TQStyle::PM_PopupMenuFrameVerticalExtra;
			retswitch = 1;
			break;
// 		case QStyle::PM_MenuScrollerHeight:
// 			tqt3pixelmetric = TQStyle::PM_MenuScrollerHeight;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_MenuTearoffHeight:
// 			tqt3pixelmetric = TQStyle::PM_MenuTearoffHeight;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_MenuDesktopFrameWidth:
// 			tqt3pixelmetric = TQStyle::PM_MenuDesktopFrameWidth;
// 			retswitch = 1;
// 			break;
		case QStyle::PM_CheckListButtonSize:
			tqt3pixelmetric = TQStyle::PM_CheckListButtonSize;
			retswitch = 1;
			break;
		case QStyle::PM_CheckListControllerSize:
			tqt3pixelmetric = TQStyle::PM_CheckListControllerSize;
			retswitch = 1;
			break;
		case QStyle::PM_HeaderMarkSize:
			tqt3pixelmetric = TQStyle::PM_HeaderMarkSize;
			retswitch = 1;
			break;
		case QStyle::PM_HeaderGripMargin:
			tqt3pixelmetric = TQStyle::PM_HeaderGripMargin;
			retswitch = 1;
			break;
		case QStyle::PM_HeaderMargin:
			tqt3pixelmetric = TQStyle::PM_HeaderMargin;
			retswitch = 1;
			break;
		case QStyle::PM_ToolBarIconSize:
			retval = m_tqt3IconSize_Toolbar;
			retswitch = 2;
			break;
		case QStyle::PM_SmallIconSize:
			retval = m_tqt3IconSize_Small;
			retswitch = 2;
			break;
		case QStyle::PM_LargeIconSize:
			retval = m_tqt3IconSize_Large;
			retswitch = 2;
			break;
		case QStyle::PM_TabBarIconSize:
			retval = m_tqt3IconSize_Tabbar;
			retswitch = 2;
			break;
		case QStyle::PM_IconViewIconSize:
			retval = m_tqt3IconSize_Desktop;
			retswitch = 2;
			break;
		case QStyle::PM_ListViewIconSize:
			retval = m_tqt3IconSize_Listview;
			retswitch = 2;
			break;
		case QStyle::PM_ButtonIconSize:
			retval = m_tqt3IconSize_Button;
			retswitch = 2;
			break;
// 		case QStyle::PM_MessageBoxIconSize:
// 			tqt3pixelmetric = TQStyle::PM_MessageBoxIconSize;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_SpinBoxSliderHeight:
// 			tqt3pixelmetric = TQStyle::PM_SpinBoxSliderHeight;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_FocusFrameHMargin:
// 			tqt3pixelmetric = TQStyle::PM_FocusFrameHMargin;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_FocusFrameVMargin:
// 			tqt3pixelmetric = TQStyle::PM_FocusFrameVMargin;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_ToolTipLabelFrameWidth:
// 			tqt3pixelmetric = TQStyle::PM_ToolTipLabelFrameWidth;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_CheckBoxLabelSpacing:
// 			tqt3pixelmetric = TQStyle::PM_CheckBoxLabelSpacing;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_RadioButtonLabelSpacing:
// 			tqt3pixelmetric = TQStyle::PM_RadioButtonLabelSpacing;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_SizeGripSize:
// 			tqt3pixelmetric = TQStyle::PM_SizeGripSize;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_TextCursorWidth:
// 			tqt3pixelmetric = TQStyle::PM_TextCursorWidth;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_TabBar_ScrollButtonOverlap:
// 			tqt3pixelmetric = TQStyle::PM_TabBar_ScrollButtonOverlap;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_TabCloseIndicatorWidth:
// 			tqt3pixelmetric = TQStyle::PM_TabCloseIndicatorWidth;
// 			retswitch = 1;
// 			break;
// 		case QStyle::PM_TabCloseIndicatorHeight:
// 			tqt3pixelmetric = TQStyle::PM_TabCloseIndicatorHeight;
// 			retswitch = 1;
// 			break;
		default:
			if (enable_debug_warnings) {
				printf("No metrics for Qt4 element %d\n", metric); fflush(stdout);
			}
			retval = 0;
	}

	if (retswitch == 1) {
		retval = tqApp->style().pixelMetric(tqt3pixelmetric, interfaceWidget);
		// HACK
		// For some reason Qt4 tacks on a pixel to this by default
		// FIXME
		// Figure out why!
		if (tqt3pixelmetric == TQStyle::PM_TabBarTabVSpace) {
			retval = retval - 1;
		}
		// HACK
		// Qt4 does not normally allow enough space for the rightmost tab to be
		// completely drawn when PM_TabBarTabOverlap is greater than zero
		// This is related to the fact that PM_TabBarTabOverlap is not implemented in Qt4
		if (tqt3pixelmetric == TQStyle::PM_TabBarTabHSpace) {
			retval = retval + tqApp->style().pixelMetric(TQStyle::PM_TabBarTabOverlap, interfaceWidget);
		}
	}
	else {
		if (retswitch == 2) {
			// retval was already set
		}
		else {
			// Tell Qt4 to get the information
			retval = BASE_QT4_STYLE_CLASS::pixelMetric(metric, opt, w);
		}
	}

	return retval;
}

TQWidget* Qt4TDEStyle::initializeInterfaceWidget(TQt3WidgetType wt, const QWidget* w, const QStyleOption* qt4styleoptions, bool forceReload) const
{
	int i;
	TQWidget* interfaceWidget = 0;

	// Qt4 interface widget pointers
	const QTabBar* qt4tabbar_widget = 0;
	const QRadioButton* qt4radiobutton_widget = 0;
	const QCheckBox* qt4checkbox_widget = 0;
	const QPushButton* qt4pushbutton_widget = 0;
	const QMenu* qt4menu_widget = 0;
	const QProgressBar* qt4progressbar_widget = 0;
	const QComboBox* qt4combobox_widget = 0;
	const QSlider* qt4slider_widget = 0;
	const QScrollBar* qt4scrollbar_widget = 0;
	const QAbstractSpinBox* qt4spinbox_widget = 0;
	const QMenuBar* qt4menubar_widget = 0;
	const QToolBox* qt4toolbox_widget = 0;
	const QToolButton* qt4toolbutton_widget = 0;

	const QStyleOptionTitleBar* qt4titlebar_options = 0;

	TQTabBar::Shape tqt3tbshape = TQTabBar::RoundedAbove;

	QList<QAction*> qt4menuactions;
	QAction* currentAction;

	TQColor bgcolor;

	TQWidget* cacheResult = 0;
	const QObject* qt4objectptr = dynamic_cast<const QObject*>(w);
	if (qt4objectptr) {
		cacheResult = m_internalTQt3WidgetCache->find((long)qt4objectptr);
	}
	else {
		return NULL;
	}

	if (forceReload == false) {
		// NOTE
		// Enabling this for every widget breaks sliders and all other dynamically updated widgets
		// Disabling it for every widget makes the style engine run too slowly to be of much use
		// Much of the slowdown appears to be from Qt4TDEStyle::pixelMetric calling this method
		if (cacheResult) {
			if (/*(wt == TQT3WT_TQProgressBar)*/
				/*||*/ (wt == TQT3WT_TQTabBar)
				|| (wt == TQT3WT_TQRadioButton)
				|| (wt == TQT3WT_TQCheckBox)
				|| (wt == TQT3WT_TQPopupMenu)
				//|| (wt == TQT3WT_TQComboBox)
				//|| (wt == TQT3WT_TQSlider)
				//|| (wt == TQT3WT_TQScrollBar)
				//|| (wt == TQT3WT_TQSpinBox)
				//|| (wt == TQT3WT_TQSpinWidget)
				//|| (wt == TQT3WT_TQTitleBar)
				|| (wt == TQT3WT_TQMenuBar)
				|| (wt == TQT3WT_TQToolBox)
				|| (wt == TQT3WT_TQToolButton)) {
				return cacheResult;
			}
		}
	}

	TQTabBar* m_tqt3tabbar_widget = 0;
	TQRadioButton* m_tqt3radiobutton_widget = 0;
	TQCheckBox* m_tqt3checkbox_widget = 0;
	TQPushButton* m_tqt3pushbutton_widget = 0;
	TQProgressBar* m_tqt3progressbar_widget = 0;
	TQPopupMenu* m_tqt3popupmenu_widget = 0;
	TQComboBox* m_tqt3combobox_widget = 0;
	TQSlider* m_tqt3slider_widget = 0;
	TQScrollBar* m_tqt3scrollbar_widget = 0;
#if 0
	TQSpinBox* m_tqt3spinbox_widget = 0;
#endif
	TQSpinWidget* m_tqt3spinwidget_widget = 0;
	TQTitleBar* m_tqt3titlebar_widget = 0;
	TQMenuBar* m_tqt3menubar_widget = 0;
	TQToolBox* m_tqt3toolbox_widget = 0;
	TQToolButton* m_tqt3toolbutton_widget = 0;

	if (cacheResult) {
		// Set pointer
		m_tqt3tabbar_widget = dynamic_cast<TQTabBar*>(cacheResult);
		m_tqt3radiobutton_widget = dynamic_cast<TQRadioButton*>(cacheResult);
		m_tqt3checkbox_widget = dynamic_cast<TQCheckBox*>(cacheResult);
		m_tqt3pushbutton_widget = dynamic_cast<TQPushButton*>(cacheResult);
		m_tqt3progressbar_widget = dynamic_cast<TQProgressBar*>(cacheResult);
		m_tqt3popupmenu_widget = dynamic_cast<TQPopupMenu*>(cacheResult);
		m_tqt3combobox_widget = dynamic_cast<TQComboBox*>(cacheResult);
		m_tqt3slider_widget = dynamic_cast<TQSlider*>(cacheResult);
		m_tqt3scrollbar_widget = dynamic_cast<TQScrollBar*>(cacheResult);
#if 0
		m_tqt3spinbox_widget = dynamic_cast<TQSpinBox*>(cacheResult);
#endif
		m_tqt3spinwidget_widget = dynamic_cast<TQSpinWidget*>(cacheResult);
		m_tqt3titlebar_widget = dynamic_cast<TQTitleBar*>(cacheResult);
		m_tqt3menubar_widget = dynamic_cast<TQMenuBar*>(cacheResult);
		m_tqt3toolbox_widget = dynamic_cast<TQToolBox*>(cacheResult);
		m_tqt3toolbutton_widget = dynamic_cast<TQToolButton*>(cacheResult);
	}

	switch (wt) {
		case TQT3WT_TQProgressBar:
			if (!m_tqt3progressbar_widget) m_tqt3progressbar_widget = new TQProgressBar(m_tqt3parent_widget);
			interfaceWidget = m_tqt3progressbar_widget;
			// Copy over all widget attributes
			qt4progressbar_widget = dynamic_cast<const QProgressBar*>(w);
			if (qt4progressbar_widget) {
				m_tqt3progressbar_widget->setGeometry(0, 0, qt4progressbar_widget->width(), qt4progressbar_widget->height());
				m_tqt3progressbar_widget->setEnabled(qt4progressbar_widget->isEnabled());
				m_tqt3progressbar_widget->setProgress(qt4progressbar_widget->value()-qt4progressbar_widget->minimum(),qt4progressbar_widget->maximum()-qt4progressbar_widget->minimum());
				if (qt4progressbar_widget->orientation() != Qt::Horizontal) {
					// Qt3 cannot draw vertical progress bars
					if (enable_debug_warnings) {
						printf("No rules to draw vertical Qt4 progress bar\n"); fflush(stdout);
					}
					interfaceWidget = 0;
				}
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 progress bar with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQTabBar:
			if (!m_tqt3tabbar_widget) m_tqt3tabbar_widget = new TQTabBar(m_tqt3parent_widget);
			interfaceWidget = m_tqt3tabbar_widget;
			// Copy over all widget attributes
			qt4tabbar_widget = dynamic_cast<const QTabBar*>(w);
			if (qt4tabbar_widget) {
				m_tqt3tabbar_widget->setGeometry(0, 0, qt4tabbar_widget->width(), qt4tabbar_widget->height());
				m_tqt3tabbar_widget->setEnabled(qt4tabbar_widget->isEnabled());
				// Clear out tabbar
				while (m_tqt3tabbar_widget->count() > 0) {
					m_tqt3tabbar_widget->removeTab(m_tqt3tabbar_widget->tabAt(0));
				}
				// Copy over all tabs
				for (i=0;i<qt4tabbar_widget->count();i++) {
					if (qt4tabbar_widget->tabIcon(i).isNull()) {
						TQTab* newTab = new TQTab(convertQt4ToTQt3String(qt4tabbar_widget->tabText(i)));
						m_tqt3tabbar_widget->insertTab(newTab, i);
						newTab->setIdentifier(i);
					}
					else {
						TQTab* newTab = new TQTab(convertQt4ToTQt3IconSet(qt4tabbar_widget->tabIcon(i), m_tqt3IconSize_Small, m_tqt3IconSize_Large, m_internalTQt3PixmapCache), convertQt4ToTQt3String(qt4tabbar_widget->tabText(i)));
						m_tqt3tabbar_widget->insertTab(newTab, i);
						newTab->setIdentifier(i);
					}
				}
				m_tqt3tabbar_widget->setCurrentTab(qt4tabbar_widget->currentIndex());
				switch (qt4tabbar_widget->shape()) {
					case QTabBar::RoundedNorth:
						tqt3tbshape = TQTabBar::RoundedAbove;
						break;
					case QTabBar::RoundedSouth:
						tqt3tbshape = TQTabBar::RoundedBelow;
						break;
					case QTabBar::TriangularNorth:
						tqt3tbshape = TQTabBar::TriangularAbove;
						break;
					case QTabBar::TriangularSouth:
						tqt3tbshape = TQTabBar::TriangularBelow;
						break;
					default:
						// Qt3 cannot draw other tab shapes
						if (enable_debug_warnings) {
							printf("No rules to draw Qt4 tab shape %d\n", qt4tabbar_widget->shape()); fflush(stdout);
						}
						interfaceWidget = 0;
				}
				m_tqt3tabbar_widget->setShape(tqt3tbshape);
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 tabbar with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQRadioButton:
			if (!m_tqt3radiobutton_widget) m_tqt3radiobutton_widget = new TQRadioButton(m_tqt3parent_widget);
			interfaceWidget = m_tqt3radiobutton_widget;
			// Copy over all widget attributes
			qt4radiobutton_widget = dynamic_cast<const QRadioButton*>(w);
			if (qt4radiobutton_widget) {
				m_tqt3radiobutton_widget->setGeometry(0, 0, qt4radiobutton_widget->width(), qt4radiobutton_widget->height());
				m_tqt3radiobutton_widget->setEnabled(qt4radiobutton_widget->isEnabled());
				m_tqt3radiobutton_widget->setText(convertQt4ToTQt3String(qt4radiobutton_widget->text()));
				m_tqt3radiobutton_widget->setDown(qt4radiobutton_widget->isDown());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 radio button with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQCheckBox:
			if (!m_tqt3checkbox_widget) m_tqt3checkbox_widget = new TQCheckBox(m_tqt3parent_widget);
			interfaceWidget = m_tqt3checkbox_widget;
			// Copy over all widget attributes
			qt4checkbox_widget = dynamic_cast<const QCheckBox*>(w);
			if (qt4checkbox_widget) {
				m_tqt3checkbox_widget->setGeometry(0, 0, qt4checkbox_widget->width(), qt4checkbox_widget->height());
				m_tqt3checkbox_widget->setEnabled(qt4checkbox_widget->isEnabled());
				m_tqt3checkbox_widget->setText(convertQt4ToTQt3String(qt4checkbox_widget->text()));
				m_tqt3checkbox_widget->setDown(qt4checkbox_widget->isDown());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 checkbox with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQPushButton:
			if (!m_tqt3pushbutton_widget) m_tqt3pushbutton_widget = new TQPushButton(m_tqt3parent_widget);
			interfaceWidget = m_tqt3pushbutton_widget;
			// Copy over all widget attributes
			qt4pushbutton_widget = dynamic_cast<const QPushButton*>(w);
			if (qt4pushbutton_widget) {
				m_tqt3pushbutton_widget->setGeometry(0, 0, qt4pushbutton_widget->width(), qt4pushbutton_widget->height());
				m_tqt3pushbutton_widget->setEnabled(qt4pushbutton_widget->isEnabled());
				m_tqt3pushbutton_widget->setText(convertQt4ToTQt3String(qt4pushbutton_widget->text()));
				m_tqt3pushbutton_widget->setDown(qt4pushbutton_widget->isDown());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 pushbutton with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQComboBox:
			if (!m_tqt3combobox_widget) m_tqt3combobox_widget = new TQComboBox(m_tqt3parent_widget);
			interfaceWidget = m_tqt3combobox_widget;
			// Copy over all widget attributes
			qt4combobox_widget = dynamic_cast<const QComboBox*>(w);
			if (qt4combobox_widget) {
				m_tqt3combobox_widget->setGeometry(0, 0, qt4combobox_widget->width(), qt4combobox_widget->height());
				m_tqt3combobox_widget->setEnabled(qt4combobox_widget->isEnabled());
				// Clear out all combobox items
				m_tqt3combobox_widget->clear();
	
				for (i=0;i<qt4combobox_widget->count();i++) {
					if (qt4combobox_widget->itemIcon(i).isNull()) {
						m_tqt3combobox_widget->insertItem(convertQt4ToTQt3String(qt4combobox_widget->itemText(i)), i);
					}
					else {
						m_tqt3combobox_widget->insertItem(convertQt4IconToTQt3Pixmap(qt4combobox_widget->itemIcon(i), m_tqt3IconSize_Small, m_internalTQt3PixmapCache), convertQt4ToTQt3String(qt4combobox_widget->itemText(i)), i);
					}
				}
				m_tqt3combobox_widget->setEditable(qt4combobox_widget->isEditable());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 combobox with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQPopupMenu:
			if (!m_tqt3popupmenu_widget) m_tqt3popupmenu_widget = new TQPopupMenu(m_tqt3parent_widget);
			interfaceWidget = m_tqt3popupmenu_widget;
			// Copy over all widget attributes
			qt4menu_widget = dynamic_cast<const QMenu*>(w);
			if (qt4menu_widget) {
				m_tqt3popupmenu_widget->setGeometry(0, 0, qt4menu_widget->width(), qt4menu_widget->height());
				m_tqt3popupmenu_widget->setEnabled(qt4menu_widget->isEnabled());
				// Clear out menu
				m_tqt3popupmenu_widget->clear();
				m_tqt3popupmenu_widget->setCheckable(false);
				// Copy over all menu items
				qt4menuactions = qt4menu_widget->actions();
				currentAction = 0;
				for (i=0; i<qt4menuactions.size();++i) {
					currentAction = qt4menuactions.at(i);
					if (currentAction) {
						if (currentAction->isSeparator()) {
							m_tqt3popupmenu_widget->insertSeparator(i);
						}
						else {
							if (currentAction->icon().isNull()) {
								m_tqt3popupmenu_widget->insertItem(convertQt4ToTQt3String(currentAction->text()), i, i);
							}
							else {
								m_tqt3popupmenu_widget->insertItem(convertQt4ToTQt3IconSet(currentAction->icon(), m_tqt3IconSize_Small, m_tqt3IconSize_Large, m_internalTQt3PixmapCache), convertQt4ToTQt3String(currentAction->text()), i, i);
							}
							// FIXME
							// Handle pixmaps, etc.
						}
						m_tqt3popupmenu_widget->setItemEnabled(i, currentAction->isEnabled());
						m_tqt3popupmenu_widget->setItemChecked(i, currentAction->isChecked());
						m_tqt3popupmenu_widget->setItemVisible(i, currentAction->isVisible());
	
						// FIXME
						// It seems that all menus under TQt3 are checkable
						// VERIFY THIS
						m_tqt3popupmenu_widget->setCheckable(true);
// 						if (currentAction->isCheckable()) {
// 							m_tqt3popupmenu_widget->setCheckable(true);
// 						}
					}
				}
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 popup menu with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQMenuBar:
			if (!m_tqt3menubar_widget) m_tqt3menubar_widget = new TQMenuBar(m_tqt3parent_widget);
			interfaceWidget = m_tqt3menubar_widget;
			// Copy over all widget attributes
			qt4menubar_widget = dynamic_cast<const QMenuBar*>(w);
			if (qt4menubar_widget) {
				m_tqt3menubar_widget->setGeometry(0, 0, qt4menubar_widget->width(), qt4menubar_widget->height());
				m_tqt3menubar_widget->setEnabled(qt4menubar_widget->isEnabled());
				// Clear out menu
				m_tqt3menubar_widget->clear();
				// Copy over all menu items
				qt4menuactions = qt4menubar_widget->actions();
				currentAction = 0;
				for (i=0; i<qt4menuactions.size();++i) {
					currentAction = qt4menuactions.at(i);
					if (currentAction) {
						if (currentAction->isSeparator()) {
							m_tqt3menubar_widget->insertSeparator(i);
						}
						else {
							if (currentAction->icon().isNull()) {
								m_tqt3menubar_widget->insertItem(convertQt4ToTQt3String(currentAction->text()), i, i);
							}
							else {
								m_tqt3menubar_widget->insertItem(convertQt4ToTQt3IconSet(currentAction->icon(), m_tqt3IconSize_Small, m_tqt3IconSize_Large, m_internalTQt3PixmapCache), convertQt4ToTQt3String(currentAction->text()), i, i);
							}
							// FIXME
							// Handle pixmaps, etc.
						}
						m_tqt3menubar_widget->setItemEnabled(i, currentAction->isEnabled());
						m_tqt3menubar_widget->setItemChecked(i, currentAction->isChecked());
						m_tqt3menubar_widget->setItemVisible(i, currentAction->isVisible());
					}
				}
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 menu bar with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQSlider:
			if (!m_tqt3slider_widget) m_tqt3slider_widget = new TQSlider(m_tqt3parent_widget);
			interfaceWidget = m_tqt3slider_widget;
			// Copy over all widget attributes
			qt4slider_widget = dynamic_cast<const QSlider*>(w);
			if (qt4slider_widget) {
				m_tqt3slider_widget->setGeometry(0, 0, qt4slider_widget->width(), qt4slider_widget->height());
				m_tqt3slider_widget->setEnabled(qt4slider_widget->isEnabled());
				m_tqt3slider_widget->setOrientation(convertQt4ToTQt3Orientation(qt4slider_widget->orientation()));
				m_tqt3slider_widget->setTracking(qt4slider_widget->hasTracking());
// 				m_tqt3slider_widget->setPalette();	// FIXME
				m_tqt3slider_widget->setTickmarks(convertQt4ToTQt3TickSetting(qt4slider_widget->tickPosition()));
				m_tqt3slider_widget->setTickInterval(qt4slider_widget->tickInterval());
				m_tqt3slider_widget->setMinValue(qt4slider_widget->minimum());
				m_tqt3slider_widget->setMaxValue(qt4slider_widget->maximum());
				m_tqt3slider_widget->setLineStep(qt4slider_widget->singleStep());
				m_tqt3slider_widget->setPageStep(qt4slider_widget->pageStep());
				m_tqt3slider_widget->setValue(qt4slider_widget->value());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 slider with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQScrollBar:
			if (!m_tqt3scrollbar_widget) m_tqt3scrollbar_widget = new TQScrollBar(m_tqt3parent_widget);
			interfaceWidget = m_tqt3scrollbar_widget;
			// Copy over all widget attributes
			qt4scrollbar_widget = dynamic_cast<const QScrollBar*>(w);
			if (qt4scrollbar_widget) {
				m_tqt3scrollbar_widget->setGeometry(0, 0, qt4scrollbar_widget->width(), qt4scrollbar_widget->height());
				m_tqt3scrollbar_widget->setEnabled(qt4scrollbar_widget->isEnabled());
				m_tqt3scrollbar_widget->setOrientation(convertQt4ToTQt3Orientation(qt4scrollbar_widget->orientation()));
				m_tqt3scrollbar_widget->setTracking(qt4scrollbar_widget->hasTracking());
				m_tqt3scrollbar_widget->setMinValue(qt4scrollbar_widget->minimum());
				m_tqt3scrollbar_widget->setMaxValue(qt4scrollbar_widget->maximum());
				m_tqt3scrollbar_widget->setLineStep(qt4scrollbar_widget->singleStep());
				m_tqt3scrollbar_widget->setPageStep(qt4scrollbar_widget->pageStep());
				m_tqt3scrollbar_widget->setValue(qt4scrollbar_widget->value());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 scrollbar with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQSpinBox:
#if 0
			if (!m_tqt3spinbox_widget) m_tqt3spinbox_widget = new TQSpinBox(m_tqt3parent_widget);
			interfaceWidget = m_tqt3spinbox_widget;
			// Copy over all widget attributes
			qt4spinbox_widget = dynamic_cast<const QAbstractSpinBox*>(w);
			if (qt4spinbox_widget) {
				m_tqt3spinbox_widget->setGeometry(0, 0, qt4spinbox_widget->width(), qt4spinbox_widget->height());
				m_tqt3spinbox_widget->setEnabled(qt4spinbox_widget->isEnabled());
				m_tqt3spinbox_widget->setMinValue(qt4spinbox_widget->minimum());
				m_tqt3spinbox_widget->setMaxValue(qt4spinbox_widget->maximum());
				m_tqt3spinbox_widget->setLineStep(qt4spinbox_widget->singleStep());
				m_tqt3spinbox_widget->setValue(qt4spinbox_widget->value());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 spinbox with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
#endif
			break;
		case TQT3WT_TQSpinWidget:
			if (!m_tqt3spinwidget_widget) m_tqt3spinwidget_widget = new TQSpinWidget(m_tqt3parent_widget);
			interfaceWidget = m_tqt3spinwidget_widget;
			// Copy over all widget attributes
			qt4spinbox_widget = dynamic_cast<const QAbstractSpinBox*>(w);
			if (qt4spinbox_widget) {
				m_tqt3spinwidget_widget->setGeometry(0, 0, qt4spinbox_widget->width(), qt4spinbox_widget->height());
				m_tqt3spinwidget_widget->setEnabled(qt4spinbox_widget->isEnabled());
				m_tqt3spinwidget_widget->setUpEnabled(qt4spinbox_widget->stepEnabled() & QSpinBox::StepUpEnabled);
				m_tqt3spinwidget_widget->setDownEnabled(qt4spinbox_widget->stepEnabled() & QSpinBox::StepDownEnabled);
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 spinbox with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQTitleBar:
			if (!m_tqt3titlebar_widget) m_tqt3titlebar_widget = new TQTitleBar(m_tqt3window_widget, m_tqt3parent_widget);
			interfaceWidget = m_tqt3titlebar_widget;
			qt4titlebar_options = static_cast<const QStyleOptionTitleBar*>(qt4styleoptions);
			// Construct an internal TQTitleBar widget from the options and widget provided by Qt4
			m_tqt3titlebar_widget->setGeometry(qt4styleoptions->rect.x(), qt4styleoptions->rect.y(), qt4styleoptions->rect.width(), qt4styleoptions->rect.height());
			m_tqt3titlebar_widget->setCaption(convertQt4ToTQt3String(qt4titlebar_options->text));
			m_tqt3titlebar_widget->setActive(qt4titlebar_options->titleBarState & Qt::WindowActive);

			// HACK
			// TQt3 does not know how to handle transparent icons in title bars,
			// so assume that the titlebar is uniform in color and draw the icon over the background color
			if (m_tqt3titlebar_widget->isActive()) {
				bgcolor = convertQt4ToTQt3Palette(qt4styleoptions->palette).active().highlight();
			}
			else {
				bgcolor = convertQt4ToTQt3Palette(qt4styleoptions->palette).inactive().highlight();
			}
			m_tqt3titlebar_widget->setIcon(convertQt4IconToTQt3Pixmap(qt4titlebar_options->icon, m_tqt3IconSize_Small, m_internalTQt3PixmapCache, false, &bgcolor));
			break;
		case TQT3WT_TQToolBox:
			if (!m_tqt3toolbox_widget) m_tqt3toolbox_widget = new TQToolBox(m_tqt3parent_widget);
			interfaceWidget = m_tqt3toolbox_widget;
			// Copy over all widget attributes
			qt4toolbox_widget = dynamic_cast<const QToolBox*>(w);
			if (qt4toolbox_widget) {
				m_tqt3toolbox_widget->setGeometry(0, 0, qt4toolbox_widget->width(), qt4toolbox_widget->height());
				m_tqt3toolbox_widget->setEnabled(qt4toolbox_widget->isEnabled());
				// Remove all tabs
				for (i=0;i<m_tqt3toolbox_widget->count();i++) {
					TQWidget* item = m_tqt3toolbox_widget->item(i);
					m_tqt3toolbox_widget->removeItem(item);
					if (item) {
						delete item;
					}
				}
				// Copy all tabs
				for (i=0;i<qt4toolbox_widget->count();i++) {
					m_tqt3toolbox_widget->insertItem(i, new TQWidget(m_tqt3parent_widget), convertQt4ToTQt3String(qt4toolbox_widget->itemText(i)));
				}
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 toolbox with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_TQToolButton:
			// FIXME
			if (!m_tqt3toolbutton_widget) m_tqt3toolbutton_widget = new TQToolButton(m_tqt3parent_widget);
			interfaceWidget = m_tqt3toolbutton_widget;
			// Copy over all widget attributes
			qt4toolbutton_widget = dynamic_cast<const QToolButton*>(w);
			if (qt4toolbutton_widget) {
				m_tqt3toolbutton_widget->setGeometry(0, 0, qt4toolbutton_widget->width(), qt4toolbutton_widget->height());
				m_tqt3toolbutton_widget->setEnabled(qt4toolbutton_widget->isEnabled());
				m_tqt3toolbutton_widget->setIconSet(convertQt4ToTQt3IconSet(qt4toolbutton_widget->icon(), m_tqt3IconSize_Small, m_tqt3IconSize_Large, m_internalTQt3PixmapCache));
// 				m_tqt3toolbutton_widget->setUsesBigPixmap(qt4toolbutton_widget->);
				m_tqt3toolbutton_widget->setUsesTextLabel(((qt4toolbutton_widget->toolButtonStyle() != Qt::ToolButtonIconOnly) && (qt4toolbutton_widget->toolButtonStyle() != Qt::ToolButtonFollowStyle)));
				m_tqt3toolbutton_widget->setTextLabel(convertQt4ToTQt3String(qt4toolbutton_widget->text()));
				m_tqt3toolbutton_widget->setToggleButton(qt4toolbutton_widget->isCheckable());
				m_tqt3toolbutton_widget->setOn(qt4toolbutton_widget->isChecked());
				if (qt4toolbutton_widget->toolButtonStyle() == Qt::ToolButtonTextBesideIcon) {
					m_tqt3toolbutton_widget->setTextPosition(TQToolButton::BesideIcon);
				}
				m_tqt3toolbutton_widget->setAutoRaise(qt4toolbutton_widget->autoRaise());
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 toolbutton with no Qt4 object available\n"); fflush(stdout);
				}
				interfaceWidget = 0;
			}
			break;
		case TQT3WT_NONE:
			break;
	}

	if ((qt4objectptr) && (!cacheResult) && (interfaceWidget)) {
		connect(qt4objectptr, SIGNAL(destroyed(QObject*)), this, SLOT(handleQt4ObjectDestroyed(QObject*)));
		m_internalTQt3WidgetCache->insert((long)qt4objectptr, interfaceWidget);
	}

#ifdef DEBUG_SPEW
	if (enable_debug_warnings) {
		printf("Widget cache: %d items now present in cache\n", m_internalTQt3WidgetCache->count());
	}
#endif // DEBUG_SPEW
	return interfaceWidget;
}

void Qt4TDEStyle::handleQt4ObjectDestroyed(QObject* obj) {
	m_internalTQt3WidgetCache->remove((long)obj);
}

QRect Qt4TDEStyle::subElementRect(SubElement element, const QStyleOption *opt, const QWidget *w) const
{
	bool can_override = true;
	TQStyle::SubRect tqtSR;

	TQWidget* interfaceWidget = 0;
	QRect retRect;

	switch (element) {
		case SE_ComboBoxFocusRect:
			tqtSR = TQStyle::SR_ComboBoxFocusRect;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQComboBox, w);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		default:
			if (enable_debug_warnings) {
				printf("No rules to obtain Qt4 subelement rect %d\n", element); fflush(stdout);
			}
			can_override = false;
	}

	if (can_override) {
		// Instruct TQt3 to obtain the subelement rect information
		retRect = convertTQt3ToQt4Rect(tqApp->style().subRect(tqtSR, interfaceWidget));

		if (enable_debug_warnings) {
#ifdef DEBUG_SPEW
			printf("Used Qt3 subelement rect %d to handle Qt4 subelement rect %d\n", tqtSR, element); fflush(stdout);
#endif
		}
	}
	else {
		// Tell Qt4 to obtain the subelement rect information
		retRect = BASE_QT4_STYLE_CLASS::subElementRect(element, opt, w);
	}

	return retRect;
}

QRect Qt4TDEStyle::subControlRect(ComplexControl control, const QStyleOptionComplex* opt, SubControl subControl, const QWidget* w) const
{
	bool can_override = true;
	TQStyle::ComplexControl tqtCC;
	TQStyle::SubControl tqtSC;

	TQWidget* interfaceWidget = 0;
	TQStyleOption tqt3opt(TQStyleOption::Default);
	QRect retRect;

	switch (control) {
		case CC_SpinBox: {
			tqtCC = TQStyle::CC_SpinWidget;
			switch (subControl) {
				case SC_SpinBoxUp:
					tqtSC = TQStyle::SC_SpinWidgetUp;
					interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSpinWidget, w, opt);
					if (interfaceWidget == 0) {
						can_override = false;
					}
					break;
				case SC_SpinBoxDown:
					tqtSC = TQStyle::SC_SpinWidgetDown;
					interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSpinWidget, w, opt);
					if (interfaceWidget == 0) {
						can_override = false;
					}
					break;
				case SC_SpinBoxEditField:
					tqtSC = TQStyle::SC_SpinWidgetEditField;
					interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSpinWidget, w, opt);
					if (interfaceWidget == 0) {
						can_override = false;
					}
					break;
				case SC_SpinBoxFrame:
					tqtSC = TQStyle::SC_SpinWidgetFrame;
					interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSpinWidget, w, opt);
					if (interfaceWidget == 0) {
						can_override = false;
					}
					break;
				default:
					if (enable_debug_warnings) {
						printf("No rules to obtain Qt4 subcontrol rect %d for control %d\n", subControl, control); fflush(stdout);
					}
					can_override = false;
			}
			break;
		}
		default:
			if (enable_debug_warnings) {
				printf("No rules to obtain Qt4 subcontrol rect %d for control %d\n", subControl, control); fflush(stdout);
			}
			can_override = false;
	}

	if (can_override) {
		// Instruct TQt3 to obtain the subelement rect information
		retRect = convertTQt3ToQt4Rect(tqApp->style().querySubControlMetrics(tqtCC, interfaceWidget, tqtSC, tqt3opt));

		if ((tqtCC == TQStyle::CC_SpinWidget) && (tqtSC == TQStyle::SC_SpinWidgetEditField)) {
			// HACK
			// For an unknown reason, Qt4 instantly resizes SpinBoxes to a very small height if TQt3 returns
			// an editor height hint that is different (larger?) than the Qt4 editor height hint!
			// Work around this problem here...
			QRect qt4Rect = BASE_QT4_STYLE_CLASS::subControlRect(control, opt, subControl, w);
			retRect.setHeight(qt4Rect.height());
		}

		if (enable_debug_warnings) {
#ifdef DEBUG_SPEW
			printf("Used Qt3 subcontrol rect %d for control %d to handle Qt4 subcontrol rect %d for control %d\n", tqtSC, tqtCC, subControl, control); fflush(stdout);
#endif
		}
	}
	else {
		// Tell Qt4 to obtain the subelement rect information
		retRect = BASE_QT4_STYLE_CLASS::subControlRect(control, opt, subControl, w);
	}

	return retRect;
}

void Qt4TDEStyle::drawComplexControl(ComplexControl control, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
{
	TQStyle::SFlags sflags = 0;

	bool can_override = true;
	bool do_not_draw = false;
	TQStyle::ComplexControl tqtCC;

	TQStyle::SCFlags subControl = TQStyle::SC_All;
	TQStyle::SCFlags subControlActive = TQStyle::SC_None;

	TQWidget* interfaceWidget = 0;
	TQStyleOption tqt3opt(TQStyleOption::Default);

	TQRect tqt3rect(opt->rect.x(), opt->rect.y(), opt->rect.width(), opt->rect.height());

	// Determine the correct color group
	sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_NONE);
	TQPalette tqt3palette = convertQt4ToTQt3Palette(opt->palette);
	TQColorGroup tqt3colorgroup;
	if (sflags & TQStyle::Style_Enabled) {
		if (sflags & TQStyle::Style_Active) {
			tqt3colorgroup = tqt3palette.active();
		}
		else {
			tqt3colorgroup = tqt3palette.inactive();
		}
	}
	else {
		tqt3colorgroup = tqt3palette.disabled();
	}

	const QStyleOptionTitleBar* tbopt;
	const QStyleOptionSpinBox* sbopt;
	bool drawCloseButton;
	bool drawMaxButton;
	bool drawMinButton;
	bool drawNormalButton;
	bool drawShadeButton;
	bool drawUnshadeButton;
	bool drawSysMenuButton;

	switch (control) {
		case CC_ComboBox:
			tqtCC = TQStyle::CC_ComboBox;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQComboBox, w);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case CC_Slider:
			tqtCC = TQStyle::CC_Slider;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSlider, w);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case CC_ScrollBar:
			tqtCC = TQStyle::CC_ScrollBar;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQScrollBar, w);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case CC_SpinBox:
			tqtCC = TQStyle::CC_SpinWidget;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQSpinWidget, w, opt);
			if (interfaceWidget == 0) {
				can_override = false;
			}

			// Draw the correct subcontrol(s)
			sbopt = static_cast<const QStyleOptionSpinBox*>(opt);
			subControl = 0;
			if ((sbopt->subControls & QStyle::SC_SpinBoxUp) || (sbopt->subControls & QStyle::SC_SpinBoxDown)) {
				subControl = subControl | TQStyle::SC_SpinWidgetButtonField;
			}
			if (sbopt->subControls & QStyle::SC_SpinBoxUp) {
				subControl = subControl | TQStyle::SC_SpinWidgetUp;
			}
			if (sbopt->subControls & QStyle::SC_SpinBoxDown) {
				subControl = subControl | TQStyle::SC_SpinWidgetDown;
			}
			if (sbopt->subControls & QStyle::SC_SpinBoxEditField) {
				subControl = subControl | TQStyle::SC_SpinWidgetEditField;
			}
			if (sbopt->subControls & QStyle::SC_SpinBoxFrame) {
				subControl = subControl | TQStyle::SC_SpinWidgetFrame;
			}

			subControlActive = 0;
			if ((sbopt->activeSubControls & QStyle::SC_SpinBoxUp) && (sbopt->state & State_Sunken)) {
				subControlActive = subControlActive | TQStyle::SC_SpinWidgetUp;
			}
			if ((sbopt->activeSubControls & QStyle::SC_SpinBoxDown) && (sbopt->state & State_Sunken)) {
				subControlActive = subControlActive | TQStyle::SC_SpinWidgetDown;
			}

			break;
		case CC_TitleBar:
			tqtCC = TQStyle::CC_TitleBar;
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTitleBar, w, opt);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				// Select subcontrol(s) to be drawn
				// Qt4 made this hard again (surprise surprise)
				tbopt = static_cast<const QStyleOptionTitleBar*>(opt);

				// This logic is taken from Qt4 (qcommonstyle.cpp)
				// It will need to be kept in sync with whatever Nokia does
				drawCloseButton = (tbopt->subControls & SC_TitleBarCloseButton && tbopt->titleBarFlags & Qt::WindowSystemMenuHint);
				drawMaxButton = (tbopt->subControls & SC_TitleBarMaxButton && tbopt->titleBarFlags & Qt::WindowMaximizeButtonHint && !(tbopt->titleBarState & Qt::WindowMaximized));
				drawMinButton = (tbopt->subControls & SC_TitleBarMinButton && tbopt->titleBarFlags & Qt::WindowMinimizeButtonHint && !(tbopt->titleBarState & Qt::WindowMinimized));
				drawNormalButton = (tbopt->subControls & SC_TitleBarNormalButton) && (((tbopt->titleBarFlags & Qt::WindowMinimizeButtonHint) && (tbopt->titleBarState & Qt::WindowMinimized)) || ((tbopt->titleBarFlags & Qt::WindowMaximizeButtonHint) && (tbopt->titleBarState & Qt::WindowMaximized)));
				drawShadeButton = (tbopt->subControls & SC_TitleBarShadeButton && tbopt->titleBarFlags & Qt::WindowShadeButtonHint && !(tbopt->titleBarState & Qt::WindowMinimized));
				drawUnshadeButton = (tbopt->subControls & SC_TitleBarUnshadeButton && tbopt->titleBarFlags & Qt::WindowShadeButtonHint && tbopt->titleBarState & Qt::WindowMinimized);
				drawSysMenuButton = (tbopt->subControls & SC_TitleBarSysMenu && tbopt->titleBarFlags & Qt::WindowSystemMenuHint);
				// End logic taken from Qt4

				// FIXME
				// TQt3 has no idea how to draw the restore button on a maximized window!!!
				// This needs to be fixed in qcommonstyle.cpp drawComplexControl, case CC_TitleBar
				// Once this is fixed in TQt3, the logic below needs to be updated

				subControl = 0;
				if (drawSysMenuButton) {
					subControl = subControl | TQStyle::SC_TitleBarSysMenu;
				}
				if (drawMinButton) {
					subControl = subControl | TQStyle::SC_TitleBarMinButton;
				}
				if (drawMaxButton) {
					subControl = subControl | TQStyle::SC_TitleBarMaxButton;
				}
				if (drawCloseButton) {
					subControl = subControl | TQStyle::SC_TitleBarCloseButton;
				}
				if (tbopt->subControls & SC_TitleBarLabel) {
					subControl = subControl | TQStyle::SC_TitleBarLabel;
				}
				if (drawNormalButton && !(tbopt->titleBarState & Qt::WindowMaximized)) {
					subControl = subControl | TQStyle::SC_TitleBarNormalButton;
				}
				if (drawShadeButton) {
					subControl = subControl | TQStyle::SC_TitleBarShadeButton;
				}
				if (drawUnshadeButton) {
					subControl = subControl | TQStyle::SC_TitleBarUnshadeButton;
				}
// 				if (tbopt->subControls & SC_TitleBarContextHelpButton) {
// 					subControl = subControl | TQStyle::SC_TitleBarContextHelpButton;
// 				}

				subControlActive = 0;
				if (tbopt->activeSubControls & SC_TitleBarSysMenu) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarSysMenu;
				}
				if (tbopt->activeSubControls & SC_TitleBarMinButton) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarMinButton;
				}
				if (tbopt->activeSubControls & SC_TitleBarMaxButton) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarMaxButton;
				}
				if (tbopt->activeSubControls & SC_TitleBarCloseButton) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarCloseButton;
				}
				if (tbopt->activeSubControls & SC_TitleBarLabel) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarLabel;
				}
				if (tbopt->activeSubControls & SC_TitleBarNormalButton) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarNormalButton;
				}
				if (tbopt->activeSubControls & SC_TitleBarShadeButton) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarShadeButton;
				}
				if (tbopt->activeSubControls & SC_TitleBarUnshadeButton) {
					subControlActive = subControlActive | TQStyle::SC_TitleBarUnshadeButton;
				}
// 				if (tbopt->activeSubControls & SC_TitleBarContextHelpButton) {
// 					subControlActive = subControlActive | TQStyle::SC_TitleBarContextHelpButton;
// 				}

				// HACK
				if (static_cast<TQTitleBar*>(interfaceWidget)->isActive()) {
					interfaceWidget->setPalette(TQPalette(tqt3palette.active(), tqt3palette.active(), tqt3palette.active()));
				}
				else {
					interfaceWidget->setPalette(TQPalette(tqt3palette.inactive(), tqt3palette.inactive(), tqt3palette.inactive()));
				}
			}
			break;
		case CC_ToolButton:
			// Qt4 expects this to also draw CE_ToolButtonLabel
			// See below for drawControl() call
			tqtCC = TQStyle::CC_ToolButton;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQToolButton);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQToolButton, w);
			if (interfaceWidget == 0) {
				can_override = false;
			}

			// Draw the correct subcontrol(s)
			sbopt = static_cast<const QStyleOptionSpinBox*>(opt);
			subControl = 0;
			if (sbopt->subControls & QStyle::SC_ToolButton) {
				subControl = subControl | TQStyle::SC_ToolButton;
			}
			if (sbopt->subControls & QStyle::SC_ToolButtonMenu) {
				subControl = subControl | TQStyle::SC_ToolButtonMenu;
			}
			break;
		case CC_GroupBox:
			NO_QT3_EQUIVALENT
			break;
		default:
			if (enable_debug_warnings) {
				printf("No rules to draw Qt4 complex control %d\n", control); fflush(stdout);
			}
			can_override = false;
	}

	if (can_override) {
		// Construct a Qt3 paint device on the Qt4 painter
		TDEQt4PaintDevice qt4pd(p);

		TQPainter tqtPainter(&qt4pd);

		if (tqtCC == TQStyle::CC_ComboBox) {
			// TQt3 expects the Style_MouseOver flag to be cleared if the certain widgets have been disabled
			if (interfaceWidget) {
				if (interfaceWidget->isEnabled() == false) {
					sflags = sflags & (~TQStyle::Style_MouseOver);
				}
			}
		}

		if (tqtCC == TQStyle::CC_TitleBar) {
			// TQt3 is expecting to see a rect() from the titlebar that excludes the window frame,
			// while Qt4 provides the entire rectangle (including the frame) via the widget/QStyleOptionTitleBar
			// This is due to the fact that under TQt3 the titlebar is a correctly positioned widget,
			// whereas under Qt4 the titlebar is part of the base widget itself.
			// Compensate...
			if (interfaceWidget) {
				TQRect tbg = interfaceWidget->geometry();
				tqtPainter.translate(tbg.x(), tbg.y());
			}
		}

		if (tqtCC == TQStyle::CC_SpinWidget) {
			// Qt4 expects both the lineedit and the spinbox outside frame to be drawn
			// Draw the outside frame before the spinbox buttons are drawn
			tqApp->style().drawPrimitive(TQStyle::PE_PanelLineEdit, &tqtPainter, tqt3rect, tqt3colorgroup, sflags, tqt3opt);
		}

		if (do_not_draw == false) {
			// Instruct TQt3 to draw the complex control
			tqApp->style().drawComplexControl(tqtCC, &tqtPainter, interfaceWidget, tqt3rect, tqt3colorgroup, sflags, subControl, subControlActive, tqt3opt);
		}

		if (tqtCC == TQStyle::CC_SpinWidget) {
			// Paint the spinbox's editor widget over the outside frame (outside the spinbutton area)
			const QSpinBox* sbWidget = dynamic_cast<const QSpinBox*>(w);
			if (sbWidget) {
				QLineEdit* sbLineEdit = sbWidget->lineEdit();
				QRect sbleRect = sbLineEdit->geometry();
				tqtPainter.setClipRect(tqt3rect.x(),tqt3rect.y(),sbleRect.x()+sbleRect.width(),tqt3rect.height());
				p->fillRect(sbleRect,convertTQt3ToQt4Color(tqt3colorgroup.base()));
			}
			else {
				if (enable_debug_warnings) {
					printf("Unable to draw Qt4 spinbox with no Qt4 object available\n"); fflush(stdout);
				}
			}

			// Now draw the outside frame again, but clipped to the editor widget side of the spinwidget this time
			// This fixes drawing glitches inside of the editor widget while leaving the spinbutton area untouched
			tqApp->style().drawPrimitive(TQStyle::PE_PanelLineEdit, &tqtPainter, tqt3rect, tqt3colorgroup, sflags, tqt3opt);
		}


		tqtPainter.end();

		// Qt4 still needs to draw the button contents over the TQt3 frame and panel
		if (tqtCC == TQStyle::CC_ToolButton) {
			drawControl(QStyle::CE_ToolButtonLabel, opt, p, w);
		}

		if (enable_debug_warnings) {
#ifdef DEBUG_SPEW
			printf("Used Qt3 complex control %d to draw Qt4 complex control %d\n", tqtCC, control); fflush(stdout);
#endif
		}
	}
	else {
		if (do_not_draw == false) {
			// Tell Qt4 to draw it
			BASE_QT4_STYLE_CLASS::drawComplexControl(control, opt, p, w);
		}
	}
}

void Qt4TDEStyle::drawControl(ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
{
	int i;
	TQStyle::SFlags sflags = 0;

	bool can_override = true;
	bool do_not_draw = false;
	TQStyle::ControlElement tqtCE;

	bool draw_second_element = false;
	TQStyle::ControlElement tqtCE_element2;

	bool draw_third_element = false;
	TQStyle::ControlElement tqtCE_element3;

	TQWidget* interfaceWidget = 0;
	TQStyleOption tqt3opt(TQStyleOption::Default);
	TQStyleOption tqt3opt_element2(TQStyleOption::Default);
	TQStyleOption tqt3opt_element3(TQStyleOption::Default);

	TQTab* drawingTab = 0;
	int estimated_tab_index;

	TQMenuItem* drawingItem = 0;
	QAction* drawingAction = 0;
	QList<QAction*> qt4menuactions;
	int tqt3tabwidth = 0;
	int tqt3iconwidth = 0;

	TQRect tqt3elementrect(opt->rect.x(), opt->rect.y(), opt->rect.width(), opt->rect.height());
	TQRect tqt3element2rect = tqt3elementrect;
	TQRect tqt3element3rect = tqt3elementrect;

	// Determine the correct color group
	sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_NONE);
	TQPalette tqt3palette = convertQt4ToTQt3Palette(opt->palette);
	TQColorGroup tqt3colorgroup;
	if (sflags & TQStyle::Style_Enabled) {
		if (sflags & TQStyle::Style_Active) {
			tqt3colorgroup = tqt3palette.active();
		}
		else {
			tqt3colorgroup = tqt3palette.inactive();
		}
	}
	else {
		tqt3colorgroup = tqt3palette.disabled();
	}

	switch (element) {
		case QStyle::CE_ProgressBar:
			// Unlike Qt3, QStyle::CE_ProgressBar draws the bar, the groove, and the label
			tqtCE = TQStyle::CE_ProgressBarContents;
			draw_second_element = true;
			tqtCE_element2 = TQStyle::CE_ProgressBarGroove;
			draw_third_element = true;
			tqtCE_element3 = TQStyle::CE_ProgressBarLabel;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQProgressBar);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQProgressBar, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case QStyle::CE_ProgressBarContents:
			tqtCE = TQStyle::CE_ProgressBarContents;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQProgressBar);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQProgressBar, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case QStyle::CE_TabBarTab:
			// Unlike Qt3, QStyle::CE_TabBarTab draws both the tab and the label
			tqtCE = TQStyle::CE_TabBarTab;
			draw_second_element = true;
			tqtCE_element2 = TQStyle::CE_TabBarLabel;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQTabBar);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQTabBar, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				// Convert the QStyleOption to the proper TQStyleOption
				// In other words, figure out which TQt3 tab is currently being drawn
				// Qt4 makes this really, really hard...
				// I have to guess based on the Qt4 position of the tab in the tab bar, which may or may not work 100% in all cases
				drawingTab = 0;
				estimated_tab_index = dynamic_cast<const QTabBar*>(w)->tabAt(QPoint(opt->rect.x(), opt->rect.y()));
				QRect estimated_tab_rect = dynamic_cast<const QTabBar*>(w)->tabRect(estimated_tab_index);
				TQTabBar* tabBarWidget = dynamic_cast<TQTabBar*>(interfaceWidget);
				drawingTab = tabBarWidget->tabAt(estimated_tab_index);

				if (estimated_tab_rect.contains(w->mapFromGlobal(QCursor::pos()))) {
					sflags |= TQStyle::Style_MouseOver;
				}

				if (drawingTab) {
					tqt3opt = TQStyleOption(drawingTab, (sflags & TQStyle::Style_MouseOver)?drawingTab:NULL);
					tqt3opt_element2 = TQStyleOption(drawingTab);
				}

				// HACK
				// Qt4 is BUSTED YET AGAIN
				// Grrrrr....
				// The PM_TabBarTabOverlap enum is present, BUT IS NOT IMPLEMENTED, in Qt4 (!??!?)
				// Many TDE styles use overlapping tabs, and expect to draw outside their horizontal boundaries by PM_TabBarTabOverlap pixels
				// At the very least we need to expand the drawing rect by that amount, even if the drawing gets clipped, otherwise
				// those styles will show badly broken tabs with missing chunks and added lines.
				tqt3tabwidth = tqApp->style().pixelMetric(TQStyle::PM_TabBarTabOverlap, interfaceWidget);
				if (tqt3tabwidth > 0) {
					tqt3elementrect = TQRect(tqt3elementrect.x()-tqt3tabwidth, tqt3elementrect.y(), tqt3elementrect.width()+(tqt3tabwidth*1), tqt3elementrect.height());
				}
				if (drawingTab) {
					if (drawingTab->identifier() == (TQApplication::reverseLayout() ? (tabBarWidget->count()-1) : 0)) {
						// This is the first tab in the tab bar
						// We will end up clipping on the left edge if the rectangle is not adjusted
						tqt3elementrect = TQRect(tqt3elementrect.x()+tqt3tabwidth, tqt3elementrect.y(), tqt3elementrect.width()-(tqt3tabwidth*1), tqt3elementrect.height());
					}
				}
			}
			break;
		case CE_RadioButton:
			// Unlike Qt3, QStyle::CE_RadioButton draws the button, the label, and the focus rectangle
			// FIXME
			// Handle the focus rectangle
			tqtCE = TQStyle::CE_RadioButton;
			draw_second_element = true;
			tqtCE_element2 = TQStyle::CE_RadioButtonLabel;

			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQRadioButton);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQRadioButton, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				tqt3elementrect = tqApp->style().visualRect( tqApp->style().subRect(TQStyle::SR_RadioButtonIndicator, interfaceWidget), interfaceWidget);
				tqt3element2rect = tqApp->style().visualRect( tqApp->style().subRect(TQStyle::SR_RadioButtonContents, interfaceWidget), interfaceWidget);
				// HACK
				// Lock text area height to indicator height
				// [FIXME 001]
				// Figure out why this is needed!  Without it the text shows up lower than the indicator does...
				// Potential subRect() mismatch between Qt4 and TQt3?  See TQt3 qcommonstyle.cpp lines 1307 and 1315
				// Strange that this hack is not needed for the CheckBox and PushButton cases...
				tqt3element2rect.setHeight(tqt3elementrect.height());
			}
			break;
		case CE_CheckBox:
			// Unlike Qt3, QStyle::CE_CheckBox draws the button, the label, and the focus rectangle
			// FIXME
			// Handle the focus rectangle
			tqtCE = TQStyle::CE_CheckBox;
			draw_second_element = true;
			tqtCE_element2 = TQStyle::CE_CheckBoxLabel;

			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQCheckBox);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQCheckBox, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				tqt3elementrect = tqApp->style().visualRect( tqApp->style().subRect(TQStyle::SR_CheckBoxIndicator, interfaceWidget), interfaceWidget);
				tqt3element2rect = tqApp->style().visualRect( tqApp->style().subRect(TQStyle::SR_CheckBoxContents, interfaceWidget), interfaceWidget);
			}
			break;
		case CE_PushButton:
			// Unlike Qt3, QStyle::CE_PushButton draws the button, the label, and the focus rectangle
			// FIXME
			// Handle the focus rectangle
			tqtCE = TQStyle::CE_PushButton;
			draw_second_element = true;
			tqtCE_element2 = TQStyle::CE_PushButtonLabel;

			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQPushButton);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQPushButton, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				tqt3element2rect = tqApp->style().visualRect( tqApp->style().subRect(TQStyle::SR_PushButtonContents, interfaceWidget), interfaceWidget);
			}
			break;
		case CE_MenuItem:
			tqtCE = TQStyle::CE_PopupMenuItem;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQPopupMenu);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQPopupMenu, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				// Convert the QStyleOption to the proper TQStyleOption
				// In other words, figure out which TQt3 menu item is currently being drawn
				// Qt4 makes this really, really hard...
				// I have to guess based on the Qt4 position of the item in the menu, which may or may not work 100% in all cases
				drawingItem = 0;
				drawingAction = dynamic_cast<const QMenu*>(w)->actionAt(QPoint(opt->rect.x(), opt->rect.y()));
				qt4menuactions = dynamic_cast<const QMenu*>(w)->actions();
				for (i=0; i<qt4menuactions.size();++i) {
					if (qt4menuactions.at(i) == drawingAction) {
						TQPopupMenu* popupMenuWidget = dynamic_cast<TQPopupMenu*>(interfaceWidget);
						drawingItem = popupMenuWidget->findItem(popupMenuWidget->idAt(i));
					}
				}

				if (drawingItem) {
					tqt3tabwidth = static_cast<const QStyleOptionMenuItem*>(opt)->tabWidth;
					tqt3iconwidth = static_cast<const QStyleOptionMenuItem*>(opt)->maxIconWidth;
					tqt3opt = TQStyleOption(drawingItem, tqt3iconwidth, tqt3tabwidth);
				}
			}
			break;
		case QStyle::CE_MenuBarItem:
			tqtCE = TQStyle::CE_MenuBarItem;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQMenuBar);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQMenuBar, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			else {
				// Convert the QStyleOption to the proper TQStyleOption
				// In other words, figure out which TQt3 menu item is currently being drawn
				// Qt4 makes this really, really hard...
				// I have to guess based on the Qt4 position of the item in the menu, which may or may not work 100% in all cases
				drawingItem = 0;
				drawingAction = dynamic_cast<const QMenuBar*>(w)->actionAt(QPoint(opt->rect.x(), opt->rect.y()));
				qt4menuactions = dynamic_cast<const QMenuBar*>(w)->actions();
				TQMenuBar* menuBarWidget = dynamic_cast<TQMenuBar*>(interfaceWidget);
				for (i=0; i<qt4menuactions.size();++i) {
					if (qt4menuactions.at(i) == drawingAction) {
						drawingItem = menuBarWidget->findItem(menuBarWidget->idAt(i));
					}
				}

				if (drawingItem) {
					tqt3opt = TQStyleOption(drawingItem);
				}
			}
			break;
		case QStyle::CE_ToolBar:
			// TQt3 treats this as a primitive
			// It is drawn as such below
			DO_NOT_DRAW
			break;
		case QStyle::CE_HeaderSection:
			// TQt3 treats this as a primitive
			// It is drawn as such below
			DO_NOT_DRAW
			break;
		case QStyle::CE_ToolBoxTab:
			// Unlike TQt3, QStyle::CE_ToolBoxTab draws the tab, the label, and the focus rectangle
			// See below for Qt4 drawing calls
			tqtCE = TQStyle::CE_ToolBoxTab;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQToolBox);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQToolBox, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case QStyle::CE_MenuBarEmptyArea:
			tqtCE = TQStyle::CE_MenuBarEmptyArea;
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQMenuBar);
			interfaceWidget = initializeInterfaceWidget(TQT3WT_TQMenuBar, w, NULL, TRUE);
			if (interfaceWidget == 0) {
				can_override = false;
			}
			break;
		case QStyle::CE_MenuEmptyArea:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ItemViewItem:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ShapedFrame:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_TabBarTabShape:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarAddLine:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarSubLine:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarAddPage:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarSubPage:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarSlider:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarFirst:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		case QStyle::CE_ScrollBarLast:
			// Ignore request as Qt3 has no equivalent
			can_override = false;
			break;
		default:
			if (enable_debug_warnings) {
				printf("No rules to draw Qt4 control %d\n", element); fflush(stdout);
			}
			can_override = false;
	}

	if (can_override) {
		// Construct a Qt3 paint device on the Qt4 painter
		TDEQt4PaintDevice qt4pd(p);

		TQPainter tqtPainter(&qt4pd);

		if (element == QStyle::CE_TabBarTab) {
			// CE_TabBarTab doesn't draw the base panel of the tab
			tqt3tabwidth = tqApp->style().pixelMetric(TQStyle::PM_TabBarTabOverlap, interfaceWidget);
			tqtPainter.fillRect(TQRect(tqt3elementrect.x()+tqt3tabwidth, tqt3elementrect.y(), tqt3elementrect.width()-(tqt3tabwidth*2), tqt3elementrect.height()), tqt3colorgroup.background());
		}

		if (element == QStyle::CE_ToolBar) {
			tqApp->style().drawPrimitive(TQStyle::PE_PanelDockWindow, &tqtPainter, tqt3elementrect, tqt3colorgroup, sflags, tqt3opt);
		}

		if (element == QStyle::CE_HeaderSection) {
			tqApp->style().drawPrimitive(TQStyle::PE_HeaderSection, &tqtPainter, tqt3elementrect, tqt3colorgroup, sflags, tqt3opt);
		}

		if (do_not_draw == false) {
			// Instruct TQt3 to draw the control
			// FIXME
			// Implement sflags and QStyleOption
			tqApp->style().drawControl(tqtCE, &tqtPainter, interfaceWidget, tqt3elementrect, tqt3colorgroup, sflags, tqt3opt);
			if (draw_second_element == true) {
				tqApp->style().drawControl(tqtCE_element2, &tqtPainter, interfaceWidget, tqt3element2rect, tqt3colorgroup, sflags, tqt3opt_element2);
			}
			if (draw_third_element == true) {
				tqApp->style().drawControl(tqtCE_element3, &tqtPainter, interfaceWidget, tqt3element3rect, tqt3colorgroup, sflags, tqt3opt_element3);
			}
		}

		tqtPainter.end();

		if (tqtCE == TQStyle::CE_ToolBoxTab) {
			// Instruct Qt4 to draw the label
			BASE_QT4_STYLE_CLASS::drawControl(QStyle::CE_ToolBoxTabLabel, opt, p, w);
		}

		if (enable_debug_warnings) {
#ifdef DEBUG_SPEW
			printf("Used Qt3 control %d to draw Qt4 control %d\n", tqtCE, element); fflush(stdout);
#endif
		}
	}
	else {
		if (do_not_draw == false) {
			// Tell Qt4 to draw it
			BASE_QT4_STYLE_CLASS::drawControl(element, opt, p, w);
		}
	}
}

void Qt4TDEStyle::drawPrimitive(PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
{
	// Construct a Qt3 paint device translator on the Qt4 painter
	TDEQt4PaintDevice qt4pd(p);

	// Open a painter on the paint device translator
	TQPainter tqtPainter(&qt4pd);

	TQRect tqt3paintrect = TQRect(opt->rect.x(), opt->rect.y(), opt->rect.width(), opt->rect.height());

	bool can_override = true;
	bool do_not_draw = false;
	bool draw_transparent_background = false;
	TQStyle::PrimitiveElement tqtPE;
	TQStyleOption tqt3opt(TQStyleOption::Default);

	// Convert the style flags
	TQStyle::SFlags sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_NONE);

	// NOTE: Qt3 seems to combine PE_FrameMenu and PE_PanelMenu into PE_PanelPopup

	switch (pe) {
		case QStyle::PE_Frame:
			tqtPE = TQStyle::PE_Panel;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_FrameMenu:
			tqtPE = TQStyle::PE_PanelPopup;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_PanelMenuBar:
			tqtPE = TQStyle::PE_PanelMenuBar;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_PanelMenu:
			tqtPE = TQStyle::PE_PanelPopup;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_PanelToolBar:
			tqtPE = TQStyle::PE_PanelDockWindow;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_PanelButtonBevel:
			sflags = convertQt4ToTQt3SFlags(opt->state, TQT3WT_TQPushButton);
			tqtPE = TQStyle::PE_ButtonBevel;
			break;
		case QStyle::PE_FrameLineEdit:
			tqtPE = TQStyle::PE_PanelLineEdit;
			break;
		case QStyle::PE_PanelStatusBar:
			tqtPE = TQStyle::PE_Panel;
			break;
		case QStyle::PE_PanelButtonTool:
			tqtPE = TQStyle::PE_ButtonTool;
			break;
		case QStyle::PE_FrameGroupBox:
			tqtPE = TQStyle::PE_GroupBoxFrame;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_FrameWindow:
			tqtPE = TQStyle::PE_WindowFrame;
			tqt3opt = TQStyleOption(static_cast<const QStyleOptionFrame*>(opt)->lineWidth, static_cast<const QStyleOptionFrame*>(opt)->midLineWidth);
			break;
		case QStyle::PE_FrameFocusRect:
			// HACK
			// Qt4 tries to draw a focus rectangle around the entire tab
			// Needless to say this is ugly
			// TQt3 tries to draw the focus rectangle around the tab text only, which is better
			if (dynamic_cast<const QTabBar*>(w)) {
				// FIXME
				// We should attempt to draw the focus rectangle around the tab's text instead
				DO_NOT_DRAW
			}
			else {
				tqtPE = TQStyle::PE_FocusRect;
			}
			break;
		case QStyle::PE_FrameButtonTool:
			tqtPE = TQStyle::PE_ButtonTool;
			break;
		case QStyle::PE_IndicatorToolBarHandle:
			tqtPE = TQStyle::PE_DockWindowHandle;
			break;
		case QStyle::PE_IndicatorToolBarSeparator:
			tqtPE = TQStyle::PE_DockWindowSeparator;
			break;
		case QStyle::PE_IndicatorDockWidgetResizeHandle:
			tqtPE = TQStyle::PE_DockWindowResizeHandle;
			break;
		case QStyle::PE_IndicatorMenuCheckMark:
			tqtPE = TQStyle::PE_Indicator;
			break;
		case QStyle::PE_PanelTipLabel:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_PanelItemViewItem:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_PanelItemViewRow:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_PanelScrollAreaCorner:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_FrameTabBarBase:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_IndicatorBranch:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_IndicatorHeaderArrow:
			tqtPE = TQStyle::PE_HeaderArrow;
			break;
		case QStyle::PE_FrameTabWidget:
			tqtPE = TQStyle::PE_PanelTabWidget;
			// HACK
			// For an unknown reason Qt4 paints the tab border 2 pixels lower and shorter than it should
			// FIXME
			// Figure out why that happens!
			tqt3paintrect = TQRect(tqt3paintrect.x(), tqt3paintrect.y()-2, tqt3paintrect.width(), tqt3paintrect.height()+2);
			p->setClipRect(QRect(tqt3paintrect.x(), tqt3paintrect.y(), tqt3paintrect.width(), tqt3paintrect.height()));
			break;
		case QStyle::PE_FrameDefaultButton:
			tqtPE = TQStyle::PE_ButtonDefault;
			break;
		case QStyle::PE_PanelButtonCommand:
			tqtPE = TQStyle::PE_ButtonCommand;
			break;
		case QStyle::PE_IndicatorProgressChunk:
			tqtPE = TQStyle::PE_ProgressBarChunk;
			break;
		case QStyle::PE_IndicatorArrowDown:
			tqtPE = TQStyle::PE_ArrowDown;
			break;
		case QStyle::PE_IndicatorArrowLeft:
			tqtPE = TQStyle::PE_ArrowLeft;
			break;
		case QStyle::PE_IndicatorArrowRight:
			tqtPE = TQStyle::PE_ArrowRight;
			break;
		case QStyle::PE_IndicatorArrowUp:
			tqtPE = TQStyle::PE_ArrowUp;
			break;
		case QStyle::PE_IndicatorCheckBox:
			tqtPE = TQStyle::PE_Indicator;
			break;
		case QStyle::PE_IndicatorRadioButton:
			tqtPE = TQStyle::PE_ExclusiveIndicator;
			break;
		case QStyle::PE_IndicatorSpinDown:
			tqtPE = TQStyle::PE_SpinWidgetDown;
			break;
		case QStyle::PE_IndicatorSpinUp:
			tqtPE = TQStyle::PE_SpinWidgetUp;
			break;
		case QStyle::PE_IndicatorSpinPlus:
			tqtPE = TQStyle::PE_SpinWidgetPlus;
			break;
		case QStyle::PE_IndicatorSpinMinus:
			tqtPE = TQStyle::PE_SpinWidgetMinus;
			break;
		case QStyle::PE_IndicatorTabTear:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_FrameStatusBarItem:
			NO_QT3_EQUIVALENT
			break;
		case QStyle::PE_PanelLineEdit:
			// Under Qt4 this draws both the panel and the frame
			// Under TQt3 it only draws the frame
			// See resultant background fill routine directly before drawPrimitive below
			// Also, the given rectangle is only valid for LineEdit widgets without a parent QSpinBox, QComboBox, or similar widget
			// For those widgets we must draw a transparent background
			tqtPE = TQStyle::PE_PanelLineEdit;
			if (dynamic_cast<QSpinBox*>(w->parent()) || dynamic_cast<QComboBox*>(w->parent())) {
				draw_transparent_background = true;
			}
			break;
		// Qt3 support elements
		case QStyle::PE_Q3Separator:
			tqtPE = TQStyle::PE_Separator;
			break;
		default:
			if (enable_debug_warnings) {
				printf("No rules to draw Qt4 element %d\n", pe); fflush(stdout);
			}
			can_override = false;
	}

	// Determine the correct color group
	TQPalette tqt3palette = convertQt4ToTQt3Palette(opt->palette);
	TQColorGroup tqt3colorgroup;
	if (sflags & TQStyle::Style_Enabled) {
		if (sflags & TQStyle::Style_Active) {
			tqt3colorgroup = tqt3palette.active();
		}
		else {
			tqt3colorgroup = tqt3palette.inactive();
		}
	}
	else {
		tqt3colorgroup = tqt3palette.disabled();
	}

	if (can_override) {
		// Construct a Qt3 paint device on the Qt4 painter
		TDEQt4PaintDevice qt4pd(p);

		TQPainter tqtPainter(&qt4pd);

		// Certain primitives require additional drawing operations that Qt4 now expects
		if (tqtPE == TQStyle::PE_PanelLineEdit) {
			if (draw_transparent_background == false) {
				// Tell Qt4 to draw the background
				BASE_QT4_STYLE_CLASS::drawPrimitive(pe, opt, p, w);
			}
			else {
				p->fillRect(opt->rect, Qt::transparent);
			}
		}

		if (do_not_draw == false) {
			// Instruct TQt3 to draw the primitive
			if (!((tqtPE == TQStyle::PE_PanelLineEdit) && (draw_transparent_background == true))) {
				tqApp->style().drawPrimitive(tqtPE, &tqtPainter, tqt3paintrect, tqt3colorgroup, sflags, tqt3opt);
			}
		}

		tqtPainter.end();

		if (enable_debug_warnings) {
#ifdef DEBUG_SPEW
			printf("Used Qt3 element %d to draw Qt4 element %d\n", tqtPE, pe); fflush(stdout);
#endif
		}
	}
	else {
		if (do_not_draw == false) {
			// Tell Qt4 to draw it
			BASE_QT4_STYLE_CLASS::drawPrimitive(pe, opt, p, w);
		}
	}
}
