/***************************************************************************
 *   Copyright (C) 2005 by Bastian Holst                                   *
 *   bastianholst@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <kmdcodec.h>
#include <tqimage.h>
#include <tqdir.h>

#include "coverimage.h"

CoverImage::CoverImage() 
{
	setArtist(TQString());
	setAlbum(TQString());
	setURL(TQString());
	
	_coverfolder = TQDir::homeDirPath();
	_coverfolder.append("/.trinity/share/apps/amarok/albumcovers/");
	_largefolder = TQString(_coverfolder).append("large/");
	_cachefolder = TQString(_coverfolder).append("cache/");
	
	TQDir foldertest;
	foldertest.setPath(_coverfolder);
	if ( !foldertest.exists() )
		foldertest.mkdir(_coverfolder);
	if ( !foldertest.exists(_largefolder) )
		foldertest.mkdir(_largefolder);
	if ( !foldertest.exists(_cachefolder) )
		foldertest.mkdir(_cachefolder);
}

TQImage CoverImage::load(int size) const
{
	TQString imagepath(_cachefolder);
	KMD5 md5sum(artist().lower().utf8()+album().lower().utf8());
	imagepath.append(TQString::number ( size )).append("@").append(md5sum.hexDigest());
	TQImage image( imagepath );
	if ( image.isNull() )
	{
		if ( !url().isEmpty() ) {
			image.load(url());
		} else {
			imagepath = _largefolder;
			imagepath.append(md5sum.hexDigest());
			image.load( imagepath );
		}
		
		if ( !image.isNull() ) {
			TQString savepath(_cachefolder);
			savepath.append(TQString::number ( size )).append("@").append(md5sum.hexDigest());
			image = image.smoothScale(size, size, TQ_ScaleMin);
			if ( !url().isEmpty() ) {
				image.save( savepath, TQImage::imageFormat ( url() ));
			} else {
				image.save( savepath, TQImage::imageFormat ( imagepath ));
			}
		}
	}
	return image;
}

TQString CoverImage::artist() const
{
	return _artist;
}

TQString CoverImage::album() const
{
	return _album;
}

TQString CoverImage::url() const
{
	return _url;
}

void CoverImage::setArtist(const TQString& artist)
{
	_artist = artist;
}

void CoverImage::setAlbum(const TQString& album)
{
	_album = album;
}

void CoverImage::setURL(const TQString& url)
{
	_url = url;
}
