/***************************************************************************
 *   Copyright (C) 2006 by Vladimir Stefan   *
 *   vstefan85@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef UPGRADEWIZARD_H
#define UPGRADEWIZARD_H

#include <adept/kubuntu_upgrader/upgradewizardbase.h>

class TQString;
class TQTextIStream;
class TQDateTime;
class TDEProcess;
class KURL;
class ErrorDialog;

// ** Represents an entry in the metafile ** //
class DistroEntry {
	public:
		DistroEntry(TQString *d_field);
		~DistroEntry();
		TQString *dist_field;
		TQString *name_field;
		TQString *version_field;
		TQDateTime *date_field;
		bool supported_field;
		TQString *desc_field;
		KURL *release_file_url;
		KURL *release_notes_url;
		KURL *upgrade_tool_url;
		KURL *upgrade_tool_sig_url;
};

class UpgradeWizard : public UpgradeWizardDlg
{
  Q_OBJECT
  

public:
  UpgradeWizard(TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~UpgradeWizard();

  /*$PUBLIC_FUNCTIONS$*/
	bool 					checkForDistUpgrade(TQString url=TQString(""), bool developmentVersion = false);
	TQPtrList<DistroEntry> 	*parseMetafile( TQTextIStream *text_stream,
										 	TQString my_distro_name );
	
public slots:
  /*$PUBLIC_SLOTS$*/
	void 					receiveDistroName( TDEProcess* p, char *buffer, int buflen );
	void 					launchDistUpdater();
	void					fetchReleaseAnnounce();
	void					fetchUpgradeTool();
	void					fetchUpgradeToolSig();
	void					verifyUpgradeTool();
	

	signals:
	void					killErrorDialog();

protected:
  /*$PROTECTED_FUNCTIONS$*/
	void					removeOldUpgradeTool();
	void					removeDirectory(TQString directoryName);

protected slots:
  /*$PROTECTED_SLOTS$*/
  	virtual void   	    	back();
  	virtual void    	    next();

private:
	TQString upgrade_tool_location;
	TQString upgrade_tool_sig_location;
	TQString distro_name;
	DistroEntry* upgrade_dist;
	DistroEntry* current_dist;
	ErrorDialog* err_dlg;
};

#endif

