/***************************************************************************
 *
 * tdenetman-connection_setting_serial_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2008 Novell, Inc.
 *
 * Author: Will Stephenson <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <limits.h>
// qt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// tdenm headers
#include "tdenetman-connection_setting_serial_widget.h"

#include "connection_setting_serial.h"

using namespace ConnectionSettings;

SerialWidgetImpl::SerialWidgetImpl(TDENetworkConnection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_parentdialog = dynamic_cast<ConnectionSettingsDialogImpl*>(parent);

	_serialsetting = conn;

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingSerialWidget(this);
	layout->addWidget(_mainWid);
	_mainWid->mBaudRate->setMaxValue(INT_MAX);
	Init();
}

void
SerialWidgetImpl::Init()
{
	if (_serialsetting->serialConfig.valid) {
		_mainWid->mBaudRate->setValue(_serialsetting->serialConfig.baudRate);
		_mainWid->mDataBits->setCurrentItem(_serialsetting->serialConfig.byteWidth - 7);
		setParityType(_serialsetting->serialConfig.parity);
		_mainWid->mStopBits->setCurrentItem(_serialsetting->serialConfig.stopBits);
		_mainWid->mSendDelay->setValue(_serialsetting->serialConfig.txDelay);
	}
	
	connect( _mainWid->mBaudRate, TQT_SIGNAL(valueChanged(int)), TQT_SLOT(dirty()));
	connect( _mainWid->mDataBits, TQT_SIGNAL(activated(int)), TQT_SLOT(dirty()));
	connect( _mainWid->mParity, TQT_SIGNAL(activated(int)), TQT_SLOT(dirty()));
	connect( _mainWid->mStopBits, TQT_SIGNAL(activated(int)), TQT_SLOT(dirty()));
	connect( _mainWid->mSendDelay, TQT_SIGNAL(valueChanged(int)), TQT_SLOT(dirty()));
}

void
SerialWidgetImpl::Deactivate()
{
}

void
SerialWidgetImpl::Activate()
{

}

void
SerialWidgetImpl::dirty()
{
	_serialsetting->serialConfig.baudRate = _mainWid->mBaudRate->value();
	_serialsetting->serialConfig.byteWidth = _mainWid->mDataBits->currentItem() + 7;
	_serialsetting->serialConfig.parity = getParityType();
	_serialsetting->serialConfig.stopBits = _mainWid->mStopBits->currentItem();
	_serialsetting->serialConfig.txDelay = _mainWid->mSendDelay->value();

	_serialsetting->serialConfig.valid = true;

	if (_parentdialog) _parentdialog->slotEnableButtons();	// Update lockouts
}

void
SerialWidgetImpl::setParityType(TDENetworkParity::TDENetworkParity type)
{
	if (type == TDENetworkParity::None) {
		_mainWid->mParity->setCurrentItem(0);
	}
	else if (type == TDENetworkParity::Even) {
		_mainWid->mParity->setCurrentItem(1);
	}
	else if (type == TDENetworkParity::Odd) {
		_mainWid->mParity->setCurrentItem(2);
	}
	else {
		_mainWid->mParity->setCurrentItem(0);
	}
}

TDENetworkParity::TDENetworkParity
SerialWidgetImpl::getParityType()
{
	int itemNo = _mainWid->mParity->currentItem();
	if (itemNo == 0) {
		return TDENetworkParity::None;
	}
	else if (itemNo == 1) {
		return TDENetworkParity::Even;
	}
	else if (itemNo == 2) {
		return TDENetworkParity::Odd;
	}
	else {
		return TDENetworkParity::None;
	}
}

#include "tdenetman-connection_setting_serial_widget.moc"
