/***************************************************************************
 *
 * tdenetman-connection_setting_cdma_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// tdenm headers
#include "tdenetman-connection_setting_cdma_widget.h"

// ui headers
#include "connection_setting_cdma.h"

using namespace ConnectionSettings;

CDMAWidgetImpl::CDMAWidgetImpl(TDENetworkConnection* conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
{
	_parentdialog = dynamic_cast<ConnectionSettingsDialogImpl*>(parent);

	_cdmasetting = dynamic_cast<TDEModemConnection*>(conn);

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingCdmaWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
CDMAWidgetImpl::Init()
{
	if (_cdmasetting->cdmaConfig.valid) {
		_mainWid->mUsername->setText( _cdmasetting->cdmaConfig.username );
		_mainWid->mNumber->setText( _cdmasetting->cdmaConfig.providerDataNumber );
		if (_cdmasetting->cdmaConfig.secretsValid) {
			_mainWid->mPassword->setText( _cdmasetting->cdmaConfig.password );
		}
	}
	connect( _mainWid->mUsername, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
	connect( _mainWid->mPassword, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
	connect( _mainWid->mNumber, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(dirty()));
}

void
CDMAWidgetImpl::Deactivate()
{
}

void
CDMAWidgetImpl::Activate()
{

}

void
CDMAWidgetImpl::dirty()
{
	_cdmasetting->cdmaConfig.username = _mainWid->mUsername->text();
	_cdmasetting->cdmaConfig.password = _mainWid->mPassword->text();
	_cdmasetting->cdmaConfig.providerDataNumber = _mainWid->mNumber->text();
	_cdmasetting->cdmaConfig.valid = true;
	_cdmasetting->cdmaConfig.secretsValid = true;

	if (_parentdialog) _parentdialog->slotEnableButtons();	// Update lockouts
}


#include "tdenetman-connection_setting_cdma_widget.moc"
