/***************************************************************************
 *
 * knetworkmanager.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// KDE includes
#include <kdebug.h>
#include <tdelocale.h>

// NM includes
#include <NetworkManager.h>
#include <NetworkManagerVPN.h>

// TQDBus includes
#include <tqdbusdata.h>

// KNM includes
#include "knetworkmanager.h"
#include "knetworkmanager-tray.h"
#include "knetworkmanager-devicestore.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-cellular_device.h"
#include "knetworkmanager-wireless_device.h"
#include "knetworkmanager-wired_device.h"
#include "knetworkmanager-vpn_device.h"
#include "knetworkmanager-cellular_device_tray.h"
#include "knetworkmanager-wireless_device_tray.h"
#include "knetworkmanager-wired_device_tray.h"
#include "knetworkmanager-nmsettings.h"
#include "knetworkmanager-storage.h"
#include "xmlmarshaller.h"

// KNM includes
#include "vpn_tray_component.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-vpn_connection.h"
#include "knetworkmanager-nm_proxy.h"
#include "knetworkmanager-vpn_plugin.h"

#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_vpn.h"
#include "knetworkmanager-connection_settings_dialog.h"

#include <stdio.h>

// TQt includes
#include <tqstring.h>
#include <tqobject.h>

// KDE includes
#include <tdeglobal.h>
#include <kiconloader.h>

char active_vpn_prev = 0;
extern NMDeviceState nm_device_state_global;
VPNDBUSPlugin* vpnproxy;

class KNetworkManagerPrivate
{
	public:
		KNetworkManagerPrivate() {}
		~KNetworkManagerPrivate() {}
	static KNetworkManager* _ctx;
};

KNetworkManager* KNetworkManagerPrivate::_ctx = NULL;

KNetworkManager* KNetworkManager::getInstance()
{
	return KNetworkManagerPrivate::_ctx;
}

void
KNetworkManager::slotShutDown()
{
	// cleanup code
	Storage* storage = Storage::getInstance();

	// save all connections (if not done already)
	storage->saveConnections();
}

void KNetworkManager::timerEvent( TQTimerEvent *e )
{
	Tray* tray = Tray::getInstance();
	tray->slotUpdateDeviceState(nm_device_state_global);
}

KNetworkManager::KNetworkManager () : KUniqueApplication ()
{
	d = new KNetworkManagerPrivate();
	d->_ctx = this;

	// we need to get informed when shutting down
	connect(this, TQT_SIGNAL(shutDown()), this, TQT_SLOT(slotShutDown()));

	// Start the VPN icon timer
	// startTimer( 1000 );  // 1-second timer

	// Connect to the VPN bus
	vpnproxy = new VPNDBUSPlugin();

	// create the main-tray-icon
	Tray* tray = Tray::getInstance();
	tray->show();
	setMainWidget(tray);

	// create the settings interface
	NMSettings::getInstance();

	// restore all known connections first
	Storage* storage = Storage::getInstance();
	storage->restoreConnections();
}

KNetworkManager::~KNetworkManager()
{
	delete vpnproxy;
	delete d;
}

#include "knetworkmanager.moc"

