/***************************************************************************
 *
 * knetworkmanager-nminfo_dbus.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <stdlib.h>
#include <kdebug.h>

#include <NetworkManager.h>

#include <tqdbusobjectpath.h>
#include <tqdbusconnection.h>

#include "knetworkmanager.h"
#include "knetworkmanager-nmsettings.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_store.h"
#include "knetworkmanager-connection.h"

#if !defined(NM_CHECK_VERSION)
#define NM_CHECK_VERSION(x,y,z) 0
#endif

class NMSettingsPrivate
{
	public:
		NMSettingsPrivate()
			: obj_path_index(0)
		{

		}

		~NMSettingsPrivate()
		{

		}

		int obj_path_index;
};


NMSettings* NMSettings::_instance = NULL;

NMSettings* NMSettings::getInstance()
{
	// return singleton instance
	if (_instance)
		return _instance;
	return (_instance = new NMSettings());
}

NMSettings::NMSettings()
{
	d = new NMSettingsPrivate();
	TQT_DBusConnection conn = TQT_DBusConnection::systemBus();

	kdDebug() << "NMSettings::NMSettings" << endl;

#if NM_CHECK_VERSION(0,8,992)
	if (!conn.requestName("org.freedesktop.NetworkManagerUserSettings"))
		kdError() << "req name failed for " << "org.freedesktop.NetworkManagerUserSettings" << endl;
#else
	// request the name for the settings interface
	if (!conn.requestName(NM_DBUS_SERVICE_USER_SETTINGS))
		kdError() << "req name failed for " << NM_DBUS_SERVICE_USER_SETTINGS << endl;
#endif

	// request the name for the connections here too
	if (!conn.requestName(NM_DBUS_IFACE_SETTINGS_CONNECTION))
		kdError() << "req name failed for " << NM_DBUS_IFACE_SETTINGS_CONNECTION << endl;

	// request the name for the connections here too
	if (!conn.requestName(NM_DBUS_IFACE_SETTINGS_CONNECTION_SECRETS))
		kdError() << "req name failed for " << NM_DBUS_IFACE_SETTINGS_CONNECTION_SECRETS << endl;

	// register on the DBus
	if (!conn.registerObject(objectPath(), this))
		kdError() << "registerobjectpath failed" << endl;


	ConnectionStore* cstore = ConnectionStore::getInstance();

	// we need to get informed about new connections...
	connect(cstore, TQT_SIGNAL(signalConnectionAdded(ConnectionSettings::Connection*)), this, TQT_SLOT(slotNewConnection(ConnectionSettings::Connection*)));
}

NMSettings::~NMSettings()
{
	delete d;
	TQT_DBusConnection conn = TQT_DBusConnection::systemBus();
	conn.unregisterObject(NM_DBUS_PATH_SETTINGS);
}


bool NMSettings::handleSignalSend(const TQT_DBusMessage& reply)
{
	TQT_DBusConnection::systemBus().send(reply);
	return true;
}

TQString NMSettings::objectPath() const
{
	return TQString(NM_DBUS_PATH_SETTINGS);
}

bool NMSettings::ListConnections(TQValueList<TQT_DBusObjectPath>& connections, TQT_DBusError& /*error*/)
{
	// return connections
	ConnectionStore* cstore = ConnectionStore::getInstance();
	TQValueList<ConnectionSettings::Connection*> conns = cstore->getConnections();

	for (TQValueList<ConnectionSettings::Connection*>::Iterator it = conns.begin(); it != conns.end(); ++it)
	{
		ConnectionSettings::Connection* conn = (*it);
		connections.append(conn->getObjectPath());
	}

	return true;
}

void NMSettings::handleMethodReply(const TQT_DBusMessage& reply)
{
	TQT_DBusConnection::systemBus().send(reply);
}

TQT_DBusObjectPath
NMSettings::getObjPathForConnection()
{
	// just increase the number for this connection
	TQT_DBusObjectPath obj_path(NM_DBUS_PATH_SETTINGS_CONNECTION"/");
	obj_path += TQString::number(d->obj_path_index++);
	return obj_path;
}

void
NMSettings::slotNewConnection(ConnectionSettings::Connection* conn)
{
	emitNewConnection(conn->getObjectPath());
}


#include "knetworkmanager-nmsettings.moc"
