/***************************************************************************
                          kbswitchapp.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBSWITCHAPP_H
#define KBSWITCHAPP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeversion.h>
#if TDE_VERSION_MAJOR >= 3
  #include <kuniqueapplication.h>
#else
  #include <kuniqueapp.h>
#endif

//#include <ntqmap.h>

#include "kbgroup.h"
#include "kbswitchtrayicon.h"
#include "kbconfig.h"
#include "xkeyboard.h"
#include "kbswitchintf.h"
#include "windowwatcher.h"

/*class KWinModule;

typedef struct _KBWinInfo {
  int groupno;
  int next_groupno;
} KBWinInfo;

typedef TQMap<WId, KBWinInfo> KBWindowMap;*/

/**
  *@author Leonid Zeitlin
  */

class KBSwitchApp : public KUniqueApplication {
  Q_OBJECT
public: 
  KBSwitchApp();
  ~KBSwitchApp();
protected: // Protected methods
  /** No descriptions */
  bool x11EventFilter(XEvent *e);
private: // Private attributes
  /**  */
  bool m_force_group_setting;
  int m_cur_groupno;
  int m_next_groupno;
  XKeyboard m_xkb;
  /**  */
  KBSwitchTrayIcon * m_trayicon;
  /** No descriptions */
  KBConfig m_kbconf;
  KBSwitchIntf *m_intf;
#ifndef HAVE_LIBXKLAVIER  
  /** Window manager interface */
  //KWinModule *m_twin_module;
  /** Maps Window IDs to their keyboard groups */
  //KBWindowMap m_window_map;
  //KBWindowMap::iterator m_active_window;
  WindowWatcher *m_watcher;
  KBConfig::GroupScope m_watcher_type;
#endif  
private: // Private methods
  /** Update the tray icon to show the flag corresponding to the current keyboard group */
  void updateIcon(int groupno);
  /** No descriptions */
  void internalToggleGroups();
  /** No descriptions */
  void forceSetGroup(int groupno);
  /** No descriptions */
  /*int getNextGroup(int groupno) {
    return groupno >= m_kbconf.groupCount() - 1 ? 0 : groupno + 1;
  }*/
  /** No descriptions */
  void setStartGroup(int start_group);
  void adaptToGroup(int groupno);
#ifndef HAVE_LIBXKLAVIER  
  /** initialize Window groups map */
  //void resetWindowMap();
  /** Disable window manager notifications */
  //void disableKWinModule();
  /** Enable window manager notifications */
  //void enableKWinModule();
  /** adds a new window to the internal window map */
  //void addWindowToMap(WId window_id);
  void enableWatcher();
  void disableWatcher();
#endif  
  /** Set the current and next groups */
  void setGroups(int group, int next_group);
private slots: // Private slots
  /** No descriptions */
  void slotGroupSelected(int groupno);
  /** No descriptions */
  void slotSelectNextGroup();
  /** No descriptions */
  void slotPreferences();
  /** No descriptions */
  void reconfigure();
  /** Respond to XKB changing the current group */
  void slotXkbGroupChanged(int groupno);
  /** Respond to changing of active window - active it's kb group */
  //void slotWindowChanged(WId activeWindow);
  /** Respond to removal of a window - remote it from Window groups map */
  //void slotWindowRemoved(WId window);
  void slotWindowChanged(int groupno, int next_groupno);
  /** React to a change in KKBSwitch's user preferences,
    * made by user in Configure dialog */
  void slotPrefChanged();
};

#endif
