/***************************************************************************
 * variant.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "variant.h"
#include "list.h"

#include <tdelocale.h>

using namespace Kross::Api;

Variant::Variant(const TQVariant& value)
    : Value<Variant, TQVariant>(value)
{
}

Variant::~Variant()
{
}

const TQString Variant::getClassName() const
{
    return "Kross::Api::Variant";
}

const TQString Variant::toString()
{
    return getValue().toString();
}

/*
const TQString Variant::getVariantType(Object::Ptr object)
{
    switch( toVariant(object).type() ) {

        case TQVariant::CString:
        case TQVariant::String:
            return "Kross::Api::Variant::String";
        case TQVariant::Map:
            return "Kross::Api::Variant::Dict";
        case TQVariant::StringList:
        case TQVariant::List:
            return "Kross::Api::Variant::List";
        case TQVariant::Double:
            //return "Kross::Api::Variant::Double";
        case TQVariant::UInt: 
            //return "Kross::Api::Variant::UInt"; // python isn't able to differ between int and uint :-(
        case TQVariant::LongLong:
        case TQVariant::ULongLong:
        case TQVariant::Int:
            return "Kross::Api::Variant::Integer";
        case TQVariant::Bool:
            return "Kross::Api::Variant::Bool";
        default: //Date, Time, DateTime, ByteArray, BitArray, Rect, Size, Color, Invalid, etc.
            return "Kross::Api::Variant";
    }
}
*/

const TQVariant& Variant::toVariant(Object::Ptr object)
{
    return Object::fromObject<Variant>( object.data() )->getValue();
}

const TQString Variant::toString(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::String))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::String expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toString();
}

int Variant::toInt(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::Int))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::Int expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toInt();
}

uint Variant::toUInt(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::UInt))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::UInt expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toUInt();
}

double Variant::toDouble(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::Double))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::Double expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toDouble();
}

TQ_LLONG Variant::toLLONG(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::LongLong))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::LLONG expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toLongLong();
}

TQ_ULLONG Variant::toULLONG(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::ULongLong))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::ULLONG expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toULongLong();
}

bool Variant::toBool(Object::Ptr object)
{
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::Bool))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::Bool expected, but got %1.").arg(variant.typeName()).latin1()) );
    return variant.toBool();
}

TQStringList Variant::toStringList(Object::Ptr object)
{
    List* list = dynamic_cast< List* >( object.data() );
    if(list) {
        TQStringList l;
        TQValueList<Object::Ptr> valuelist = list->getValue();
        TQValueList<Object::Ptr>::Iterator it(valuelist.begin()), end(valuelist.end());
        for(; it != end; ++it)
            l.append( toString(*it) );
        return l;
    }
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::StringList))
        throw Exception::Ptr( new Exception(TQString("Kross::Api::Variant::StringList expected, but got '%1'.").arg(variant.typeName()).latin1()) );
    return variant.toStringList();
}

TQValueList<TQVariant> Variant::toList(Object::Ptr object)
{
    List* list = dynamic_cast< List* >( object.data() );
    if(list) {
        TQValueList<TQVariant> l;
        TQValueList<Object::Ptr> valuelist = list->getValue();
        TQValueList<Object::Ptr>::Iterator it(valuelist.begin()), end(valuelist.end());
        for(; it != end; ++it)
            l.append( toVariant(*it) );
        return l;
    }
    const TQVariant& variant = toVariant(object);
    if(! variant.canCast(TQVariant::List))
        throw Exception::Ptr( new Exception(i18n("Kross::Api::Variant::List expected, but got '%1'.").arg(variant.typeName()).latin1()) );
    return variant.toList();
}
