/* This file is part of the KDE project
   Copyright (C) 2002-2003 Ariya Hidayat <ariya@kde.org>
             (C) 2002-2003 Norbert Andres <nandres@web.de>
             (C) 2002-2003 Philipp Mueller <philipp.mueller@gmx.de>
             (C) 2002 Laurent Montel <montel@kde.org>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __kspread_dlg_paperlayout__
#define __kspread_dlg_paperlayout__

#include <kdialogbase.h>
#include <KoPageLayoutDia.h>

class TQCheckBox;
class TQComboBox;
class TQRadioButton;
class TQLineEdit;

namespace KSpread
{
class Sheet;
class View;

class PaperLayout: public KoPageLayoutDia
{
  Q_OBJECT
  
public:
  PaperLayout( TQWidget* parent, const char* name,
                      const KoPageLayout& layout,
                      const KoHeadFoot& headfoot,
                      int tabs, KoUnit::Unit unit,
                      Sheet * sheet, View *view);

  bool eventFilter( TQObject* obj, TQEvent* ev );

protected slots:
  virtual void slotOk();
  virtual void slotCancel();
  void slotSelectionChanged();

protected:
  void initTab();

protected:
  virtual void closeEvent ( TQCloseEvent * );

private slots:
    void slotChooseZoom( int index );
    void slotChoosePageLimit( int index );

private:
  void initGeneralOptions( TQWidget * tab, TQVBoxLayout * vbox );
  void initRanges( TQWidget * tab, TQVBoxLayout * vbox );
  void initScaleOptions( TQWidget * tab, TQVBoxLayout * vbox );

  Sheet * m_pSheet;
  View  * m_pView;

  TQCheckBox * pApplyToAll;
  TQCheckBox * pPrintGrid;
  TQCheckBox * pPrintCommentIndicator;
  TQCheckBox * pPrintFormulaIndicator;
  TQCheckBox * pPrintObjects;
  TQCheckBox * pPrintCharts;
  TQCheckBox * pPrintGraphics;
  TQLineEdit * ePrintRange;
  TQLineEdit * eRepeatCols;
  TQLineEdit * eRepeatRows;
  TQLineEdit * m_focus;
  TQComboBox * m_cZoom;
  TQComboBox * m_cLimitPagesX;
  TQComboBox * m_cLimitPagesY;
  TQRadioButton * m_rScalingZoom;
  TQRadioButton * m_rScalingLimitPages;
};

} // namespace KSpread

#endif
