/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2005 Peter Simonsson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef KIVIOOBJECTLISTPALETTE_H
#define KIVIOOBJECTLISTPALETTE_H

#include <tqwidget.h>

class TDEListView;
class KivioView;

namespace Kivio {

/**
 * Palette showing a list of all objects on the page
 */
class ObjectListPalette : public TQWidget
{
  Q_OBJECT
  
  public:
    ObjectListPalette(KivioView* parent = 0, const char* name = 0);
    ~ObjectListPalette();

    void updateObjectList();

  protected slots:
    void updateSelection();

  private:
    KivioView* m_view;
    TDEListView* m_objectList;

    bool m_blockUpdate;
};

}

#endif
