/***************************************************************************
                          kmymoneylistviewitem  -  description
                             -------------------
    begin                : Sun Nov 25 2007
    copyright            : (C) 2007 by Alvaro Soliverez
    email                : asoliverez@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

#include <tqpalette.h>
#include <tqpen.h>
#include <tqcolor.h>
#include <tqpainter.h>

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneyforecastlistviewitem.h"

#include <kmymoney/kmymoneyglobalsettings.h>

KMyMoneyForecastListViewItem::KMyMoneyForecastListViewItem (TQListView* parent, TQListViewItem* after, bool isNegative) :
  TDEListViewItem(parent, after),
  m_negative(isNegative)
{
}

KMyMoneyForecastListViewItem::~KMyMoneyForecastListViewItem()
{
}

void KMyMoneyForecastListViewItem::paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment)
{
  TQColorGroup _cg = cg;
  TQColor textColour;
  if(m_negative == true) {
    textColour = KMyMoneyGlobalSettings::listNegativeValueColor(); //if the item is marked is marked as negative, all columns will be painted negative
  } else {
    textColour = m_columnsColor[column]; //otherwise, respect the color for each column
  }
  _cg.setColor(TQColorGroup::Text, textColour); 
  
  TDEListViewItem::paintCell(p, _cg, column, width, alignment);
}

void KMyMoneyForecastListViewItem::setNegative(bool isNegative)
{
  m_negative = isNegative;
}

void KMyMoneyForecastListViewItem::setText( int column, const TQString &text, const bool &negative)
{
  //if negative set the map to negative color according to KMyMoneySettings
  if(negative) {
    m_columnsColor[column] = KMyMoneyGlobalSettings::listNegativeValueColor();
  } else {
    m_columnsColor[column] = TQColorGroup::Text;
  }
  
  TDEListViewItem::setText(column, text);
}
