

#ifndef CONVERTPLUGINLOADER_H
#define CONVERTPLUGINLOADER_H

#include "pluginloaderbase.h"


/**
 * @short The complete data, how to use the backend
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConvertPlugin
{
public:
    /**
     * Constructor
     */
    ConvertPlugin();

    /**
     * Destructor
     */
    virtual ~ConvertPlugin();

    TQString filePathName; // the file name of th plugin (needed to detect write permissions)

    struct Info
    {
        int version;    // the version of our plugin (v0.2.1 = 201, v11.3 = 110300)
        TQString name;   // the name of our plugin
        TQString author; // the author of the plugin
        TQString about;  // a short information aboue the plugin
    } info;

    struct Enc
    {
        bool enabled;
        int rank;
        TQString bin;
        TQString param;
        TQString silent_param;
        TQStringList mime_types;
        TQString in_out_files;
        TQString overwrite;

        struct Strength {
            bool enabled;
            TQString param;
            float range_min;
            float range_max;
            float step;
            TQChar separator;
            TQStringList profiles;
            float default_value;
        } strength;

        struct Lossy {
            bool enabled;

            struct Quality {
                bool enabled;
                TQString param;
                float range_min;
                float range_max;
                float step;
                TQChar separator;
                TQString help;
                TQString output;
                TQStringList profiles; // NOTE when using profiles, step must be 1 and range_min 0
            } quality;

            struct Bitrate {
                struct Abr
                {
                    bool enabled;
                    TQString param;
                    TQString output;

                    struct BitrateRange {
                        bool enabled;
                        TQString param_min;
                        TQString param_max;
                    } bitrate_range;

                } abr;

                struct Cbr {
                    bool enabled;
                    TQString param;
                    TQString output;
                } cbr;

            } bitrate;

            struct Samplingrate {
                bool enabled;
                TQString param;
                PluginLoaderBase::Unit unit;
            } samplingrate;

            struct Channels {
                bool stereo_enabled;
                TQString stereo_param;
                bool joint_stereo_enabled;
                TQString joint_stereo_param;
                bool forced_joint_stereo_enabled;
                TQString forced_joint_stereo_param;
                bool dual_channels_enabled;
                TQString dual_channels_param;
                bool mono_enabled;
                TQString mono_param;
            } channels;
        } lossy;

        struct Lossless {
            bool enabled;
            TQString param;
            TQString output;
        } lossless;

        struct Hybrid {
            bool enabled;
            TQString param;
            TQString output;
            TQString correction_file_mime_type;
        } hybrid;

        struct ReplayGain {
            bool enabled;
            TQString use;
            TQString avoid;
            int rank;
        } replaygain;

        struct Tag {
            bool enabled;
            TQString param;
            TQString artist;
            TQString composer;
            TQString album;
            TQString disc;
            TQString title;
            TQString genre;
            TQString comment;
            TQString track;
            TQString year;
        } tag;
    } enc;

    struct Dec {
        bool enabled;
        int rank;
        TQString bin;
        TQString param;
        TQString silent_param;
        TQStringList mime_types;
        TQString output;
        TQString in_out_files;
        TQString overwrite;
    } dec;
};

/**
 * @short The plugin loader for the converter plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConvertPluginLoader : public PluginLoaderBase
{
    Q_OBJECT
  
public:
    /**
     * Constructor
     */
    ConvertPluginLoader();

    /**
     * Destructor
     */
    virtual ~ConvertPluginLoader();

    /** is this file a converter plugin and loadable? */
    int verifyFile( TQString );
    /** load a given file */
    ConvertPlugin* loadFile( TQString );
};

#endif // CONVERTPLUGINLOADER_H
