#ifndef _LOGVIEWMDIWINDOW_H_
#define _LOGVIEWMDIWINDOW_H_
//
//   File : logviewmdiwindow.h
//   Creation date : Tue Apr 23 2002 18:05:59 by Juanjo �varez
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2007 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "kvi_settings.h"
#include "kvi_window.h"
#include "kvi_moduleextension.h"

#include "kvi_tal_vbox.h"
#include "kvi_tal_listview.h"
#include "kvi_pointerlist.h"
#include <tqtabwidget.h>
#include <tqdatetime.h> 

class KviTalListView;
class TQStringList;
class KviLogViewWidget;
class TQCheckBox;
class TQLineEdit;
class TQDateEdit;

class KviLogFile {

public:
	
	enum KviLogTypes {
		Channel,
		Console,
		Query,
		DccChat,
		Other
	};

	KviLogFile(const TQString& name);

	const TQString & fileName() { return m_szFilename; };
	const TQString & name() { return m_szName; };
	const TQString & network() { return m_szNetwork; };
	const TQDate   & date() { return m_date; };

	void getText(TQString & text,const TQString& logDir);

	KviLogTypes type() { return m_type; };
private:
	KviLogTypes  m_type;
	TQString      m_szFilename;
	bool         m_bCompressed;
	TQString      m_szName;
	TQString      m_szNetwork;
	TQDate        m_date;
};

class KviLogViewMDIWindow : public KviWindow , public KviModuleExtension
{
    Q_OBJECT
  
public: 
	KviLogViewMDIWindow(KviModuleExtensionDescriptor * d,KviFrame * lpFrm);
	~KviLogViewMDIWindow();
protected:
	KviPointerList<KviLogFile> m_logList;

	KviTalListView     * m_pListView;

	// Type filter
	TQCheckBox          * m_pShowChannelsCheck;
	TQCheckBox          * m_pShowQueryesCheck;
	TQCheckBox          * m_pShowConsolesCheck;
	TQCheckBox          * m_pShowOtherCheck;
	TQCheckBox          * m_pShowDccChatCheck;

	// Content filter
	TQLineEdit          * m_pFileNameMask;
	TQLineEdit          * m_pContentsMask;

	// Date/time mask
	TQCheckBox          * m_pEnableFromFilter;
	TQCheckBox          * m_pEnableToFilter;
	TQDateEdit          * m_pFromDateEdit;
	TQDateEdit          * m_pToDateEdit;

	TQStringList        * m_pFileNames;
	TQString              m_szLogDirectory;
	TQTabWidget         * m_pTabWidget;
	KviTalVBox         * m_pIndexTab;
	TQWidget            * m_pSearchTab;
protected:
	TQStringList getFileNames();
	
	void setupItemList();
	void cacheFileList();

	virtual TQPixmap * myIconPtr();
	virtual void resizeEvent(TQResizeEvent *e);
	virtual void fillCaptionBuffers();
	virtual void die();
	virtual TQSize sizeHint() const;
protected slots:
	void rightButtonClicked ( KviTalListViewItem *, const TQPoint &, int );
	void itemSelected(KviTalListViewItem * it);
	void deleteCurrent();
	void applyFilter();
};

#endif //_LOGVIEWMDIWINDOW_H_

