#ifndef _ACTIONEDITOR_H_
#define _ACTIONEDITOR_H_
//=============================================================================
//
//   File : actioneditor.h
//   Creation date : Tue Dec 29 2004 02:40:55 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the linkss of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_window.h"

#include <tqwidget.h>
#include "kvi_tal_listview.h"
#include "kvi_styled_controls.h"

class KviActionEditorListViewItem;

class KviActionData
{
public:
	TQString m_szName;
	TQString m_szScriptCode;
	TQString m_szVisibleName;
	TQString m_szDescription;
	TQString m_szCategory;
	TQString m_szBigIcon;
	TQString m_szSmallIcon;
	TQString m_szKeySequence;
	unsigned int m_uFlags;
	KviActionEditorListViewItem * m_pItem; // ummigarba tanto...
public:
	KviActionData(const TQString &szName,
		const TQString &szScriptCode,
		const TQString &szVisibleName,
		const TQString &szDescription,
		const TQString &szCategory,
		const TQString &szBigIcon,
		const TQString &szSmallIcon,
		unsigned int uFlags,
		const TQString &szKeySequence,
		KviActionEditorListViewItem * pItem)
	: m_szName(szName), m_szScriptCode(szScriptCode), m_szVisibleName(szVisibleName),
		m_szDescription(szDescription), m_szCategory(szCategory), m_szBigIcon(szBigIcon),
		m_szSmallIcon(szSmallIcon), m_szKeySequence(szKeySequence), m_uFlags(uFlags),
		m_pItem(pItem)
	{};
};


class TQLineEdit;
class TQComboBox;
class KviScriptEditor;
class TQToolButton;
class TQSimpleRichText;
class TQPushButton;

#ifdef COMPILE_USE_QT4
	#include <tq3simplerichtext.h>
	#define TQSimpleRichText Q3SimpleRichText
#else
	#include <tqsimplerichtext.h>
#endif



class KviActionEditorListViewItem : public KviTalListViewItem
{
public:
	KviActionEditorListViewItem(KviTalListView * v,KviActionData * a);
	~KviActionEditorListViewItem();
protected:
	KviActionData * m_pActionData;
	TQSimpleRichText * m_pText;
	TQPixmap * m_pIcon;
	KviTalListView * m_pListView;
	TQString m_szKey;
public:
	KviActionData * actionData(){ return m_pActionData; };
	void setupForActionData();
public:
	virtual void paintCell(TQPainter * p,const TQColorGroup & cg,int column,int width,int align);
	virtual void setup();
	virtual TQString key(int,bool) const;
};


class KviActionEditorListView : public KviTalListView
{
	Q_OBJECT
  
public:
	KviActionEditorListView(TQWidget * pParent);
	~KviActionEditorListView();
protected:
	virtual void resizeEvent(TQResizeEvent * e);
};

class KviActionEditor;

class KviSingleActionEditor : public TQWidget
{
	Q_OBJECT
  
public:
	KviSingleActionEditor(TQWidget * par,KviActionEditor * ed);
	~KviSingleActionEditor();
protected:
	KviActionEditor * m_pActionEditor;
	KviActionData * m_pActionData;
	TQLineEdit * m_pNameEdit;
	TQLineEdit * m_pVisibleNameEdit;
	TQComboBox * m_pCategoryCombo;
	KviScriptEditor * m_pScriptEditor;
	TQLineEdit * m_pKeySequenceEdit;
	TQLineEdit * m_pDescriptionEdit;
	TQLineEdit * m_pSmallIconEdit;
	TQLineEdit * m_pBigIconEdit;
	TQToolButton * m_pSmallIconButton;
	TQToolButton * m_pBigIconButton;
	KviStyledCheckBox * m_pNeedsContextCheck;
	KviStyledCheckBox * m_pNeedsConnectionCheck;
	KviStyledCheckBox * m_pEnableAtLoginCheck;
	KviStyledCheckBox * m_pSpecificWindowsCheck;
	KviStyledCheckBox * m_pWindowConsoleCheck;
	KviStyledCheckBox * m_pWindowChannelCheck;
	KviStyledCheckBox * m_pWindowQueryCheck;
	KviStyledCheckBox * m_pWindowDccChatCheck;
	KviStyledCheckBox * m_pConsoleOnlyIfUsersSelectedCheck;
	KviStyledCheckBox * m_pChannelOnlyIfUsersSelectedCheck;
	KviStyledCheckBox * m_pQueryOnlyIfUsersSelectedCheck;
public:
	KviActionData * actionData(){ return m_pActionData; };
	void setActionData(KviActionData * d);
	void commit();
protected slots:
	void chooseSmallIcon();
	void chooseBigIcon();
	void needsContextCheckToggled(bool);
	void needsConnectionCheckToggled(bool);
	void specificWindowsCheckToggled(bool);
	void channelQueryOrConsoleWindowCheckToggled(bool);
};

class TQSplitter;

class KviActionEditor : public TQWidget
{
	friend class KviActionEditorWindow;
	Q_OBJECT
  
public:
	KviActionEditor(TQWidget * par);
	~KviActionEditor();
protected:
	KviActionEditorListView * m_pListView;
	KviSingleActionEditor * m_pSingleActionEditor;
	TQSplitter * m_pSplitter;
	TQPushButton * m_pNewActionButton;
	TQPushButton * m_pDeleteActionsButton;
	TQPushButton * m_pExportActionsButton;
public:
	void commit();
	bool actionExists(const TQString &szName);
protected:
	int selectedCount();
	TQString nameForAutomaticAction(const TQString &szTemplate);
protected slots:
	void currentChanged(KviTalListViewItem * it);
	void newAction();
	void deleteActions();
	void exportActions();
};


class KviActionEditorWindow : public KviWindow
{
	Q_OBJECT
  
public:
	KviActionEditorWindow(KviFrame * lpFrm);
	~KviActionEditorWindow();
protected:
	KviActionEditor * m_pEditor;
	TQWidget         * m_pBase;
protected:
	virtual TQPixmap * myIconPtr();
	virtual void resizeEvent(TQResizeEvent *e);
	virtual void getConfigGroupName(KviStr &szName);
	virtual void saveProperties(KviConfig *);
	virtual void loadProperties(KviConfig *);
protected slots:
	void cancelClicked();
	void okClicked();
	void applyClicked();
};

#endif //_ACTIONEDITOR_H_
