/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2006 Eike Hein <hein@kde.org>
*/

#ifndef DCCCHAT_H
#define DCCCHAT_H

#include "chatwindow.h"


class TQSplitter;

class IRCInput;
class KLineEdit;
class Server;

namespace KNetwork
{
    class TDEServerSocket;
    class KStreamSocket;
}

namespace Konversation
{
    class TopicLabel;
}

class DccChat : public ChatWindow
{
    Q_OBJECT
  

        public:
        DccChat(TQWidget* parent, bool listen, Server* server, const TQString& ownNick, const TQString& partnerNick, const TQString& partnerHost = TQString(), int partnerPort = 0);
        ~DccChat();

        virtual TQString getTextInLine();
        virtual bool closeYourself(bool askForConfirmation=true);
        virtual bool canBeFrontView();
        virtual bool searchView();

        int getOwnPort();

        virtual void setChannelEncoding(const TQString& encoding);
        virtual TQString getChannelEncoding();
        virtual TQString getChannelEncodingDefaultDesc();

        virtual bool isInsertSupported() { return true; }

        TQString getOwnNick() { return m_ownNick; }

    public slots:
        void appendInputText(const TQString& s, bool fromCursor);
        void updateAppearance();

    protected slots:
        void lookupFinished();
        void dccChatConnectionSuccess();
        void dccChatBroken(int error);
        void readData();
        void dccChatTextEntered();
        void sendDccChatText(const TQString& sendLine);
        void textPasted(const TQString& text);
        void heardPartner();
        void socketClosed();

    protected:
        void listenForPartner();
        void connectToPartner();

        virtual void showEvent(TQShowEvent* event);

        /** Called from ChatWindow adjustFocus */
        virtual void childAdjustFocus();

        TQString m_ownNick;
        TQString m_partnerNick;
        TQString m_partnerHost;
        int m_partnerPort;
        TQString host;

        //TQString m_ip;
        int m_ownPort;

        TQSplitter* m_headerSplitter;
        Konversation::TopicLabel* m_sourceLine;
        IRCInput* m_dccChatInput;
        KNetwork::KStreamSocket* m_dccSocket;
        KNetwork::TDEServerSocket* m_listenSocket;

        TQString m_encoding;

        bool m_initialShow;
};
#endif
