/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2005, 2006 by Kevin Gilbert                             *
 *   kev.gilbert@cdu.edu.au                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 ***************************************************************************/

#ifndef _COMMONWIDGET_H_
#define _COMMONWIDGET_H_

#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif

#include <ntqwidget.h>
#include "global.h"

//	forward class definitions
//	=========================

class TDEConfig;
class TQCheckBox;
class TQComboBox;
class TQLineEdit;
class TQListBox;
class TQListBoxItem;
class TQPushButton;
class TQRadioButton;
class TQStringList;

//	CommonWidget class definition
//	=============================

class CommonWidget : public TQWidget
{	Q_OBJECT

	public:
		CommonWidget( TQWidget* parent, const char* name = NULL );
		virtual ~CommonWidget( );

		void finaliseInitialisation( );
		bool getOptions( );
		void readProfile( TDEConfig* config );
		void saveProfile( TDEConfig* config );
		void setInitialValues( );

		TQString      getHostName( )          const;
		int          hostCurrentItem( )      const { return m_hostCurrentItem;      }
		TQString      host( )                 const { return m_host;                 }
		int          portRangeCurrentItem( ) const { return m_portRangeCurrentItem; }
		TQStringList* portRanges( )           const { return m_portRanges;           }
		bool         portRangesState( )      const { return m_portRangesState;      }
		bool         resovleAlwaysState( )   const { return m_resovleAlwaysState;   }
		bool         resovleDefaultState( )  const { return m_resovleDefaultState;  }
		bool         resovleNeverState( )    const { return m_resovleNeverState;    }

	signals:
		void disableFastScan( );
		void displayDocBook( const TQString& );
		void displayHelp( const TQString& );
		void displayUnknown( );
		void optionsDirty( );
		void targetChanged( const TQString& );

	public slots:
		void slotDisablePortRanges( );

	private slots:
		void slotHostActivated( int index );
		void slotHostButtonClicked( );
		void slotHostTextChanged( const TQString& text );
		void slotPortRangeActivated( int index );
		void slotPortRangeAddClicked( );
		void slotPortRangeDeleteClicked( );
		void slotPortRangeButtonClicked( );
		void slotPortRangeDoubleClicked( TQListBoxItem* item );
		void slotPortRangeHighlighted( );
		void slotPortRangesClicked( );
		void slotPortRangeTextChanged( const TQString& text );
		void slotWhatsThisClicked( );

	private:
		bool buildPortRangesTables( const boolPtr tcpPorts, const boolPtr udpPorts );
		void createLayout( );
		void enablePortRangeWidgets( );
		void getHosts( TQStringList* hosts );
		void getPortRanges( TQStringList* portRanges );
		bool portRangesOverlapping( const ushort portFirst, const ushort portLast );
		bool validatePortRange( TQString& text );
		bool validatePortRangeText( TQString& text, uint& portFirst, uint& portLast );

		//	protocol indices
		//	================
		
		enum Protocol
		{	BothProtocol,
			TCPProtocol,
			UDPProtocol
		};

		TQString       m_host;
		TQPushButton*  m_hostButton;
		TQComboBox*    m_hostComboBox;
		int           m_hostCurrentItem;
		TQStringList*  m_hosts;
		TQPushButton*  m_portRangeAddButton;
		TQPushButton*  m_portRangeButton;
		TQComboBox*    m_portRangeComboBox;
		int           m_portRangeCurrentItem;
		TQPushButton*  m_portRangeDeleteButton;
		bool          m_portRangeIgnoreChange;
		TQLineEdit*    m_portRangeLineEdit;
		TQListBox*     m_portRangeListBox;
		TQStringList*  m_portRanges;
		TQCheckBox*    m_portRangesCheckBox;
		bool          m_portRangesState;
		TQRadioButton* m_resovleAlwaysRadio;
		bool          m_resovleAlwaysState;
		TQRadioButton* m_resovleDefaultRadio;
		bool          m_resovleDefaultState;
		TQRadioButton* m_resovleNeverRadio;
		bool          m_resovleNeverState;
};

#endif	// _COMMONWIDGET_H_
