/***************************************************************************
                          sq_glview.h  -  description
                             -------------------
    begin                : Thu Nov 29 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_GLVIEW_H
#define SQ_GLVIEW_H

#include <tqobject.h>
#include <tqmap.h>
#include <tqstring.h>

class SQ_TextSetter : public TQObject
{
    Q_OBJECT
  

    public:
        SQ_TextSetter(TQObject *parent = 0);
        ~SQ_TextSetter();

        void setText(const TQString &);

        TQString text() const;

    signals:
        void changed();

    private:
        TQString dest;
};

inline
TQString SQ_TextSetter::text() const
{
    return dest;
}

/***********************************************/

class SQ_GLView : public TQObject
{
    Q_OBJECT
  

    public:
        SQ_GLView();
        ~SQ_GLView();

        SQ_TextSetter* sbarWidget(const TQString &);

        void resetStatusBar();

        static SQ_GLView* window() { return m_inst; }

    signals:
        void message(const TQString &);

    private slots:
        void slotChanged();

    private:
        static SQ_GLView *m_inst;

        typedef TQMap<TQString, SQ_TextSetter*> SQ_Setters;

        SQ_Setters map;
        SQ_TextSetter *tmp;
};

#endif
