/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�lien G�teau
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/

#include "documentanimatedloadedimpl.moc"

// TQt
#include <tqstring.h>
#include <tqtimer.h>

// KDE
#include <kdebug.h>
#include <tdelocale.h>
namespace Gwenview {

// Local

#undef ENABLE_LOG
#undef LOG
//#define ENABLE_LOG
#ifdef ENABLE_LOG
#define LOG(x) kdDebug() << k_funcinfo << x << endl
#else
#define LOG(x) ;
#endif

class DocumentAnimatedLoadedImplPrivate {
public:
	ImageFrames mFrames;
	int mCurrentFrame;
	TQTimer mFrameTimer;
};


DocumentAnimatedLoadedImpl::DocumentAnimatedLoadedImpl(Document* document, const ImageFrames& frames)
: DocumentLoadedImpl(document) {
	LOG("" << mDocument->url().prettyURL() << ", frames: " << frames.count() );
	d=new DocumentAnimatedLoadedImplPrivate;
	d->mFrames = frames;
	d->mCurrentFrame = -1;
	connect( &d->mFrameTimer, TQT_SIGNAL( timeout()), TQT_SLOT( nextFrame()));
}

void DocumentAnimatedLoadedImpl::init() {
	DocumentLoadedImpl::init();
	nextFrame();
}

void DocumentAnimatedLoadedImpl::nextFrame() {
	++d->mCurrentFrame;
	if( d->mCurrentFrame == int( d->mFrames.count())) d->mCurrentFrame = 0;
	d->mFrameTimer.start( TQMAX( 10, d->mFrames[ d->mCurrentFrame ].delay ));
// NOTE! If this ever gets changed to already animate the picture while it's still
// loading, with MNG the frame delay gets announced only after the frame is ready.
// See ImageLoader::frameDone() .
	LOG("" << d->mCurrentFrame );

	setImage(d->mFrames[ d->mCurrentFrame ].image);
	emitImageRectUpdated();
}

DocumentAnimatedLoadedImpl::~DocumentAnimatedLoadedImpl() {
	delete d;
}


void DocumentAnimatedLoadedImpl::transform(ImageUtils::Orientation orientation) {
	for( ImageFrames::Iterator it = d->mFrames.begin(); it != d->mFrames.end(); ++it ) {
	        (*it).image = ImageUtils::transform( (*it).image, orientation );
	}
	setImage( d->mFrames[ d->mCurrentFrame ].image);
	emitImageRectUpdated();
}


TQString DocumentAnimatedLoadedImpl::localSave(TQFile* /*file*/, const TQCString& /*format*/) const {
	return i18n("Sorry, cannot save animated images.");
}

} // namespace
