/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2006-11-11
 * Description : a popup menu with a decorative graphic banner
 *               at the left border.
 * 
 * Copyright (C) 1996-2000 the kicker authors.
 * Copyright (C) 2005 Mark Kretschmann <markey@web.de>
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef DPOPUPMENU_H
#define DPOPUPMENU_H

// TQt includes.

#include <tqcolor.h>
#include <tqimage.h>
#include <tqrect.h>

// KDE includes.

#include <tdepopupmenu.h>

// Local includes.

#include "digikam_export.h"

class TQSize;

namespace Digikam
{

class DIGIKAM_EXPORT DPopupMenu : public TDEPopupMenu
{

public:

    DPopupMenu(TQWidget *parent=0, const char *name=0);
    ~DPopupMenu();

    int sidePixmapWidth() const;

private:

    /** Loads and prepares the sidebar image */
    void generateSidePixmap();

    /** Returns the available size for the image */
    TQRect sideImageRect() const;

    /** Calculates a color that matches the current colorscheme */
    TQColor calcPixmapColor();

    void setMinimumSize(const TQSize& s);
    void setMaximumSize(const TQSize& s);
    void setMinimumSize(int w, int h);
    void setMaximumSize(int w, int h);

    void resizeEvent(TQResizeEvent* e);
    void resize(int width, int height);

    void paintEvent(TQPaintEvent* e);
};

}  // namespace Digikam

#endif /*DPOPUPMENU_H*/
